<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        editRepDefGeneralPage.jsp
  -- Controller:  eml/ip/ui/edit/IPRepDefEditController.java
  --
  -- Description: The General Tab for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>


<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@repDefEditBean@servletRequest"/>
</uix:metaContainer>

    <%@ include file="/oemTitle.jspf" %>         

<uix:body>

<%-- HTML Form --%>
<uix:form name="editRepDefForm" 
         method="post"
         destinationBinding="formDestinationAccess@repDefUIBean@servletRequest">
<uix:formValue name="pageName" value="/ip/edit/editRepDefAccessPage"/>
<uix:formValue name="reportID" valueBinding="reportGUID@repDefEditBean@servletRequest"/>     
<uix:pageLayout titleBinding="header@repDefUIBean@servletRequest">

<%@ include file="/oemGlobal.jspf" %>

  <%-- Warning/Error display --%>
        <uix:messageBox messageType="warning"
                        rendered="false"
                        renderedBinding="warningOccurred@repDefUIBean@servletRequest">
          <uix:contents childDataBinding="warningList@repDefUIBean@servletRequest">
            <uix:styledText textBinding="message"/>
          </uix:contents>
        </uix:messageBox>
        <uix:messageBox messageType="error"
                        rendered="false"
                        renderedBinding="errorOccurred@repDefUIBean@servletRequest">
          <uix:contents childDataBinding="errorList@repDefUIBean@servletRequest">
            <uix:styledText textBinding="message"/>
          </uix:contents>
        </uix:messageBox>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/ip/edit/editRepDefTabsInclude.jsp" />
      <uix:ref refID="editRepDefTabsInclude" />
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>
    <uix:stackLayout>
    <uix:header textBinding="IP_ACCESS_ADMINS_AND_ROLES@ipBundle">
      <uix:stackLayout>
        <uix:styledText styleClass="oraFieldText" 
          textBinding="IP_ACCESS_INSTRUCTION@ipBundle"/>
        <uix:ref refID="INCLUDING_PAGE_NODE" />
      </uix:stackLayout>
    </uix:header>

    <%-- Checkbox - publish to public  --%>
    <uix:rowLayout width="500">
      <uix:contents>
        <uix:header textBinding="IP_ACCESS_REPORTS_WEBSITE_HEADER@ipBundle"
                    renderedBinding="showPublishToPublic@repDefEditBean@servletRequest">
          <uix:stackLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="IP_ACCESS_REPORTS_WEBSITE_INSTR1@ipBundle"/>
            <uix:spacer height="5"/>
            <uix:styledText styleClass="OraInstructionText" textBinding="IP_ACCESS_REPORTS_WEBSITE_INSTR2@ipBundle"/>
            <uix:spacer height="10"/>
            <uix:messageCheckBox name="publishToPublicChecked"
                                 textBinding="IP_ACCESS_REPORTS_WEBSITE_CHECKBOX@ipBundle"                   
                                 checkedBinding="publishToPublic@repDefEditBean@servletRequest"
                                 tipBinding="IP_ACCESS_REPORTS_WEBSITE_TIP@ipBundle"/>
      
            <uix:spacer height="10"/>
            <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText" textBinding="IP_ACCESS_RELATED_LINK@ipBundle"/>
               <uix:spacer width="5"/>
               <uix:link destinationBinding="publicReportsPage@repDefEditBean@servletRequest"
                           textBinding="IP_PUBLIC_REPORT_PAGE_TEXT@ipBundle"/>
            </uix:rowLayout>
          </uix:stackLayout>
        </uix:header>
      </uix:contents>
    </uix:rowLayout>
    <uix:spacer height="30"/>
    </uix:stackLayout>

    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/ip/edit/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</uix:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



