<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        editRepDefElementsPage.jsp
  -- Controller:  eml/ip/ui/edit/IPRepDefEditController.java
  --
  -- Description: The Elements Tab for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@repDefUIBean@servletRequest"/>
</uix:metaContainer>

    <%@ include file="/oemTitle.jspf" %>         

<uix:body>

<%-- HTML Form --%>
<uix:form name="editRepDefForm" 
         method="post"
         destinationBinding="formDestination@repDefUIBean@servletRequest">
<uix:formValue name="pageName" value="/ip/edit/editRepDefElementsPage"/>
<uix:formValue name="reportID" valueBinding="reportGUID@repDefEditBean@servletRequest"/>     
<uix:pageLayout titleBinding="header@repDefUIBean@servletRequest">

<%@ include file="/oemGlobal.jspf" %>

  <%-- Warning/Error display --%>
  <%-- oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/  --%>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/ip/edit/editRepDefTabsInclude.jsp" />
      <uix:ref refID="editRepDefTabsInclude" />
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

      <uix:table     name="elementsTable"
                     widthBinding="elemWidth@repDefUIBean@servletRequest"                     
                     tableDataBinding="elemTableData@repDefEditBean@servletRequest"
                     columnHeaderDataBinding="elemColumnHeaderData@repDefUIBean@servletRequest"
                     columnFormatsBinding="elemColumnFormats@repDefUIBean@servletRequest"
                     columnHeaderFormatsBinding="elemColumnHeaderFormats@repDefUIBean@servletRequest"
                     alternateTextBinding="ADD_ELEMENTS_INSTRUCTION@ipBundle"
                     blockSizeBinding="elemBlockSize@repDefUIBean@servletRequest"
                     valueBinding="elemValue@repDefUIBean@servletRequest" 
                     minValueBinding="elemMinValue@repDefUIBean@servletRequest" 
                     maxValueBinding="elemMaxValue@repDefUIBean@servletRequest"
                     formSubmittedBinding="elemFormSubmitted@repDefUIBean@servletRequest" 
                     summary="ELEMENTS_TABLE_SUMMARY@ipBundle"
                     > 

        <uix:tableActions>    
          <uix:flowLayout>
            <uix:contents>
              <uix:submitButton textBinding="ADD@ipBundle"
                                name="event"
                                value="doAddElements"
                                rendered="true"
                                renderedBinding="allowEdit@repDefEditBean@servletRequest"/>
              <uix:submitButton textBinding="LAYOUT@ipBundle"
                                name="event"
                                value="doLayout"
                                disabledBinding="disableLayoutButton@repDefEditBean@servletRequest"
                                rendered="true"
                                renderedBinding="allowEdit@repDefEditBean@servletRequest"/>  
            </uix:contents>
          </uix:flowLayout>
        </uix:tableActions>    

        <uix:tableFormat tableBanding="rowBanding"/>

        <uix:columnHeaderStamp>
          <uix:styledText textBinding="text"/>
        </uix:columnHeaderStamp>
        <uix:contents>
            <%-- TODO? RenderedBinding does not seem to be implemented --TBH --%>
            <uix:styledText textBinding="elementDisplayName" renderedBinding="elementNameRendered" />
            <uix:styledText textBinding="elementHeader" renderedBinding="elementHeaderRendered" />
            <%--<uix:styledText textBinding="elementDisplayType" renderedBinding="elementTypeRendered" /> --%>
            <uix:styledText textBinding="elementTargetNames" renderedBinding="elementTargetsRendered" />
        </uix:contents>

        <uix:column
          rendered="true"
          renderedBinding="allowEdit@repDefEditBean@servletRequest">
          <uix:columnHeader>
            <uix:styledText textBinding="SET_PARAMETERS@ipBundle"/>
          </uix:columnHeader>
          <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
            <uix:image
              renderedBinding="showConfigureButton"
              source="/em/images/configure_enabled.gif"
              destination="#"
              onClickBinding="configureCommand"
              width="24"
              height="24"
              shortDescBinding="SET_PARAMETERS@ipBundle"/>
        </uix:column>            

        <uix:column 
          rendered="true"
          renderedBinding="allowEdit@repDefEditBean@servletRequest">
          <uix:columnHeader>
            <uix:styledText textBinding="REMOVE@ipBundle"/>
          </uix:columnHeader>
          <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
            <uix:image
              source="/em/images/deleteicon_enabled.gif"
              destination="#"
              onClickBinding="deleteCommand"
              width="24"
              height="24"
              shortDescBinding="REMOVE@ipBundle"/>
        </uix:column>

      </uix:table>  
      
    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/ip/edit/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</uix:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



