<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        editRepDefGeneralPage.jsp
  -- Controller:  eml/ip/ui/edit/IPRepDefEditController.java
  --
  -- Description: The General Tab for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
<%@ page import='oracle.sysman.eml.ip.ui.edit.IPRepDefEditController'%>
<%@ page import='oracle.sysman.eml.ip.IPConstants'%>
<%@ page import='oracle.sysman.eml.ip.render.JITSelectionBean'%>
<%@ page import='oracle.sysman.emSDK.tgt.sel.TargetSelectionUtil'%>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="genTitle@repDefUIBean@servletRequest"/>
</uix:metaContainer>

    <%@ include file="/oemTitle.jspf" %>         


<uix:body>

<%-- HTML Form --%>
<uix:form name="editRepDefForm" 
         method="post"
         destinationBinding="formDestination@repDefUIBean@servletRequest">
<uix:formValue name="pageName" value="/ip/edit/editRepDefGeneralPage"/>
<uix:formValue name="reportID" valueBinding="reportGUID@repDefEditBean@servletRequest"/>     
<uix:formValue name="timePeriod" />
<uix:formValue name="selTimeZone"/>
<uix:pageLayout titleBinding="header@repDefUIBean@servletRequest">

<%@ include file="/oemGlobal.jspf" %>

  <%-- Warning/Error display --%>
        <uix:messageBox messageType="warning"
                        rendered="false"
                        renderedBinding="warningOccurred@repDefUIBean@servletRequest">
          <uix:contents childDataBinding="warningList@repDefUIBean@servletRequest">
            <uix:styledText textBinding="message"/>
          </uix:contents>
        </uix:messageBox>
        <uix:messageBox messageType="error"
                        rendered="false"
                        renderedBinding="errorOccurred@repDefUIBean@servletRequest">
          <uix:contents childDataBinding="errorList@repDefUIBean@servletRequest">
            <uix:styledText textBinding="message"/>
          </uix:contents>
        </uix:messageBox>
        
        
  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>

    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/ip/edit/editRepDefTabsInclude.jsp"/>
      <uix:ref refID="editRepDefTabsInclude"/>
    </uix:subTabs>
    <%-- START: TAB CONTENTS starts here --%>
    <uix:spacer height="10"/>

    <uix:tableLayout>
      <uix:rowLayout vAlign="top">

        <uix:labeledFieldLayout columns="2">
          <uix:contents>
            <uix:messageTextInput 
              promptBinding="TITLE@ipBundle" 
              name="title" id="TitleInput" 
              columns="50" 
              maximumLength="<%=IPConstants.TABLE_MAX_TITLE_LENGTH%>"
              textBinding="title@repDefEditBean@servletRequest" 
              required="uiOnly"
              disabledBinding="ifStored@repDefEditBean@servletRequest"/>
            <uix:spacer width="1"/>
            <uix:spacer width="1"/>
          </uix:contents>
          <uix:contents>
            <uix:spacer/>
            <uix:messageText 
              messageType="error" 
              messageBinding="title@errors@servletRequest"/>
            <uix:spacer width="1"/>
          </uix:contents>
          <uix:contents>
            <uix:messageChoice 
              promptBinding="CATEGORY@ipBundle"
              id="categoryChoice" 
              name="categoryChoice" 
              selectedValueBinding="categoryNameNLS@repDefEditBean@servletRequest"
              disabledBinding="ifStored@repDefEditBean@servletRequest">
              <uix:contents 
                childDataBinding="genCategoryChoiceList@repDefUIBean@servletRequest">
                <uix:option 
                  textBinding="jtext" 
                  valueBinding="jval"/>
              </uix:contents>
            </uix:messageChoice>
            <uix:spacer width="1"/>
            <uix:submitButton textBinding="ADD_CATEGORY@ipBundle" 
              shortDescBinding="ADD_CATEGORY_DESC@ipBundle" 
              name="event" 
              value="doAddCategory"
              rendered="true"
              renderedBinding="allowEdit@repDefEditBean@servletRequest"/>
          </uix:contents>
          <uix:contents>
            <uix:spacer/>
            <uix:messageText 
              messageType="error" 
              messageBinding="category@errors@servletRequest"/>
            <uix:spacer width="1"/>
            <uix:spacer width="1"/>
          </uix:contents>
          <uix:contents>
            <uix:messageChoice 
              id="subcategoryChoice" 
              promptBinding="SUBCATEGORY@ipBundle"
              name="subcategoryChoice" 
              selectedValueBinding="subcategoryNameNLS@repDefEditBean@servletRequest"
              disabledBinding="ifStored@repDefEditBean@servletRequest">
              <uix:contents 
                childDataBinding="genSubcategoryChoiceList@repDefUIBean@servletRequest">
                <uix:option 
                  textBinding="jtext" 
                  valueBinding="jval"/>
              </uix:contents>
            </uix:messageChoice>
            <uix:spacer width="1"/>
            <uix:submitButton 
              textBinding="ADD_SUBCATEGORY@ipBundle" 
              shortDescBinding="ADD_SUBCATEGORY_DESC@ipBundle" 
              name="event" 
              value="doAddSubcategory"
              rendered="true"
              renderedBinding="allowEdit@repDefEditBean@servletRequest"/>
          </uix:contents>
          <uix:contents>
            <uix:spacer/>
            <uix:messageText 
              messageType="error" 
              messageBinding="subcategory@errors@servletRequest"/>
            <uix:spacer/>
          </uix:contents>
        </uix:labeledFieldLayout>

        <uix:spacer width="15"/>
        <uix:tableLayout>
          <uix:rowLayout vAlign="top">
            <uix:messageTextInput 
              name="description" 
              promptBinding="DESCRIPTION@ipBundle" 
              id="DescriptionInput" columns="40" 
              rows="3" 
              maximumLength="<%=IPConstants.TABLE_MAX_DESC_LENGTH%>"
              textBinding="description@repDefEditBean@servletRequest"
              disabledBinding="ifStored@repDefEditBean@servletRequest"/>
          <uix:rowLayout vAlign="top">
          </uix:rowLayout>
            <uix:messageText 
              messageType="error" 
              messageBinding="description@errors@servletRequest"/>
          </uix:rowLayout>
        </uix:tableLayout>

      </uix:rowLayout>
    </uix:tableLayout>

      <uix:header textBinding="TARGETS@ipBundle">
        <uix:stackLayout>
          <uix:styledText 
            styleClass="OraInstructionText" 
            textBinding="generalPageInstruction@repDefEditBean@servletRequest"/>
          <uix:spacer height="5"/>
          <uix:radioButton 
            name="targetSelectionModeRadio" 
            textBinding="SELECT_TARGETS_ON_DEMAND@ipBundle" 
            value="<%=IPConstants.ON_DEMAND_MODE%>" 
            selectedValueBinding="targetSelectionMode@repDefEditBean@servletRequest"
            disabledBinding="ifStored@repDefEditBean@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="30"/>
            <uix:messageChoice id="targetTypeChoice" 
                name="targetTypeChoice" 
                promptBinding="REPORTS_FILTER_TARGET_TYPE@ipBundle" 
                selectedValueBinding="targetType@repDefEditBean@servletRequest"
                tipBinding="ELEMENTS_LIMITED_TO_TARGET_TYPE@ipBundle"
                disabledBinding="ifStored@repDefEditBean@servletRequest">
              <uix:contents 
                childDataBinding="targetTypeChoiceList@repDefUIBean@servletRequest">
                <uix:option 
                  textBinding="text" 
                  valueBinding="value"/>
              </uix:contents>
            </uix:messageChoice>
          </uix:rowLayout>
          <uix:radioButton 
            name="targetSelectionModeRadio" 
            textBinding="USE_REPORT_TARGET@ipBundle" 
            value="<%=IPConstants.TARGET_LIST_MODE%>" 
            selectedValueBinding="targetSelectionMode@repDefEditBean@servletRequest"
            disabledBinding="ifStored@repDefEditBean@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="30"/>
            <uix:dataScope currentDataBinding="@servletRequest">
              <%@ include file="/ip/render/selectTargets.jsp" %>
            </uix:dataScope>
          </uix:rowLayout>
        </uix:stackLayout>
      </uix:header>

      <uix:header
        textBinding="PRIVILEGES@ipBundle">
        <uix:stackLayout>
            <uix:styledText 
              styleClass="OraInstructionText" 
              textBinding="targetPrivilegesInstructions@repDefEditBean@servletRequest"/>
            <uix:spacer height="5"/>
            <uix:messageCheckBox
              name="<%=IPRepDefEditController.GENERATE_CONTEXT_OPTION_BOX%>"
              tipBinding="generateOwnerContextTip@repDefEditBean@servletRequest"
              checkedBinding="generateOwnerContext@repDefEditBean@servletRequest"
              textBinding="generateOwnerContextText@repDefEditBean@servletRequest"
              disabledBinding="ifStored@repDefEditBean@servletRequest"/>
        </uix:stackLayout>
      </uix:header>

      <uix:header textBinding="TIME_PERIOD_LABEL@ipBundle">
        <uix:stackLayout>
          <uix:checkBox
              name="<%=IPRepDefEditController.REPORT_TIME_PERIOD_OPTION_BOX%>"
              checkedBinding="reportTimePeriodOption@repDefEditBean@servletRequest"
              textBinding="REPORT_TIME_PERIOD_OPTION@ipBundle"
              disabledBinding="ifStored@repDefEditBean@servletRequest"/>
          <uix:spacer height="5" />
          <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="30"/>
                <uix:styledText 
                  textBinding="TIME_PERIOD_LABEL@ipBundle"
                  styleClass="OraPromptText"/>
                <uix:spacer width="5"/>                
                <uix:styledText 
                  textBinding="timePeriodDisplayText@repDefUIBean@servletRequest" 
                  styleClass="OraDataText"/>
                <uix:spacer width="5"/>
                <uix:button 
                  name="setTimePeriod"
                  textBinding="SET_TIME_PERIOD@ipBundle" 
                  shortDescBinding="SET_TIME_PERIOD_DESC@ipBundle" 
                  destinationBinding="destinationURL@repDefUIBean@servletRequest"
                  rendered="true"
                  renderedBinding="allowEdit@repDefEditBean@servletRequest"/>
              </uix:contents>
          </uix:rowLayout>
          <uix:spacer height="5" />
          <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="30"/>
                  <uix:checkBox
                    name="<%=IPRepDefEditController.REPORT_TIME_PERIOD_USER_CUST_BOX%>"
                    checkedBinding="reportTimePeriodUserCust@repDefEditBean@servletRequest"
                    textBinding="REPORT_TIME_PERIOD_USER_CUST@ipBundle"
                    disabledBinding="ifStored@repDefEditBean@servletRequest"/>
              </uix:contents>
          </uix:rowLayout>

        </uix:stackLayout>
      </uix:header>

      <uix:hideShowHeader 
        textBinding="OPTIONS@ipBundle" 
        formSubmitted="true"
        id="<%=IPRepDefEditController.GENERAL_OPTIONS_HEADER%>"
        partialRenderMode="self"
        disclosedBinding="discloseGeneralOptionsHeader@repDefUIBean@servletRequest">
        <uix:contents>
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat
                vAlign="top"
                rowSpan="4">
                <uix:styledText 
                  styleClass="OraInstructionText"
                  textBinding="VISUAL_STYLE@ipBundle"/>
                <uix:spacer
                  width="10"
                  height="0"/>
              </uix:cellFormat>   
              <uix:cellFormat>
                <uix:radioButton
                  selectedValueBinding="style@repDefEditBean@servletRequest"
                  name="<%=IPRepDefEditController.STYLE_RADIO_BUTTON%>"
                  value="<%=IPConstants.BLAF_STYLE%>"
                  textBinding="VISUAL_STYLE_STANDARD@ipBundle"
                  disabledBinding="ifStored@repDefEditBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer
                  width="20"
                  height="0"/>
                <uix:checkBox
                  name="<%=IPRepDefEditController.HEADERS_CHECK_BOX%>"
                  checkedBinding="showNavigation@repDefEditBean@servletRequest"
                  textBinding="SHOW_HEADERS_OPTION@ipBundle"
                  disabledBinding="ifStored@repDefEditBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer
                  width="20"
                  height="0"/>
                <uix:checkBox
                  name="<%=IPRepDefEditController.TOC_CHECK_BOX%>"
                  checkedBinding="showTOC@repDefEditBean@servletRequest"
                  textBinding="SHOW_TOC_OPTION@ipBundle"
                  disabledBinding="ifStored@repDefEditBean@servletRequest"/>
               </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:radioButton
                  selectedValueBinding="style@repDefEditBean@servletRequest"
                  name="<%=IPRepDefEditController.STYLE_RADIO_BUTTON%>"
                  value="<%=IPConstants.DASHBOARD_STYLE%>"
                  textBinding="VISUAL_STYLE_DASHBOARD@ipBundle"
                  disabledBinding="ifStored@repDefEditBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

        </uix:contents>
      </uix:hideShowHeader>
   
      <uix:spacer height="10"/>

  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/ip/edit/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>



    <uix:script text="
		/*
		 * Javascript for opening popup page, setting time range
		 */

        function openTimePeriodPopup(tableOp, timeText, timezone)
        {
          var srcUrl = '/em/ip/render/elem/emr/TPSelector/tpTimeRangePopup.jsp?selTimeValue=' + timeText + '&selTimeZone=' + timezone;
          
          openWindow(window, srcUrl, 'showTimeRange', {width:700,height:450},true,'dialog',myCallBack);   
        }
        function myCallBack()
        {
        } 

        function generateStrTimeRange(selTime,selTimeZone)
        {
            document.editRepDefForm.timePeriod.value = selTime;
            document.editRepDefForm.selTimeZone.value = selTimeZone;
            submitForm('editRepDefForm',1,{'event':'doneSetTimePeriod'});
            return false;
        }
        
        " />


</uix:pageLayout>
</uix:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



