<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        editRepDefPublishPage.jsp
  -- Controller:  eml/ip/ui/edit/IPRepDefPublishController.java
  --
  -- Description: The Publish/Schedule Tab for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="ipBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@repDefEditBean@servletRequest"/>
</uix:metaContainer>

    <%@ include file="/oemTitle.jspf" %>         

<uix:body>
        
<%-- HTML Form --%>
<uix:form name="editRepDefForm" 
         method="post"
         destinationBinding="formDestinationPublish@repDefUIBean@servletRequest">
<uix:formValue name="pageName" value="/ip/edit/editRepDefPublishPage"/>
<uix:formValue name="reportID" valueBinding="reportGUID@repDefEditBean@servletRequest"/>     


<uix:pageLayout titleBinding="header@repDefUIBean@servletRequest">

<%@ include file="/oemGlobal.jspf" %>

  <%-- Warning/Error display --%>
        <uix:messageBox messageType="warning"
                        rendered="false"
                        renderedBinding="warningOccurred@repDefUIBean@servletRequest">
          <uix:contents childDataBinding="warningList@repDefUIBean@servletRequest">
            <uix:styledText textBinding="message"/>
          </uix:contents>
        </uix:messageBox>
        <uix:messageBox messageType="error"
                        rendered="false"
                        renderedBinding="errorOccurred@repDefUIBean@servletRequest">
          <uix:contents childDataBinding="errorList@repDefUIBean@servletRequest">
            <uix:styledText textBinding="message"/>
          </uix:contents>
        </uix:messageBox>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/ip/edit/editRepDefTabsInclude.jsp" />
      <uix:ref refID="editRepDefTabsInclude" />
    </uix:subTabs>

    <uix:contents>
      <uix:stackLayout>
      <uix:styledText styleClass="oraFieldText" 
        textBinding="schedulePageInstruction@repDefEditBean@servletRequest"/>
      <uix:spacer height="20" width="0"/>
      
    <%-- ------------------------------------------------ --%>
    <%-- START: SCHEDULE/PUBLISH TAB CONTENTS starts here --%>
    <%-- ------------------------------------------------ --%>  

        <%-- Checkbox - Email options specified  --%>

        <uix:messageCheckBox name="scheduleReportChecked" 
                           prompt=""                     
                      textBinding="IP_SCHEDULE_BUTTON_TEXT@ipBundle"
                       tipBinding="scheduleHintText@repDefEditBean@servletRequest"
                   checkedBinding="scheduleChecked@repDefEditBean@servletRequest"
                  disabledBinding="disableScheduleCheckbox@repDefEditBean@servletRequest"/>          
                   
        <%-- Publish Job Information --%>     
        <%-- ----------------------- --%>
        <uix:spacer height="10"/>
        <uix:rowLayout width="100%"
                       renderedBinding="showPublishJobState@repDefUIBean@servletRequest">
        <uix:spacer width="40"/>
        <uix:tableLayout
             rendered="false"
             renderedBinding="showPublishJobState@repDefUIBean@servletRequest">
          <uix:contents>
             <%-- Enterprise Manager Job (shown if report is scheduled) --%>            
              <uix:rowLayout
                  rendered="false"    
                  renderedBinding="showJobNamePrompt@repDefUIBean@servletRequest">                            
              <uix:contents>
              <uix:cellFormat 
                  wrappingDisabled="true"
                  hAlign="right"
                  vAlign="top">    
                 <uix:styledText 
                      textBinding="IP_SCHEDULE_JOB_NAME_TEXT@ipBundle"
                      styleClass="OraPromptText"/>
              </uix:cellFormat>
              <%-- Enterprise Manager Name  --%>
              <uix:cellFormat>
                 <uix:spacer  width="10"  height="0"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText 
                     textBinding="jobName@repDefUIBean@servletRequest" 
                     styleClass="OraDataText"/>
              </uix:cellFormat>
              </uix:contents>
              </uix:rowLayout>

             <%-- Publish Job Status row --%>            
              <uix:rowLayout
                  rendered="false"    
                  renderedBinding="showJobStatusPrompt@repDefUIBean@servletRequest">                            
              <uix:contents>     
              <uix:cellFormat
                  wrappingDisabled="true"
                  hAlign="right"
                  vAlign="top">    
                 <uix:styledText 
                      textBinding="IP_SCHEDULE_JOB_STATUS@ipBundle"
                      styleClass="OraPromptText"/>
              </uix:cellFormat>
              <%-- status NLS text  --%>
              <uix:cellFormat>
                 <uix:spacer  width="10"  height="0"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText 
                     textBinding="jobStatusText@repDefUIBean@servletRequest" 
                     styleClass="OraDataText"/>
              </uix:cellFormat>
              </uix:contents>
              </uix:rowLayout> 

             <%-- Publish Job Output row --%>            
              <uix:rowLayout
                  rendered="false"    
                  renderedBinding="showJobOutput@repDefUIBean@servletRequest">                            
              <uix:contents>    
              <uix:cellFormat
                  wrappingDisabled="true"
                  hAlign="right"
                  vAlign="top">    
                 <uix:styledText 
                      textBinding="IP_SCHEDULE_JOB_OUTPUT@ipBundle"
                      styleClass="OraPromptText"/>
              </uix:cellFormat>
              <%-- job output cell (could be long)  --%>
              <uix:cellFormat>
                 <uix:spacer  width="10"  height="0"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText 
                     textBinding="jobOutputText@repDefUIBean@servletRequest" 
                     styleClass="OraDataText"/>
              </uix:cellFormat>
              </uix:contents>
              </uix:rowLayout>                                      
              
          </uix:contents>
         </uix:tableLayout>    
         </uix:rowLayout>

        <%--  Indent the schedule and email options to indicate that they are related  --%>
    
            <%-- --------------------- --%>
            <%-- SCHEDULE PAGE SEGMENT --%>
            <%-- --------------------- --%> 
            
            <uix:rowLayout width="100%">
            <uix:spacer width="20"/>
            <uix:header textBinding="IP_SCHEDULE_HEADER@ipBundle">
              <uix:contents>                             
                        <%-- include the schedule page segment --%>
                        <uix:ref refID="SCHEDULE_SEGMENT" />                
                <uix:spacer height="8" /> 
              </uix:contents>
            </uix:header>
            </uix:rowLayout>

            <%--  ------------------ --%>
            <%--  STORE PAGE SECTION --%>
            <%--  ------------------ --%>
            <uix:rowLayout
              width="100%">
              <uix:spacer
                width="16"
                height="1"/>
              <uix:header
                textBinding="IP_PURGE_STORE_HEADER@ipBundle">
                <uix:rowLayout>
                 <uix:spacer
                   width="0"
                   height="1"/> 
                 <uix:checkBox
                   name="storeReportChecked" 
                   textBinding="IP_PURGE_STORE_CHECKBOX@ipBundle"
                   checkedBinding="storeChecked@repDefEditBean@servletRequest" 
                   disabledBinding="readOnlySchedule@repDefEditBean@servletRequest"/>          
                </uix:rowLayout>
              </uix:header>  
            </uix:rowLayout>                       


            <%--  ------------------ --%>
            <%--  EMAIL PAGE SECTION --%>
            <%--  ------------------ --%>
            <uix:rowLayout width="100%">
            <uix:spacer width="26" height="1"/>
            <uix:header textBinding="IP_PURGE_EMAIL_HEADER@ipBundle">



            
             <%-- Checkbox - Email options specified  --%>

              <uix:rowLayout>
               <uix:spacer width="0" height="1"/> 
               <uix:checkBox name="emailReportChecked" 
                           textBinding="IP_PURGE_EMAIL_CHECKBOX@ipBundle"
                        checkedBinding="emailChecked@repDefEditBean@servletRequest" 
                        disabledBinding="readOnlySchedule@repDefEditBean@servletRequest"/>          
              </uix:rowLayout>

              <uix:spacer width="1" height="5"/>

              <uix:rowLayout>
              <uix:labeledFieldLayout labelWidth="0%" fieldWidth="0%" columns="1">

                <%-- Email from  --%>
                <uix:messageStyledText 
                             promptBinding="IP_PURGE_EMAIL_SENDER@ipBundle"
                                        id="emailFrom"
                               textBinding="emailFromText@repDefEditBean@servletRequest"/> 

                <%-- Email reply to  --%>
                <uix:messageTextInput name="emailSender"
                             promptBinding="IP_PURGE_EMAIL_REPLY_TO@ipBundle"
                                        id="emailSender"
                                   columns="75"
                               textBinding="emailSender@repDefEditBean@servletRequest"
                               disabledBinding="readOnlySchedule@repDefEditBean@servletRequest"/> 
                               
                <%-- Email recipients  --%>
                <uix:messageTextInput name="emailRecipients"
                             promptBinding="IP_PURGE_EMAIL_RECIPIENTS@ipBundle"
                                tipBinding="IP_PURGE_EMAIL_TIP@ipBundle"
                                         id="emailRecipients"
                                    columns="75"
                                       rows="3"
                                   textBinding="emailRecipients@repDefEditBean@servletRequest"
                                   disabledBinding="readOnlySchedule@repDefEditBean@servletRequest"/>
                                   
                <%-- Email subject  --%>                   
                <uix:messageTextInput name="emailSubject"
                             promptBinding="IP_PURGE_EMAIL_SUBJECT@ipBundle"
                                        id="emailSubject"
                                   columns="75"
                               textBinding="emailSubject@repDefEditBean@servletRequest"
                               disabledBinding="readOnlySchedule@repDefEditBean@servletRequest"/>                                   
              </uix:labeledFieldLayout>
              </uix:rowLayout>
            </uix:header>  
            </uix:rowLayout>                       
        </uix:stackLayout>
        
        <%--  ------------------ --%>
        <%--  PURGE PAGE SECTION --%>
        <%--  ------------------ --%>
        <uix:header textBinding="IP_PURGE_HEADER@ipBundle">
      
<uix:tableLayout>
<uix:rowLayout>
<uix:spacer width="0" height="1"/>
<uix:stackLayout>
      
           <uix:rowLayout>
             <uix:styledText styleClass="oraFieldText" textBinding="IP_PURGE_INFO_TEXT@ipBundle"/>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:spacer width="1" height="5"/>
           </uix:rowLayout>
   
          <uix:tableLayout>
        
         <uix:rowLayout>
              <%--  Enable Purge Policy button --%>
              <uix:radioButton name="purgeOptionsRadioButton"
                             textBinding="IP_PURGE_RADIO_NO_PURGE@ipBundle"
                             valueBinding="purgeNoPolicyMode@repDefEditBean@servletRequest"
                             selectedValueBinding="purgePolicyMode@repDefEditBean@servletRequest" /> 
           </uix:rowLayout>
           <%--  Purge based on retention time --%>
           <uix:rowLayout>
              <uix:radioButton name="purgeOptionsRadioButton"
                             textBinding="IP_PURGE_RADIO_PURGE_BY_INTERVAL@ipBundle"
                             valueBinding="purgeNumDaysMode@repDefEditBean@servletRequest"
                             selectedValueBinding="purgePolicyMode@repDefEditBean@servletRequest" />  
              <uix:spacer width="5"/>   
              
              <uix:textInput name="numIntervals"
                      id="numIntervals"
                      columns="10"
                      shortDescBinding="IP_PURGE_RADIO_PURGE_BY_INTERVAL@ipBundle"
                      textBinding="purgeNumIntervals@repDefEditBean@servletRequest"/>
                  <uix:spacer width="5" />              
              
              <uix:choice name="retentionInterval"
                          selectedValueBinding="purgeRetentionInterval@repDefEditBean@servletRequest"
                          shortDescBinding="IP_PURGE_RADIO_PURGE_BY_INTERVAL@ipBundle">                                 
                          <uix:contents childDataBinding="retentionIntervalOptions@repDefEditBean@servletRequest">
                              <uix:option textBinding="text"
                                          valueBinding="value"/>                                                                                                 
                          </uix:contents>                
              </uix:choice>                               
              
           </uix:rowLayout>
           <%--  Purge based on number of versions --%>
           <uix:rowLayout>
            <uix:radioButton name="purgeOptionsRadioButton"
                             textBinding="IP_PURGE_RADIO_PURGE_BY_VERSION@ipBundle"
                             valueBinding="purgeNumVersionsMode@repDefEditBean@servletRequest"
                             selectedValueBinding="purgePolicyMode@repDefEditBean@servletRequest" /> 
              <uix:spacer width="5"/>     
              
              <uix:textInput name="purgeVersions"
                             id="purgeVersions"
                             columns="10"
                             shortDescBinding="IP_PURGE_RADIO_PURGE_BY_VERSION@ipBundle"
                             textBinding="purgeKeepVersions@repDefEditBean@servletRequest"/>                                                                                                                                                                                            
           </uix:rowLayout>           
 
           <uix:rowLayout>
             <uix:spacer width="1" height="5"/>
           </uix:rowLayout>
         </uix:tableLayout>

           </uix:stackLayout>
          </uix:rowLayout>
         </uix:tableLayout>

        </uix:header>


     

    <%-- ------------------------------- --%>  
    <%-- END: SCHEDULE/PUBLISH TAB CONTENTS ends here     --%>   
    <%-- ------------------------------- --%>
        
    </uix:contents>       
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/ip/edit/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</uix:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



