<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        editRepDefElementSelection.jsp
  -- Controller:  eml/ip/ui/edit/IPRepDefEditController.java
  -- Bean:        defaultBean:  eml.ip.ui.edit.ElementSelectionData
  --
  -- Description: The Elements Selection for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@defaultBean@servletRequest"/>
</uix:metaContainer>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

<%-- HTML Form --%>
     <uix:form name="elementSelectionForm" 
              method="POST"
              destinationBinding="formDestination@defaultBean@servletRequest">
      <uix:pageLayout titleBinding="ADD_ELEMENTS@ipBundle">
       <%@ include file="/oemGlobal.jspf" %>

       <uix:pageButtons>
         <uix:pageButtonBar>
           <uix:rowLayout rendered="true"
                          renderedBinding="showContents@cacheLossData@defaultBean@servletRequest">
             <uix:submitButton textBinding="CANCEL@ipBundle" 
                               name="event" 
                               value="cancel"/>
             <uix:spacer height="3"/>                  
             <uix:submitButton textBinding="CONTINUE@ipBundle" 
                               name="event" 
                               value="Add"/>
           </uix:rowLayout>                 
         </uix:pageButtonBar>
       </uix:pageButtons>
        
       <uix:contents>
        <%-- cache loss --%>
        <uix:stackLayout rendered="false"
                          renderedBinding="showCacheLoss@cacheLossData@defaultBean@servletRequest">
           <uix:contents>
             <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrBundle"
                             messageType="error"
                             textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrBundle"/>
             <uix:spacer height="10"/>
             <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrBundle"
                             destinationBinding="restartDest@cacheLossData@defaultBean@servletRequest"/>
           </uix:contents>
        </uix:stackLayout>

        <%-- search --%>
        <uix:header textBinding="SEARCH@ipBundle" 
                    rendered="true"
                    renderedBinding="showContents@cacheLossData@defaultBean@servletRequest">

         <uix:contents>

            <%-- need a switcher here to handle fixed target type if one is specified --%>
         
               <uix:labeledFieldLayout 
                    labelWidth="20%" 
                    fieldWidth="80%"> 
    
               
                <uix:messageTextInput name="elementName"
                    id="elementName"
                    textBinding="elementName@defaultBean@servletRequest"
                    promptBinding="TYPE@ipBundle"
                    required="no"
                    columns="60" />

                <uix:messageChoice 
                    id="targetTypeChoice" 
                    name="targetTypeChoice"
                    promptBinding="HEADER_APPLICABLE_TARGET_TYPE@ipBundle"
                    selectedValueBinding="targetTypeFilter@defaultBean@servletRequest">
                       <uix:contents childDataBinding="targetTypeChoiceList@defaultBean@servletRequest">
                          <uix:option textBinding="text"
                                      valueBinding="value"/>
                       </uix:contents>
                </uix:messageChoice>  

    
               </uix:labeledFieldLayout>

                 <uix:labeledFieldLayout labelWidth="20%" fieldWidth="80%"> 
                     <uix:spacer width="1"/>
                     <uix:submitButton textBinding="SEARCH@ipBundle"
                                 name="event"
                                 value="search"/>
                 </uix:labeledFieldLayout>

        <uix:separator />

           <uix:rowLayout renderedBinding="showMessage@messageBox@defaultBean@servletRequest">
             <uix:messageBox messageBinding="message@messageBox@defaultBean@servletRequest"
                             messageTypeBinding="messageType@messageBox@defaultBean@servletRequest">
             </uix:messageBox>
           </uix:rowLayout>

           <uix:table name="availableElementsTable" 
                      id="availableElementsTable"
                      partialRenderMode="self"
                      alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrBundle"
                      width="90%"
                      blockSizeBinding="blockSize@defaultBean@servletRequest"
                      valueBinding="startValue@defaultBean@servletRequest"
                      minValueBinding="minValue@defaultBean@servletRequest"
                      maxValueBinding="maxValue@defaultBean@servletRequest"
                      showAll="yes"
                      formSubmitted="true"
                      tableDataBinding="displayTableData@defaultBean@servletRequest"
                      columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                      columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest"
                      summaryBinding="ADD_ELEMENTS_TABLE_SUMMARY@ipBundle">

              <uix:tableFormat tableBanding="rowBanding"/>

              <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text"
                                    sortableBinding="sortable"/>
              </uix:columnHeaderStamp>

              <uix:tableSelection>
                  <uix:singleSelection selectedIndex="0"
                                       shortDescBinding="elementDisplayName"/>
              </uix:tableSelection>


            <uix:contents>
              <uix:styledText textBinding="elementDisplayName"/> 
              <uix:styledText textBinding="elementDisplayType"/>
              <uix:styledText textBinding="elementDisplayDescription"/>
              <%-- uix:choice name="elementCount">
                   <uix:contents childDataBinding="elementCounts@defaultBean@servletRequest">
                     <uix:option textBinding="text"
                                 valueBinding="value"
                                 selectedBinding="selected"
                                 renderedBinding="rendered"/>
                   </uix:contents>
              </uix:choice --%>


            </uix:contents> 


          </uix:table>

         </uix:contents>
        </uix:header>

        </uix:contents>

       </uix:pageLayout>
      </uix:form>
    </uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 



