<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        setLayout.jsp
  -- Controller:  eml/ip/ui/edit/IPSetLayoutController.java
  --
  -- Description: The Element Layout page for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrResourceBundle" 
            class="oracle.sysman.resources.MntrResourceBundle"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>


<%-- Imports --%>
<%@ page import='oracle.sysman.eml.ip.ui.edit.SetLayoutUIBean' %>
<%@ page import='oracle.sysman.eml.ip.ui.edit.IPSetLayoutController' %>

<%
  // Currently, the only reason this is necessary is because the
  // "singleSelection" tag does not provide a selectedIndexBinding
  // short-cut attribute. --TBH 6/2/05
  SetLayoutUIBean renderBean = (SetLayoutUIBean) request.getAttribute(IPSetLayoutController.SET_LAYOUT_UIBEAN);
%>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@setLayoutUIBean@servletRequest"/>
</uix:metaContainer>

  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <%-- HTML Form --%>
    <uix:form name="setLayoutForm" 
                method="POST"
                destinationBinding="formDestination@setLayoutUIBean@servletRequest">
      <uix:pageLayout titleBinding="LAYOUT@ipBundle">
      <%@ include file="/oemGlobal.jspf" %>
         
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:rowLayout rendered="true"
                            renderedBinding="showContents@setLayoutCacheLoss@servletRequest">
              <uix:submitButton textBinding="CANCEL@ipBundle" 
                                 name="event" 
                                 value="cancel"/>
              <uix:spacer height="3"/>                  
              <uix:submitButton textBinding="CONTINUE@ipBundle" 
                                 name="event" 
                                 value="save"/>
            </uix:rowLayout>                 
          </uix:pageButtonBar>
        </uix:pageButtons>
          
        <uix:contents>
          <%-- cache loss --%>
          <uix:stackLayout rendered="false"
                            renderedBinding="showCacheLoss@setLayoutCacheLoss@servletRequest">
             <uix:contents>
               <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrResourceBundle"
                               messageType="error"
                               textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrResourceBundle"/>
               <uix:spacer height="10"/>
               <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrResourceBundle"
                               destinationBinding="restartDest@setLayoutCacheLoss@servletRequest"/>
             </uix:contents>
          </uix:stackLayout>
  
          <uix:stackLayout rendered="true"
                            renderedBinding="showContents@setLayoutCacheLoss@servletRequest">
           <uix:contents>
    
             <uix:separator />
  
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:submitButton textBinding="ADD_ROW@ipBundle"
                                      name="event" value="doAddRow"
                                      rendered="true"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
  
              <uix:hGrid id="layoutHGrid"
                         width="100%"
                         alternateTextBinding="SET_LAYOUT_NO_ELEMENTS@ipBundle"
                         destinationBinding="formDestination@setLayoutUIBean@servletRequest"
                         summaryBinding="SET_LAYOUT_SUMMARY@ipBundle"                           
                         treeDataBinding="treeData@setLayoutUIBean@servletRequest"
                         formSubmitted="true"
                         proxyBinding="proxy@servletRequest">

                <%-- Hierarchy (Name) column  --%>
                <uix:nodeStamp>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="ELEMENT_NAME@ipBundle"/>
                    </uix:columnHeader>
  
                    <uix:styledText textBinding="elementDisplayName"/>
                  </uix:column>
                </uix:nodeStamp>
  
                <%-- Header column  --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="HEADER@ipBundle"/>
                  </uix:columnHeader>                  
                  <uix:styledText textBinding="elementHeader"/>
                </uix:column>
                
                <uix:tableSelection> 
                  <uix:singleSelection textBinding="SELECT@ipBundle" 
                                       rendered="true"
                                       selectedIndex="<%=renderBean.getSelectedIndex()%>">
                      <uix:submitButton name="event" 
                                        value="moveUp"
                                        textBinding="SET_LAYOUT_MOVE_UP@ipBundle"/>
                      <uix:spacer width="1"/>                                        
                      <uix:submitButton name="event" 
                                        value="moveDown"
                                        textBinding="SET_LAYOUT_MOVE_DOWN@ipBundle"/>
                      <uix:spacer width="1"/>                                        
                  </uix:singleSelection>
                </uix:tableSelection>             
                
                <%-- Mechanism to pass the true (uncollapsed) index --%>
                <uix:formValue name="treeIndex" valueBinding="nodeTreeIndex" />
                
              </uix:hGrid>

             </uix:contents>
          </uix:stackLayout>
        </uix:contents>
      </uix:pageLayout>
    </uix:form>
  </uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
