<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        setParameters.jsp
  -- Controller:  eml/ip/ui/edit/IPSetParametersController.java
  --
  -- Description: The Set Parameters page for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrResourceBundle" 
            class="oracle.sysman.resources.MntrResourceBundle"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@setParametersUIBean@servletRequest"/>
</uix:metaContainer>

  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <%-- HTML Form --%>
    <uix:form name="setParametersForm" 
                method="POST"
                destinationBinding="formDestination@setParametersUIBean@servletRequest"
                usesUploadBinding="paramHasUpload@setParametersUIBean@servletRequest">

      <uix:pageLayout titleBinding="title@setParametersUIBean@servletRequest">
      <%@ include file="/oemGlobal.jspf" %>

        <uix:messages>
          <uix:messageBox messageType="error"
                          rendered="false"
                          renderedBinding="errorOccurred@setParametersUIBean@servletRequest">
            <uix:contents childDataBinding="errorsList@setParametersUIBean@servletRequest">
              <uix:styledText textBinding="message"/>
            </uix:contents>
          </uix:messageBox>
        </uix:messages>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:rowLayout rendered="true"
                            renderedBinding="showContents@setParametersCacheLoss@servletRequest">
              <uix:submitButton textBinding="CANCEL@ipBundle" 
                                 name="event" 
                                 value="cancel"/>
              <uix:spacer height="3"/>                  
              <uix:submitButton textBinding="CONTINUE@ipBundle" 
                                 name="event" 
                                 value="OK"/>
            </uix:rowLayout>                 
          </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:pageStatus>          
          <uix:tableLayout
            renderedBinding="showContents@setParametersCacheLoss@servletRequest">
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:spacer
                      width="25"
                      height="0"/>
                  </uix:cellFormat>
                  <uix:cellFormat
                    hAlign="right"
                    vAlign="top">    
                    <uix:styledText 
                      textBinding="ELEMENT_TYPE@ipBundle"
                      styleClass="OraPromptText"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer
                      width="10"
                      height="0"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      textBinding="elementName@setParametersUIBean@servletRequest"
                      styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:spacer
                      width="25"
                      height="0"/>
                  </uix:cellFormat>
                  <uix:cellFormat
                    hAlign="right"
                    vAlign="top">    
                    <uix:styledText 
                      textBinding="HEADER_APPLICABLE_TARGET_TYPES@ipBundle"
                      styleClass="OraPromptText"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer
                      width="10"
                      height="0"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      textBinding="elementType@setParametersUIBean@servletRequest"
                      styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:spacer
                      width="25"
                      height="0"/>
                  </uix:cellFormat>
                  <uix:cellFormat
                    hAlign="right"
                    vAlign="top">    
                    <uix:styledText 
                      textBinding="ELEMENT_DESCRIPTION@ipBundle"
                      styleClass="OraPromptText"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer
                      width="10"
                      height="0"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      textBinding="elementDescription@setParametersUIBean@servletRequest"
                      styleClass="OraDataText"/>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:tableLayout>
        </uix:pageStatus>

        <uix:contents>
          <%-- cache loss --%>
          <uix:stackLayout rendered="false"
                            renderedBinding="showCacheLoss@setParametersCacheLoss@servletRequest">
             <uix:contents>
               <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrResourceBundle"
                               messageType="error"
                               textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrResourceBundle"/>
               <uix:spacer height="10"/>
               <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrResourceBundle"
                               destinationBinding="restartDest@setParametersCacheLoss@servletRequest"/>
             </uix:contents>
          </uix:stackLayout>
  
          <uix:stackLayout rendered="true"
                            renderedBinding="showContents@setParametersCacheLoss@servletRequest">
             <uix:contents>

               <uix:rowLayout width="100%">
                 <uix:separator/>      
               </uix:rowLayout>

               <uix:ref refID="UINODE:oracle.sysman.eml.ip.edit.IPSetParametersController" />
   
            </uix:contents>
          </uix:stackLayout>
        </uix:contents>
      </uix:pageLayout>
    </uix:form>
  </uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
