<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       published.jsp
 *
 *      NOTES
 *       The published reports table (list of prior generations of reports)
 *
 * MODIFIED
 *    lgloyd     06/01/05 - add noscript 
 *    tyhorton   03/18/05 - Updating timestamp with refresh 
 *    tyhorton   02/03/05 - re-including footer information 
 *    lgloyd     01/31/05 - ui review 
 *    tyhorton   01/25/05 - more UI fixups 
 *    tyhorton   12/29/04 - adding Show All 
 *    tyhorton   12/20/04 - Sortable columns 
 *    tyhorton   12/14/04 - paging bug fix 
 *    tzimmerm   10/05/04 - tzimmerm_hgrid_tasks
 *    tzimmerm   06/02/04 - tzimmerm_prior_copy_support
 *    tzimmerm   05/19/04 - creation
 *
--%>
 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
 
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
  <uix:bundle name="IPBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>              
     
  <uix:document>

    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>  

    <uix:body>

    <uix:form name="PublicUserReports" method="post">

      <uix:pageLayout titleBinding="header@publicUserUIBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:pageStatus>
          <%@ include file="/ip/render/timestamp.jspf" %> 
        </uix:pageStatus>

        <uix:spacer height="8"/>
        
        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
 
<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
%>
        <uix:messageBox automatic="false"
                        messageBinding="action@servletRequest"
                        messageType="confirmation">
          <uix:link textBinding="jobName@servletRequest" 
                    destinationBinding="jobDest@servletRequest"/>
        </uix:messageBox>
<%
}
%>   

        <uix:stackLayout>
        
        <uix:rowLayout>
        <%--  Report Title Search Filter --%> 
        <uix:messageTextInput name="title"
                              promptBinding="REPORTS_FILTER_SEARCH_TITLE@IPBundle"
                              columns="20"
                              textBinding="titleFilter@publicUserUIBean@servletRequest">

<%--
          <uix:enterClientAction>
            <uix:fireAction event="doTitleFilter" formSubmitted="true"/>
          </uix:enterClientAction>
--%>
        </uix:messageTextInput>

<uix:formValue name="event" value="doTitleFilter"/>

        <%--  Search/GO button   --%> 
        <uix:spacer width="3"/>
        <uix:submitButton name="event"  
                          value="doTitleFilter" 
                          textBinding="REPORTS_TABLE_GO_BUTTON@IPBundle"/>                                          
        <uix:spacer height="3"/>
        </uix:rowLayout>        
        
<%--       Add the report version/prior copies table  --%>

           <uix:table id="publicUserTable"
                      showAll="yes"
                      partialRenderMode="self"
                      alternateTextBinding="PUBLIC_USER_TABLE_ALT_TEXT@IPBundle"
                      width="100%"    
                      blockSize="25"
                      minValue="1"
                      maxValueBinding="maxValue@publicUserUIBean@servletRequest"
                      valueBinding="startValue@publicUserUIBean@servletRequest"
                      tableDataBinding="tableData@publicUserUIBean@servletRequest"
                      columnHeaderDataBinding="columnHeaderData@publicUserUIBean@servletRequest"
                      formSubmitted="true"
                      summaryBinding="SIMPLE_REPORTS_PAGE_TITLE@IPBundle">

              <uix:tableFormat  tableBanding="rowBanding"/>              

              <uix:columnHeaderStamp>
                <uix:sortableHeader
                  textBinding="text" 
                  sortableBinding="sortable"
                  valueBinding="value"/>
              </uix:columnHeaderStamp>

              <uix:contents>
                <uix:link
                  textBinding="title"
                  destinationBinding="titleLinkDest"/>
                <uix:styledText textBinding="description"/>
                <uix:styledText textBinding="category"/>
              </uix:contents>
             
           </uix:table>
          
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
