<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       published.jsp
 *
 *      NOTES
 *       The published reports table (list of prior generations of reports)
 *
 * MODIFIED
 *    lgloyd     06/09/05 - ada
 *    lgloyd     06/01/05 - add noscript 
 *    tyhorton   12/14/04 - cleaning up UI 
 *    tyhorton   12/01/04 - rearranging UI 
 *    tyhorton   11/18/04 - privacy notice for 'Powered by..' message 
 *    tyhorton   11/12/04 - adding bradcrumbs 
 *    tzimmerm   06/02/04 - tzimmerm_prior_copy_support
 *    tzimmerm   05/19/04 - creation
 *
--%>
 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
 
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
  <uix:bundle name="IPBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>              
     
  <uix:document>

    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <uix:form name="Reports" method="POST">

      <uix:pageLayout titleBinding="header@publishedReportsBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

<%--
        <uix:privacy>
          <uix:link 
            renderedBinding="showPrivacyNotice@renderBean@servletRequest"
            textBinding="POWERED_BY_OEM_GC@IPBundle"/>
        </uix:privacy>
--%>


  <uix:returnNavigation>
    <uix:dataScope
      currentDataBinding="returnNavigation@publishedReportsBean@servletRequest">
      <uix:link 
        renderedBinding="rendered"
        textBinding="text"
        destinationBinding="destination"/>
    </uix:dataScope>
  </uix:returnNavigation>


        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>

        <uix:spacer height="8"/>
        
        <%-- Warning/Error display --%>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
 
<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
%>
        <uix:messageBox automatic="false"
                        messageBinding="action@servletRequest"
                        messageType="confirmation">
          <uix:link textBinding="jobName@servletRequest" 
                    destinationBinding="jobDest@servletRequest"/>
        </uix:messageBox>
<%
}
%>   
        <%--  ------------------------------------------------------------- --%>
        <%--  Render row with label value pair for the report Description   --%>
        <%--  ------------------------------------------------------------- --%>
        <uix:rowLayout>
          <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
            <uix:contents childDataBinding="descriptionInfo@publishedReportsBean@servletRequest">
              <uix:cellFormat hAlign="right" vAlign="top">
                <uix:styledText
                  textBinding="label"
                  styleClass="OraPromptText"/>
              </uix:cellFormat>
              <uix:styledText
                textBinding="text" 
                styleClassBinding="style" 
                destinationBinding="dest"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:rowLayout>

        <uix:spacer height="8"/>
    
        <uix:stackLayout>

           <uix:spacer height="3"/>
<%--       Add the report version/prior copies table  --%>

           <uix:table id="publishedReportsTable"
                      partialRenderMode="self"
                      alternateTextBinding="PRIOR_COPIES_TABLE_ALT_TEXT@IPBundle"
                      width="50%"
                      blockSize="25"
                      minValue="1"
                      maxValueBinding="maxValue@publishedReportsBean@servletRequest"
                      valueBinding="startValue@publishedReportsBean@servletRequest"
                      tableDataBinding="tableData@publishedReportsBean@servletRequest"                      
                      formSubmitted="true"
                      summaryBinding="PREVIOUS_COPIES@IPBundle">

              <uix:tableFormat tableBanding="rowBanding"/>              
              
                  <%-- Date Generated column  --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="REPORTS_HGRID_HEADER_DATE_GEN@IPBundle"/>
                    </uix:columnHeader>
                    <uix:link 
                      textBinding="versionDate"
                      destinationBinding="viewDestination"/>
                  </uix:column>

                  <uix:column renderedBinding="showDeleteColumn@publishedReportsBean@servletRequest">
                    <uix:columnHeader>
                      <uix:styledText textBinding="REPORTS_TABLE_DELETE_BUTTON@IPBundle"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="iconButtonFormat" width="5%"/>
                      <uix:image
                        source="/em/images/deleteicon_enabled.gif"
                        destination="#"
                        onClickBinding="deleteCommand"
                        width="24"
                        height="24"
                        shortDescBinding="REPORTS_TABLE_DELETE_BUTTON@IPBundle"/>
                  </uix:column>            
              <uix:formValue name="uniqueID" valueBinding="versionID" />                  
            </uix:table>
          </uix:stackLayout>
        </uix:pageLayout>
        <uix:formValue name="reportID" valueBinding="reportID@publishedReportsBean@servletRequest"/>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
