<%-- 

/* $Header: alertsParam.jsp 25-aug-2005.13:25:01 tyhorton Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Set parameters for an element
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      tyhorton  08/25/05 - Preserving severity values on submitForm 
      lgloyd    06/09/05 - ada
      lgloyd    02/18/05 - inheritance
      lgloyd    01/27/05 - 
      tyhorton  01/19/05 - Removing legend control 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    08/23/04 - 
      lgloyd    08/19/04 - lgloyd_ip_040816
 */

/**
 *  @version $Header: alertsParam.jsp 25-aug-2005.13:25:01 tyhorton Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        alertsParam.jsp
  -- Controller:  eml/ip/render/element/AlertsParamController.java
  -- Bean:        eml/ip/render/element/AlertsParamBean.java
  --
  -- Description: Set parameters for this element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>
<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>

<uix:header
  textBinding="OPTIONS@ipBundle">
  <uix:contents>

    <uix:spacer height="5"/>

    <uix:styledText 
      textBinding="SEVERITIES_TO_DISPLAY@ipBundle"
      styleClass="oraFieldText"
      />
    <uix:stackLayout>
      <uix:contents childDataBinding="severities@pageSegmentBean@">
        <uix:rowLayout>
        <uix:contents>
          <uix:spacer width="15"/>
          <uix:image sourceBinding="imageDest"
                shortDescBinding="text"/>
          <uix:checkBox nameBinding="value"
                textBinding="text"
                checkedBinding="selected"/>
        </uix:contents>
        </uix:rowLayout>
      </uix:contents>
    </uix:stackLayout>

    <uix:spacer height="5"/>

    <uix:messageTextInput 
      promptBinding="NUM_ROWS_TO_SHOW@ipBundle"
      textBinding="numRowsToShow@pageSegmentBean@" 
      nameBinding="ctlNumVisibleRows@pageSegmentBean@" 
      columns="3" 
      maximumLength="3" 
      tipBinding="NUM_ROWS_TO_SHOW_HINT@ipBundle" /> 

    <uix:formValue
      name="alertsParam"
      value="true"/>

  </uix:contents>
</uix:header>

</uix:dataScope>
      

</oem:pageSegment>
