<%-- 

/* $Header: chartParam.jsp 23-jun-2005.12:53:54 lgloyd Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Paramters for rendering a chart based on a SQL select statement.
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      lgloyd    06/23/05 - size sql window 
      lgloyd    06/16/05 - make sql box larger 
      lgloyd    03/04/05 - named sql, is pl/sql 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    07/14/04 - 
      djoly     07/15/04 - Fix build 
      lgloyd    07/13/04 - param name 
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    05/04/04 - 
      lgloyd    04/15/04 - 
 */

/**
 *  @version $Header: chartParam.jsp 23-jun-2005.12:53:54 lgloyd Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        chartParam.jsp
  -- Controller:  eml/ip/render/element/ChartParamController.java
  -- Bean:        eml/ip/render/element/ChartRenderBean.java
  --
  -- Description: Set parameters for the chart element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.eml.ip.IPConstants'%>
<%@ page import='oracle.sysman.eml.ip.render.elem.SQLStatementParamController'%>
<%@ page import='oracle.sysman.emSDK.chart.EmChartConstants'%>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>
<uix:bundle name="ipBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>

<uix:header textBinding="OPTIONS@ipBundle">
  <uix:contents>
    <uix:spacer height="5"/>
    <uix:rowLayout>      
     <uix:styledText textBinding="CHART_INSTRUCTIONS@ipBundle" />
    </uix:rowLayout>                   
    <uix:spacer height="5"/>

    <uix:tableLayout  >
      
    <uix:rowLayout>      
      <uix:cellFormat
          hAlign="right"
          vAlign="top">    
        <uix:styledText textBinding="CHART_TYPE_PROMPT@ipBundle"
                        styleClass="OraPromptText"/>
        <uix:spacer width="5"/>
      </uix:cellFormat>
      <uix:choice
        name="oracle.sysman.eml.ip.render.elem.ChartParamController.chartType"
        selectedValueBinding="chartType@pageSegmentBean@">
         <uix:contents childDataBinding="chartTypeChoiceList@pageSegmentBean@">
            <uix:option textBinding="text"
                        valueBinding="val"/>
         </uix:contents>
       </uix:choice>  
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
            <uix:styledText textBinding="SQL_STATEMENT_PARAM_PROMPT@ipBundle"
                      styleClass="OraPromptText"/>
                      
            <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:textInput name="<%=IPConstants.SQL_STATEMENT_PARAM %>"
                  columns="120"
                  rowsBinding="numEditRows@pageSegmentBean@"
                  textBinding="sqlStatement@pageSegmentBean@"
                  shortDescBinding="SQL_STATEMENT_PARAM_PROMPT@ipBundle"/>
      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer width="5"/>
      <uix:styledText textBinding="CHART_SQL_STATEMENT_PARAM_TIP@ipBundle"  styleClass="OraTipText"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
        <uix:styledText textBinding="SQL_STATEMENT_TYPE_PROMPT@ipBundle"
                      styleClass="OraPromptText"/>
        <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:radioSet
          shortDescBinding="SQL_STATEMENT_TYPE_PROMPT@ipBundle"
          selectedValueBinding="sqlStatementType@pageSegmentBean@"
          name="<%=SQLStatementParamController.SQL_STATEMENT_TYPE_CTL%>"
          >
          <uix:contents>
            <uix:option 
              value="<%=SQLStatementParamController.SQL_STATEMENT_TYPE_SQL%>"
              textBinding="SQL_STATEMENT_IS_SQL@ipBundle"/>
            <uix:option 
              value="<%=SQLStatementParamController.SQL_STATEMENT_TYPE_PLSQL%>"
              textBinding="SQL_STATEMENT_IS_PLSQL@ipBundle"/>
          </uix:contents>
        </uix:radioSet>
      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
          <uix:styledText textBinding="LEGEND_POSITION_PROMPT@ipBundle"
                      styleClass="OraPromptText"/>
          <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:radioSet 
              name="oracle.sysman.eml.ip.render.elem.ChartParamController.legendPosition"
              shortDescBinding="LEGEND_POSITION_PROMPT@ipBundle"
              selectedValueBinding="legendPosition@pageSegmentBean@">
          <uix:contents>
            <uix:option 
              value="<%=EmChartConstants.LEGENDPOSITION_EAST%>"
              textBinding="EAST@ipBundle"/>
            <uix:option 
              value="<%=EmChartConstants.LEGENDPOSITION_SOUTH%>"
              textBinding="SOUTH@ipBundle" />
          </uix:contents>
        </uix:radioSet>  
      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
          <uix:styledText textBinding="WIDTH@ipBundle"
                      styleClass="OraPromptText"/>
            <uix:spacer width="5"/>
        </uix:cellFormat>
         <uix:textInput name="oracle.sysman.eml.ip.render.elem.ChartParamController.width"
                  columns="4"
                  required="no"
                  shortDescBinding="WIDTH@ipBundle"
                  textBinding="width@pageSegmentBean@"/>

      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
          <uix:styledText textBinding="HEIGHT@ipBundle"
                      styleClass="OraPromptText"/>
            <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:textInput name="oracle.sysman.eml.ip.render.elem.ChartParamController.height"
                  columns="4"
                  shortDescBinding="HEIGHT@ipBundle"
                  required="no"
                  textBinding="height@pageSegmentBean@"/>
      </uix:contents>
    </uix:rowLayout>      

    </uix:tableLayout>
  </uix:contents>
</uix:header>
</uix:dataScope>
</oem:pageSegment>
