<%-- 

/* $Header: chartRender.jsp 01-aug-2005.12:07:44 lgloyd Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render a chart
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      lgloyd    08/01/05 - add timeLabelAlignment for tsbarchart 
      lgloyd    05/18/05 - orientation
      lgloyd    05/13/05 - disclaimer text 
      lgloyd    01/21/05 - pieValuesInLegend
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    01/05/05 - fix duplicate 
      lgloyd    12/27/04 - fix subchart 
      qsong     12/14/04 - add shadowEffectBinding attribute
      lgloyd    11/30/04 - min max xaxis 
      lgloyd    11/16/04 - fix binding 
      lgloyd    11/03/04 - yaxis label 
      lgloyd    09/30/04 - stack, fill 
      lgloyd    09/03/04 - 
      lgloyd    07/30/04 - pie in legend 
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    05/06/04 - 
      lgloyd    04/30/04 - 
 */

/**
 *  @version $Header: chartRender.jsp 01-aug-2005.12:07:44 lgloyd Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%--
  -- Page:        chartRender.jsp
  -- Controller:  eml/ip/render/element/ChartRenderController.java
  -- Bean:        eml/ip/render/element/ChartRenderBean.java
  --
  -- Description: Render the chart element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import='java.util.ArrayList'%>
<%@ page import='java.util.HashMap'%>
<%@ page import='oracle.sysman.eml.ip.render.elem.ChartRenderBean'%>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext'%>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:stackLayout>
  <uix:contents>

      <%-- error to be reported to end user if applicable --%>
      <uix:stackLayout rendered="false"
                        renderedBinding="showError@pageSegmentBean@">
         <uix:contents>
           <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                           messageTypeBinding="messageType@pageSegmentBean@"
                           textBinding="errorMessageTitle@pageSegmentBean@"/>
         </uix:contents>
      </uix:stackLayout>

      <%-- element content --%>
      <uix:stackLayout rendered="true"
                        renderedBinding="showContent@pageSegmentBean@">
        <uix:contents>


        <oem:chart titleBinding="title@pageSegmentBean@"
             chartTypeBinding="chartType@pageSegmentBean@"
             widthBinding="width@pageSegmentBean@"
             heightBinding="height@pageSegmentBean@" 
             legendPositionBinding="legendPosition@pageSegmentBean@"
             titleVisible="false"
             shadowEffectBinding="shadowEffect@pageSegmentBean@"
             legendVisible="external"
             fillBinding="fill@pageSegmentBean@"
             stackedBinding="stacked@pageSegmentBean@"
             yAxisLabelBinding="yAxisLabel@pageSegmentBean@"
             xAxisMinBinding="xaxisMin@pageSegmentBean@"
             xAxisMaxBinding="xaxisMax@pageSegmentBean@"
             showSlicePercentLabelsBinding="showSlicePercentLabels@pageSegmentBean@"
             pieValuesInLegendBinding="pieValuesInLegend@pageSegmentBean@"
             orientationBinding="visualOrientation@pageSegmentBean@"
             timeLabelAlignmentBinding="timeLabelAlignment@pageSegmentBean@" 
             >
          <uix:contents>
            <oem:boundChartDataSource 
                  chartDataSourceBinding="chartDataSource@pageSegmentBean@"
                  />
            <%
              // This isn't the prettiest way to dynamically specify
              // columns but is the most expedient and least risky.  
              // A fair amount is required in the emSDK chart code
              // to support dynamic columns properly.
              PageSegmentContext psc = (PageSegmentContext)request.getAttribute("pageSegmentContext");
              ChartRenderBean custBean = (ChartRenderBean) psc.getPageSegmentBean();

              ArrayList cols = custBean.getColumnData();
              for (int i = 0; i < cols.size(); i++)
              {
                HashMap col = (HashMap) cols.get(i);
                String isKey = (String) col.get("isKey");
                String sourceIndex = (String) col.get("sourceIndex");
                String isTimeColumn = (String) col.get("isTimeColumn");
                String displayLabel = (String) col.get("displayLabel");
                String isSubchart = (String) col.get("isSubchart");                             
                if (isSubchart == null)
                  isSubchart = "false";
                  
                if (isSubchart.equals("false"))
                {
              %>
  
              <oem:chartColumn                                   
                  isKey="<%=isKey%>" 
                  sourceIndex="<%=sourceIndex%>"
                  isTimeColumn="<%=isTimeColumn%>"
                  displayLabel="<%=displayLabel%>"
                />              
              <% 
                }
                else 
                {
              %>
  
              <oem:chartColumn                                   
                  isKey="<%=isKey%>" 
                  sourceIndex="<%=sourceIndex%>"
                  isTimeColumn="<%=isTimeColumn%>"
                  displayLabel="<%=displayLabel%>"
                  isSubchart="<%=isSubchart%>"
                />              
              <% 
                }
              }
            %>
          </uix:contents>

        </oem:chart>

          <uix:spacer height="5" renderedBinding="renderAnnotation@pageSegmentBean@" />
          <uix:styledText textBinding="annotationMessage@pageSegmentBean@"
            renderedBinding="renderAnnotation@pageSegmentBean@"
            styleClassBinding="annotationStyle@pageSegmentBean@"/>

        </uix:contents>
      </uix:stackLayout>

  </uix:contents>
</uix:stackLayout>
</oem:pageSegment>
