<%@ page contentType="text/html; charset=utf-8" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='java.text.MessageFormat' %>
<%@ page import='java.util.ResourceBundle' %>
<%@ page import='java.util.ArrayList' %>
<%@ page import='java.util.Calendar,java.util.TimeZone' %>
<%@ page import='java.util.Date,java.util.Enumeration' %>
<%@ page import='java.util.Locale' %>
<%@ page import='java.util.TimeZone' %>
<%@ page import='java.text.DateFormat' %>
<%@ page import='java.text.SimpleDateFormat' %>
<%@ page import='java.text.ParseException' %>

<%@ page import='oracle.sysman.emSDK.util.jdk.NLSUtil' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.util.SLUtil' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.util.SLDBHelper' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.constants.ServiceConstants' %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsgID' %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsg' %>
<%@ page import='oracle.sysman.emSDK.util.jdk.TimeZoneDisplay' %>
<%@ page import='java.util.regex.Matcher' %>
<%@ page import='java.util.regex.Pattern' %>
<%@ page import='oracle.sysman.emSDK.util.jdk.URLUtil' %>
<%@ page import=' oracle.sysman.emSDK.sec.auth.LoginUtil' %>

<%!
      //method for getting values from request
      public String getRequestParam(HttpServletRequest request,String paramName) {
          String reqMethod = request.getMethod();

          String paramValue = request.getParameter(paramName);

          //if it is queried by URL, the expected params are selTimeValue,selTimeZone and rptTZ
          //for other params, return null

          if(reqMethod.equals("GET")){
             if(paramName.equals("selTimeValue") || paramName.equals("selTimeZone") 
                 || paramName.equals(ServiceConstants.SELECTED_TIMEZONE)){
                 paramValue = URLUtil.decode(paramValue);
                 return paramValue;
              }else{
                 return null;
              }
          }

          //since user provided textbox values are not encoded
          //they are not decoded here. so that, users can see whatever they entered
          if(paramName.equals("date1")
             || paramName.equals("date2")
             || paramName.equals("prevTxtBox")){
               return paramValue;
          }else{
               paramValue = URLUtil.decode(paramValue);
               return paramValue;
          }
     }
%>

<%
        /////////////////////////////
        //Prevent unauthorized access
        //////////////////////////////
        String loginUser = LoginUtil.getUserName(request);
        if(loginUser==null || loginUser.trim().length()==0){
            response.sendError(response.SC_UNAUTHORIZED);
            return;
        }

	 //[ Find out the popup needs Timezone and some spacial cases
	 //  like carrying the selected time range from parent page etc
	 boolean tpFlag=false,resetSelTimeValue=false; 
	 String sDate = "";
     String eDate = "";

	 if(getRequestParam(request,"tpFlag")!=null){
		tpFlag = new Boolean(getRequestParam(request,"tpFlag")).booleanValue();
		resetSelTimeValue = true;
	 }else{ 
		 Enumeration paramNames = request.getParameterNames();
		 String parm;
		 while(paramNames.hasMoreElements()) {
		     parm = (String)paramNames.nextElement();
			 if(parm.equals("selTimeValue")){
				 tpFlag = true;
		
				 sDate = getRequestParam(request,"selTimeValue");
				 if(sDate!=null && sDate.indexOf(":")>0 && sDate.substring(0,sDate.indexOf(":")).equals("3")){
					 sDate = sDate.substring(sDate.indexOf(":")+1,sDate.length());
                                         if(sDate.indexOf(":")>-1){
					   eDate = sDate.substring(sDate.indexOf(":")+1,sDate.length());
                                           sDate = sDate.substring(0,sDate.indexOf(":"));
                                         }
				 }else{
					 sDate="";
				 }
			 }
		 }
	     paramNames=null;parm=null;
	 }
     String selTimePeriod = "";
     int selTzIndex = -1;
     ArrayList tzValueList = new ArrayList();
	 ArrayList tzTextList = new ArrayList();
     String selTimeZone = "",selTimeZoneID=null;
	 if(tpFlag){
	   if(getRequestParam(request,"selTimeValue") != null){
			selTimePeriod = (String)getRequestParam(request,"selTimeValue");
                        if( selTimePeriod.indexOf(":") <1){
                            selTimePeriod = "0:0";
                        }
                        //check for selTimePeriod should not having any chars except (0-9,:,-)
                        //because the expected value for selTimePeriod is like 
                        //"3:01-10-2004:02-11-2004" or "0:0" or "0:20:0"
                        Pattern p = Pattern.compile("[^0-9:-]");       
                        Matcher m = p.matcher(selTimePeriod);
                       if(m.find()){ //if event param contains any special chars except 0-9,- and :
                         selTimePeriod = "0:0";
                       }
                        
	   }
	   else if(resetSelTimeValue){ selTimePeriod=""; }
	   else{ selTimePeriod = "0:0";  }
	   //Getting timeZone list
	   TimeZoneDisplay[] arryTimeZoneDisplay=null;

	   String regionOfHost = TimeZone.getDefault().getDisplayName();
	   //Getting selected Time zone
	   if(getRequestParam(request,"selTimeZone") != null){	
		   selTimeZone=(TimeZone.getTimeZone((String)getRequestParam(request,"selTimeZone"))).getDisplayName();
	   }
	   else{
			selTimeZone = regionOfHost;
	   }
	   arryTimeZoneDisplay = NLSUtil.getTimeZonesForDisplay(request);
	   //String regionOfHost = TimeZone.getDefault().getID();
	   if(arryTimeZoneDisplay!=null){
		  String tzID = null;
	      for(int i=0;i<arryTimeZoneDisplay.length;i++){
			tzID =(String) arryTimeZoneDisplay[i].getTZRegion();
			//removing "+" & "-" as a temporary workaround for invalid timezones
			if(tzID != null && ( tzID.charAt(0)=='+' || tzID.charAt(0)=='-')){
				continue;
			}
			tzValueList.add(arryTimeZoneDisplay[i].getTZRegion());
	        tzTextList.add(arryTimeZoneDisplay[i].getDisplayName());
			if(getRequestParam(request,"selTimeZone") != null){
			  if(((String)getRequestParam(request,"selTimeZone")).equals(arryTimeZoneDisplay[i].getTZRegion())){
			    selTzIndex = i;
				selTimeZoneID = arryTimeZoneDisplay[i].getTZRegion();
			  }
			}
			if(selTzIndex == -1){
		      if(selTimeZone.equals((TimeZone.getTimeZone(arryTimeZoneDisplay[i].getTZRegion())).getDisplayName())){
			    selTzIndex = i;
				selTimeZoneID = arryTimeZoneDisplay[i].getTZRegion();
		      }
			}
		  }//end of for loop
	    }//end of - if(arryTimeZoneDisplay!=null)
	    if(selTzIndex == -1){
		   selTzIndex = 0;
	    }
	 }//end of - if (tpFlag)

	//End of Special case handling ]
%>
<uix:renderingContext >
  <uix:bundle name="servicesBundle"
              class="oracle.sysman.resources.eml.ip.emr.services.ServicesMsg"/>
<uix:bundle name="ipBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>
  <uix:document> 

	<% if(tpFlag){%> <uix:head titleBinding="TIME_RANGE_SELECTION@ipBundle"/> <%}else{%> 
	<uix:head titleBinding="TIME_RANGE_SELECTION@servicesBundle"/> <%}%>
    <uix:contents>
<%
	  ResourceBundle rb = NLSUtil.getBundle(ServicesMsg.class.getName(),
                                            request);
	  Object nlsParams[] = new Object[1];
	  
	  String timeZoneID = (String)getRequestParam(request,
							ServiceConstants.SELECTED_TIMEZONE);
	  if(tpFlag){ timeZoneID = selTimeZoneID; }
	  if(timeZoneID == null || timeZoneID.equals(""))
	  {
		timeZoneID = TimeZone.getDefault().getID();
	  }

	  Locale clientLocale = NLSUtil.getClientLocale(request);

	  SimpleDateFormat dateFormat = 
		(SimpleDateFormat)DateFormat.getDateInstance(DateFormat.MEDIUM,
													 clientLocale);
          //if the timeZoneID is not valid,then it will set the GMT timezone
	  dateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneID));
	  

	  SimpleDateFormat timeFormat = 
		(SimpleDateFormat)DateFormat.getTimeInstance(DateFormat.MEDIUM,
													 clientLocale);
	  timeFormat.setTimeZone(TimeZone.getTimeZone(timeZoneID));

	  nlsParams = new Object[1];
	  nlsParams[0] = dateFormat.toLocalizedPattern();
	  String ALERT_INVALID_END_DATE = MessageFormat.format(
									rb.getString(
									ServicesMsgID.ALERT_INVALID_END_DATE
									), nlsParams);
	  String ALERT_INVALID_START_DATE = MessageFormat.format(
									rb.getString(
									ServicesMsgID.ALERT_INVALID_START_DATE
									), nlsParams);
	  
	  nlsParams = new Object[1];
	  nlsParams[0] = new Integer(ServiceConstants.MAX_PRE_NO_YEARS + 1);
      String ALERT_DATE_RANGE = MessageFormat.format( 
							  rb.getString(
							  ServicesMsgID.ALERT_DATE_RANGE
							  ), nlsParams);

	  int windowHeight = 460;
	  String errorMessage = "";
	  String event = "";
	  //String sDate = "";
      //String eDate = "";
	  String sDate2 = "";
	  String eDate2 = "";
	  java.util.Date stDate = null;
	  java.util.Date edDate = null;
	  SimpleDateFormat internalDateFormat = 
				new SimpleDateFormat(ServiceConstants.INTERNAL_DATE_FORMAT);
	  int submitForm = 1;
	  String selTimeRange = "";
	  int selectDate1 = 1;


	  if(getRequestParam(request,"event") != null)
	  {
		event = (String)getRequestParam(request,"event");
	  }

	  if(event.equals("validate"))
	  {
		sDate = (String)getRequestParam(request,"date1");
        eDate = (String)getRequestParam(request,"date2");

		if(sDate == null || sDate.equals(""))
		{
		  errorMessage = errorMessage + 
						 rb.getString(ServicesMsgID.ALERT_START_DATE) + ";";
		  submitForm = 0;
		  windowHeight = windowHeight + 100;
		}
		else
		{
			try
			{
				sDate2 = SLUtil.getInternalDate(request, sDate);
				sDate = SLUtil.getClientLocaleDate(request, sDate2);
			}
			catch(ParseException e)
			{
				submitForm = 0;
				errorMessage = errorMessage + ALERT_INVALID_START_DATE + ";";
				windowHeight = windowHeight + 100;
				sDate = (String)getRequestParam(request,"date1");
			}
		}

		if(eDate == null || eDate.equals(""))
		{
		  if(submitForm == 1)
		  {
			eDate = dateFormat.format(new java.util.Date());
			eDate2 = SLUtil.getInternalDate(request, eDate);
			eDate = SLUtil.getClientLocaleDate(request, eDate2);
		  }
		  else
		  {
			errorMessage = errorMessage + 
						 rb.getString(ServicesMsgID.ALERT_END_DATE) + ";";
			submitForm = 0;
			windowHeight = windowHeight + 35;
		  }
		}
		else
		{
			try
			{
				eDate2 = SLUtil.getInternalDate(request, eDate);
				eDate = SLUtil.getClientLocaleDate(request, eDate2);
			}
			catch(ParseException e)
			{
				if(submitForm == 1)
				{
					selectDate1 = 0;
				}
				submitForm = 0;
				errorMessage = errorMessage + ALERT_INVALID_END_DATE + ";";
				if(windowHeight == 560)
				{
					windowHeight = windowHeight + 35;
				}
				else
				{
					windowHeight = windowHeight + 100;
				}
				eDate = (String)getRequestParam(request,"date2");
			}
		}
			
		if(sDate2 != null && eDate2 != null && submitForm == 1)
		{
			stDate = internalDateFormat.parse(sDate2);
			edDate = internalDateFormat.parse(eDate2);

			if(edDate.before(stDate) || edDate.equals(stDate))
			{
				submitForm = 0;
				errorMessage = errorMessage + 
					 rb.getString(ServicesMsgID.ALERT_END_GREATER_THAN_START) + ";";
				windowHeight = windowHeight + 100;
				selectDate1 = 0;
			}
		}

		if(submitForm == 1)
		{
			if(stDate != null && edDate != null)
			{
				if((edDate.getTime()-stDate.getTime())/1000/60/60/24
						> ServiceConstants.MAX_PRE_NO_YEARS*365.25)
				{
					submitForm = 0;
					errorMessage = errorMessage + ALERT_DATE_RANGE + ";";
					windowHeight = windowHeight + 100;
					selectDate1 = 0;
				}
			}
		}

		if(submitForm == 1)
		{
			selTimeRange = "3:" + sDate2 + ":" + eDate2;
		}
	  }
	  
	  //max days
	  nlsParams[0] = new Integer(
					  (new Double(Math.floor(
                         365.25*ServiceConstants.MAX_PRE_NO_YEARS))).intValue()
					 );
	  String ALERT_PREV_DAYS_RANGE = MessageFormat.format( 
                                     rb.getString(
                                     ServicesMsgID.ALERT_PREV_DAYS_RANGE
                                     ), nlsParams);
	  
	  //max weeks
	  nlsParams = new Object[1];
	  nlsParams[0] = new Integer(52*ServiceConstants.MAX_PRE_NO_YEARS);
      String ALERT_PREV_WEEKS_RANGE = MessageFormat.format( 
                                      rb.getString(
                                      ServicesMsgID.ALERT_PREV_WEEKS_RANGE
                                      ), nlsParams);
	  
	  //max months
	  nlsParams = new Object[1];
	  nlsParams[0] = new Integer(12*ServiceConstants.MAX_PRE_NO_YEARS);
      String ALERT_PREV_MONTHS_RANGE = MessageFormat.format( 
                                       rb.getString(
                                       ServicesMsgID.ALERT_PREV_MONTHS_RANGE
                                       ), nlsParams);
  
	  //max years
	  nlsParams = new Object[1];
	  nlsParams[0] = new Integer(ServiceConstants.MAX_PRE_NO_YEARS);
      String ALERT_PREV_YEARS_RANGE = MessageFormat.format( 
                                      rb.getString(
                                      ServicesMsgID.ALERT_PREV_YEARS_RANGE
                                      ), nlsParams);
      //System.out.println("Prev Years : " + ALERT_PREV_YEARS_RANGE);
	  //System.out.println("***" + rb.getString(ServicesMsgID.ALERT_PREV_YEARS_RANGE) + "***");
	  
	  //date range
	  nlsParams = new Object[1];
	  nlsParams[0] = new Integer(ServiceConstants.MAX_PRE_NO_YEARS);
      String ALERT_OLD_DATE = MessageFormat.format( 
							  rb.getString(
							  ServicesMsgID.ALERT_OLD_DATE
							  ), nlsParams);
	  
	  


	  nlsParams = new Object[1];
	  nlsParams[0] = (TimeZone.getTimeZone(timeZoneID)).getDisplayName(
							false, TimeZone.SHORT, clientLocale);
	  String POPUP_NOTE = MessageFormat.format(
						  rb.getString(ServicesMsgID.POPUP_NOTE), nlsParams);

	  String dateLast_7   = "0:1";
      String datePrev_7   = "1:7:0";
      String datePrev_1   = "1:1:0";
      String dateCal_Week = "2:0";
      ArrayList tempDate  = new ArrayList();
	  Calendar genCal = Calendar.getInstance();
      String startDate    = null;
      String endDate      = null;
      Object lastDates[]  = new Object[4];
      Object prevDates[]  = new Object[2];
      Object calDates[]   = new Object[3];
      Object custDates[]  = new Object[4];
      Object maxYears[]   = new Object[1];

      String strDate      = null;
      String strTime      = null;
      String strDate_1    = null;
	  String strTime_1	  = null;
      String strDate_7    = null;
      String strTime_7    = null;
      String strDate_Week = null;
      String strTime_Week = null;

      tempDate  = SLDBHelper.getDates(dateLast_7, timeZoneID);

	  genCal.setTime(new java.util.Date(((Long)tempDate.get(0)).longValue()));
	  strDate_7 = dateFormat.format(genCal.getTime());

	  genCal.setTime(new java.util.Date(((Long)tempDate.get(1)).longValue()));
	  strTime = timeFormat.format(genCal.getTime());
	  strDate = dateFormat.format(genCal.getTime());

	  lastDates[0]  = strTime;
      lastDates[1]  = strDate_7;
      lastDates[2]  = strTime;
      lastDates[3]  = strDate;

      tempDate  = SLDBHelper.getDates(datePrev_7, timeZoneID);
	  genCal.setTime(new java.util.Date( ((Long)tempDate.get(0)).longValue()-24*3600*1000));
	  strDate_7 = dateFormat.format(genCal.getTime());

	  genCal.setTime(new java.util.Date(((Long)tempDate.get(1)).longValue()-24*3600*1000));
	  strDate_1 = dateFormat.format(genCal.getTime());
	  genCal.set(genCal.HOUR_OF_DAY,23);
	  genCal.set(genCal.MINUTE,59);
	  genCal.set(genCal.SECOND,59);
	  strTime_1 = timeFormat.format(genCal.getTime());

	  prevDates[0]  = strDate_7;
	  //prevDates[1]  = strTime_1;
      prevDates[1]  = strDate_1;

      tempDate      = SLDBHelper.getDates(dateCal_Week, timeZoneID);
	  genCal.setTime(new java.util.Date(((Long)tempDate.get(0)).longValue()-24*3600*1000));
	  strDate_Week = dateFormat.format(genCal.getTime());

	  genCal.setTime(new java.util.Date(((Long)tempDate.get(1)).longValue()));
	  strDate_1 = dateFormat.format(genCal.getTime());

      calDates[0]   = strDate_Week;
      calDates[1]   = strTime;
      calDates[2]   = strDate;

      java.util.Date dtNow = Calendar.getInstance().getTime();
      java.util.Date dtOld = 
                        new java.util.Date(dtNow.getTime() - 1000*60*60*24*7);
      custDates[0] = (String)dateFormat.format(dtOld);
      custDates[1] = (String)dateFormat.format(dtNow);
      custDates[2] = (String)dateFormat.format(dtOld);
      custDates[3] = (String)dateFormat.format(dtNow);
	    
      maxYears[0] = (new Integer(ServiceConstants.MAX_PRE_NO_YEARS)).toString();

      
      String lastInlineTxt = 
        MessageFormat.format( rb.getString(ServicesMsgID.CURRTIME_INLINETEXT),
                              lastDates);
      String prevInlineTxt = 
        MessageFormat.format( rb.getString(ServicesMsgID.PREVTIME_INLINETEXT),
                              prevDates);
      String calInlineTxt = 
        MessageFormat.format( rb.getString(ServicesMsgID.CALTIME_INLINETEXT),
                              calDates);
      String custInlineTxt = 
        MessageFormat.format( rb.getString(ServicesMsgID.CUSTOMTIME_INLINETEXT),
                              custDates);
      
      String timerange_inlinetext = 
        MessageFormat.format( rb.getString(ServicesMsgID.TIMERANGE_INLINETEXT),
                              maxYears);
      
      String tpTimerange_inlinetext = 
        MessageFormat.format( rb.getString(ServicesMsgID.TP_TIMERANGE_INLINETEXT),
                              maxYears);

      request.setAttribute("lastInlineTxt",lastInlineTxt);
      request.setAttribute("prevInlineTxt",prevInlineTxt);
      request.setAttribute("calInlineTxt",calInlineTxt);
      request.setAttribute("custInlineTxt",custInlineTxt);
      request.setAttribute("timerange_inlinetext",timerange_inlinetext);
      request.setAttribute("tpTimerange_inlinetext",tpTimerange_inlinetext);

      String prevTxtBox = (String)getRequestParam(request,"prevTxtBox");
      //Expected value for prevTxtBox is 5 chars (user can enter only 5 chars thru UI)
      //if it is more than 5 chars,then the prevTxtBox param is passed externally
      if(prevTxtBox!=null && prevTxtBox.length()>5){
          prevTxtBox = "";
      }

    %>

    <script>
	  var winHeight = <%=windowHeight%>;
	  var submit = <%=submitForm%>;
	  var performEvent = '<%=URLUtil.encode(event)%>';
	  var timeRange = '<%=selTimeRange%>';
	  var selDate1 = <%=selectDate1%>;
	  var selTimeZoneID = '<%=selTimeZoneID%>';
	  var tpFlag = <%=tpFlag%>;
	  var tpForm = document.childForm;
	  if(performEvent == 'validate')
	  {
		if(submit == 1)
		{
		  closeWindow(timeRange,selTimeZoneID);
		}
		//window.resizeTo(825,winHeight);//Tmk
	  }

	  submit = 1;

     function closeWindow(timeRange,selTimeZoneID){
		window.opener.generateStrTimeRange(timeRange,selTimeZoneID);
		self.close();
	  }

      var alertNoPrevValues = new Array();
      var alertInvalidPrevValues = new Array();

      alertNoPrevValues[0] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_DAYS))%>';
      alertNoPrevValues[1] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_WEEKS))%>';
      alertNoPrevValues[2] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_MONTHS))%>';
      alertNoPrevValues[3] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_YEARS))%>';
      alertInvalidPrevValues[0] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_VALID_DAYS))%>';
      alertInvalidPrevValues[1] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_VALID_WEEKS))%>';
      alertInvalidPrevValues[2] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_VALID_MONTHS))%>';
      alertInvalidPrevValues[3] = 
        '<%=URLUtil.encode(rb.getString(ServicesMsgID.ALERT_PREV_VALID_YEARS))%>';

    </script>


    <uix:spacer height="20"/>
	<%if(tpFlag){%>
		<uix:header textBinding="TP_SET_TIME_PERIOD@ipBundle" />
	<%}else{%>
	    <uix:header textBinding="ADD_TIME_RANGE@servicesBundle" />
	<%}%>

    <uix:form name="childForm" method="POST" >
      <uix:tableLayout borderWidth="0" width="100%">
        <uix:rowLayout hAlign="left">
          <uix:cellFormat>
		   <%if(!tpFlag){%>
            <uix:styledText textBinding="timerange_inlinetext@servletRequest" 
                            styleClass="OraInstructionText" />
		  <%}else{%>
		    <uix:styledText textBinding="tpTimerange_inlinetext@servletRequest" 
						    styleClass="OraInstructionText" />
		  <%}%>
          </uix:cellFormat>

          <uix:cellFormat vAlign="center" hAlign="right">
            <uix:button name="cancel" textBinding="CANCEL@servicesBundle" 
                                      onClick="window.close();"/>
            <uix:spacer width="3" />
            <uix:button name="save" textBinding="CONTINUE@servicesBundle" 
                                    onClick="saveTimeRange();"/>
          </uix:cellFormat>
        </uix:rowLayout>

		<uix:rowLayout>
		  <uix:cellFormat>
			<uix:styledText text="<%=POPUP_NOTE%>" 
                            styleClass="OraInstructionText" />
		  </uix:cellFormat>
		 </uix:rowLayout>

      </uix:tableLayout>
      <uix:spacer height="10" />
    <%
          String selIndex = "0";
          String lastChoice = "1";
		  if(tpFlag){ lastChoice="0"; }
		  //[to format the internal dates passed by the window.opener
		  //while opening the winow
		  if(!resetSelTimeValue && !sDate.equals("")){
                       try{
			  sDate= SLUtil.getClientLocaleDate(request,sDate);
                        }
                        catch(ParseException e)
                        {
                                submitForm = 0;
                                errorMessage = errorMessage + ALERT_INVALID_START_DATE + ";";
                                windowHeight = windowHeight + 100;
                        }
                        try{
                          eDate= SLUtil.getClientLocaleDate(request,eDate);
                        }
                        catch(ParseException e)
                        {
                                submitForm = 0;
                                errorMessage = errorMessage + ALERT_INVALID_END_DATE + ";";
                                windowHeight = windowHeight + 100;
                        }

                        
		  }
		  //]
		  String dtFormatStr = "("+rb.getString(ServicesMsgID.DATE_FORMAT_TXT)
							   +" "+dateFormat.toLocalizedPattern()+")";
		  String date1 = sDate;
		  String date2 = eDate;
          if(errorMessage.equals("") && getRequestParam(request,"errorMsg")!=null){
            errorMessage = (String)getRequestParam(request,"errorMsg");
		  }

		  if(errorMessage != null && !errorMessage.equals("")){
            ArrayList errorList = SLUtil.getList(errorMessage, ";");
            errorMessage = (String)errorList.get(0);
            selIndex = (String)getRequestParam(request,"selIndex");
            lastChoice = (String)getRequestParam(request,"lastChoice");
        %>
	 <uix:tableLayout width="100%" borderWidth="0">
	   <uix:rowLayout hAlign="left">
  	     <uix:cellFormat>
            <uix:messageBox messageType="error">
              <uix:bulletedList>
              <% for(int i=0; i< errorList.size(); i++){ %>
                  <uix:styledText text = "<%=(String)errorList.get(i)%>" />
              <% } %>
              </uix:bulletedList>
              </uix:messageBox>
		</uix:cellFormat>
	   </uix:rowLayout>
	</uix:tableLayout>
	<uix:spacer width="10" />
   <%}
		//render timezone list box
		if (tpFlag){

        %>
			<uix:tableLayout width="100%" borderWidth="0">
			  <uix:rowLayout hAlign="left">
				<uix:cellFormat>
    				<uix:spacer width="10" />
				</uix:cellFormat>
				<uix:cellFormat width="20%">
					<uix:styledText styleClass="OraInstructionText" textBinding="TP_TIMEZONE@ipBundle"/>
				</uix:cellFormat>
				<uix:cellFormat>
					<uix:list name="cmbTimeZone" size="1" selectedIndex="<%=selTzIndex%>"
					shortDescBinding="TP_TIMEZONE@ipBundle" >
					<uix:contents>
					<%for(int i=0; i<tzValueList.size(); i++){ %>
						<uix:option text="<%=(String)tzTextList.get(i)%>" value="<%=((String)tzValueList.get(i))%>"/>
					<%}%>
					</uix:contents>
					</uix:list>
			</uix:cellFormat>
  		   </uix:rowLayout>
	    </uix:tableLayout>
	 <%}%>
	  <uix:spacer height="10" />
      <uix:tableLayout  borderWidth="0" cellSpacing="1" 
                        cellPadding="0" width="100%">
        <uix:rowLayout hAlign="left" vAlign="center">
          <uix:cellFormat hAlign="left" width="2%">
            <uix:radioButton   name="date_radio_button" 
                              selected="true" value="0" 
	   shortDescBinding="FROM_CURRENT_TIME@servicesBundle" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" width="20%">
            <uix:styledText textBinding="FROM_CURRENT_TIME@servicesBundle" 
			shortDescBinding="FROM_CURRENT_TIME@servicesBundle"
                            styleClass="OraInstructionText" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" >
            <uix:choice name="lastChoice" selectedIndex="<%=URLUtil.encode(lastChoice)%>"
			shortDescBinding="FROM_CURRENT_TIME@servicesBundle"	>
              <uix:contents>
                <uix:option textBinding="LAST_24_HOURS@servicesBundle" 
                            value="0"/> 
                <uix:option textBinding="LAST_7_DAYS@servicesBundle" 
                            value="1"/> 
                <uix:option textBinding="LAST_31_DAYS@servicesBundle" 
                            value="2"/> 
              </uix:contents>
            </uix:choice>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left">
            <uix:spacer width="1" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" columnSpan="2" vAlign="top">
            <uix:styledText textBinding="lastInlineTxt@servletRequest" 
                            styleClass="OraInstructionText " />
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left" columnSpan="3" height="20">
            <uix:spacer width="1" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout hAlign="left" vAlign="center">
          <uix:cellFormat hAlign="left" >
            <uix:radioButton  name="date_radio_button" value="1" 
                  shortDescBinding="PREVIOUS_TIME_PERIOD@servicesBundle"
               />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left"  width="20%">
            <uix:styledText textBinding="PREVIOUS_TIME_PERIOD@servicesBundle" 
                    shortDescBinding="PREVIOUS_TIME_PERIOD@servicesBundle"
                            styleClass="OraInstructionText" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" >
            <uix:textInput shortDescBinding="PREVIOUS_TIME_PERIOD@servicesBundle"
              text="<%=prevTxtBox%>" 
              name="prevTxtBox" maximumLength="5" columns="5"/>
            <uix:spacer width="8" />
            <uix:choice 
              name="prevChoice" shortDescBinding="PREVIOUS_TIME_PERIOD@servicesBundle"
              selectedIndex="<%=URLUtil.encode(getRequestParam(request,\"prevChoice\"))%>">
              <uix:contents>
                <uix:option textBinding="DAYS@servicesBundle" value="0"/>
                <uix:option textBinding="WEEKS@servicesBundle" value="1"/>
                <uix:option textBinding="MONTHS@servicesBundle" value="2"/>
                <uix:option textBinding="YEARS@servicesBundle" value="3"/>
              </uix:contents>
            </uix:choice>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left">
            <uix:spacer width="1" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" columnSpan="2" vAlign="top">
            <uix:styledText textBinding="prevInlineTxt@servletRequest" 
                            styleClass="OraInstructionText " />
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left" columnSpan="3" height="20">
            <uix:spacer width="1" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout hAlign="left" vAlign="center">
          <uix:cellFormat hAlign="left" >
            <uix:radioButton  name="date_radio_button" value="2" 
         shortDescBinding="CALENDAR_TIME_PERIOD@servicesBundle"/>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left"  width="20%">
            <uix:styledText textBinding="CALENDAR_TIME_PERIOD@servicesBundle"
                            styleClass="OraInstructionText" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" >
            <uix:choice 
              name="toDateChoice" shortDescBinding="CALENDAR_TIME_PERIOD@servicesBundle"
              selectedIndex="<%=URLUtil.encode(getRequestParam(request,\"toDateChoice\"))%>">
              <uix:contents>
                <uix:option textBinding="THIS_WEEK@servicesBundle" 
                            selected="true" value="0"/>
                <uix:option textBinding="THIS_MONTH@servicesBundle" value="1"/>
                <uix:option textBinding="THIS_YEAR@servicesBundle" value="2"/>
              </uix:contents>
            </uix:choice>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left">
            <uix:spacer width="1" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" columnSpan="2" vAlign="top">
            <uix:styledText textBinding="calInlineTxt@servletRequest" 
                            styleClass="OraInstructionText " />
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left" columnSpan="3" height="20">
            <uix:spacer width="1" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout hAlign="left" vAlign="top">
          <uix:cellFormat hAlign="left" >
            <uix:radioButton  name="date_radio_button" value="3" 
               shortDescBinding="CUSTOM_DATE_RANGE@servicesBundle"      />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left" columnSpan="2" vAlign="center">
            <uix:stackLayout>
              <uix:styledText textBinding="CUSTOM_DATE_RANGE@servicesBundle" 
                              styleClass="OraInstructionText" />
              <uix:styledText textBinding="custInlineTxt@servletRequest" 
                              styleClass="OraInstructionText " />
            </uix:stackLayout>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left" columnSpan="3" height="8">
            <uix:spacer width="1" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout hAlign="center" vAlign="center">
          <uix:cellFormat hAlign="left">
            <uix:spacer width="1" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="center">
            <uix:styledText textBinding="START_DATE@servicesBundle" 
                            styleClass="OraInstructionText" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:dateField id="d1" name="date1" 
                           columns="20" value="<%=date1%>" 
						   shortDescBinding="START_DATE@servicesBundle">
              <uix:onSubmitValidater>
                <uix:date dateStyle="long" pattern="<%=dateFormat.toPattern()%>" /> 
              </uix:onSubmitValidater>
            </uix:dateField>
            <uix:spacer width ="8" />
            <uix:styledText text="<%=dtFormatStr%>" styleClass="OraInstructionText" />
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout hAlign="center" vAlign="center">
          <uix:cellFormat hAlign="left">
            <uix:spacer width="1" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="center">
            <uix:styledText textBinding="END_DATE@servicesBundle" 
                            styleClass="OraInstructionText" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">        
            <uix:dateField id="d2" name="date2" 
						   shortDescBinding="END_DATE@servicesBundle"
                           columns="20" value="<%=date2%>">
              <uix:onSubmitValidater>
                <uix:date dateStyle="long" pattern="<%=dateFormat.toPattern()%>" /> 
              </uix:onSubmitValidater>
            </uix:dateField>
            <uix:spacer width ="8" />
            <uix:styledText text="<%=dtFormatStr%>" styleClass="OraInstructionText" />
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10" />
      <uix:header text=" " />
      <uix:spacer height="10" /> 

      <uix:tableLayout borderWidth="0" width="100%">
        <uix:rowLayout hAlign="right">
          <uix:cellFormat vAlign="center" hAlign="right">
            <uix:button name="cancel" textBinding="CANCEL@servicesBundle" 
                        onClick="window.close();"/>
            <uix:spacer width="3" />
            <uix:button name="save" textBinding="CONTINUE@servicesBundle" 
                        onClick="saveTimeRange();"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:formValue  name="ALERT_START_DATE" 
                      valueBinding="ALERT_START_DATE@servicesBundle" />
      <uix:formValue  name="ALERT_INVALID_START_DATE" 
                      value="<%=ALERT_INVALID_START_DATE%>" />
      <uix:formValue  name="ALERT_END_DATE" 
                      valueBinding="ALERT_END_DATE@servicesBundle" />
      <uix:formValue  name="ALERT_INVALID_END_DATE" 
                      value="<%=ALERT_INVALID_END_DATE%>" />
      <uix:formValue  name="ALERT_END_GREATER_THAN_START" 
                      valueBinding="ALERT_END_GREATER_THAN_START@servicesBundle" />
      <uix:formValue  name="ALERT_OLD_DATE" 
                      value="<%=ALERT_OLD_DATE%>" />
      <uix:formValue  name="ALERT_PREV_YEARS_RANGE" 
                      value="<%=URLUtil.encode(ALERT_PREV_YEARS_RANGE)%>" />
	  <uix:formValue  name="ALERT_PREV_DAYS_RANGE" 
                      value="<%=URLUtil.encode(ALERT_PREV_DAYS_RANGE)%>" />
      <uix:formValue  name="ALERT_PREV_WEEKS_RANGE" 
                      value="<%=URLUtil.encode(ALERT_PREV_WEEKS_RANGE)%>" />
      <uix:formValue  name="ALERT_PREV_MONTHS_RANGE" 
                      value="<%=URLUtil.encode(ALERT_PREV_MONTHS_RANGE)%>" />
	  <uix:formValue  name="ALERT_DATE_RANGE" 
                      value="<%=ALERT_DATE_RANGE%>" />
	  <uix:formValue  name="MAX_PRE_NO_YEARS" 
                      value="<%=ServiceConstants.MAX_PRE_NO_YEARS%>" />
      <uix:formValue  name="selIndex" 
                      value="<%=URLUtil.encode(selIndex)%>" />
      <uix:formValue  name="errorMsg" 
                      value="<%=URLUtil.encode(errorMessage)%>" />
	  <uix:formValue  name="<%=ServiceConstants.SELECTED_TIMEZONE%>" 
                      value="<%=URLUtil.encode(timeZoneID)%>" />
	  <uix:formValue  name="event" 
                      value="" />
				  
      <uix:formValue  name="tpFlag" 
                      value="<%=tpFlag%>" />
	  <uix:formValue name="selTimePeriod" value="<%=selTimePeriod%>" />
	  <uix:formValue name="selTimeZone" value="<%=selTimeZoneID%>" />

    </uix:form>

    <uix:script text="
	  var tpForm = document.childForm;
	  function init()
      {
		tpForm.date_radio_button[tpForm.selIndex.value].checked = true;
        if(tpForm.selIndex.value == '1')
        {
		  tpForm.prevTxtBox.focus();
          tpForm.prevTxtBox.select();
        }
        if(tpForm.selIndex.value == '3')
        {
		  if(selDate1 == 0)
          {
            tpForm.date2.focus();
            tpForm.date2.select();
          }
          else
          {
            tpForm.date1.focus();
            tpForm.date1.select();
          }
        }
      }
	  init();

      function saveTimeRange()
      {
        var selectedIndex;

        var errMessage = '';
		var prevTxt = '';

        for (var i=0; i < tpForm.date_radio_button.length; i++)
        {
          if (tpForm.date_radio_button[i].checked)
          {
            selectedIndex = tpForm.date_radio_button[i].value;
          }
        }
        if(selectedIndex == '0')
        {
          timeRange = selectedIndex + ':' + 
          tpForm.lastChoice.options[tpForm.lastChoice.selectedIndex].value;
        }

        if(selectedIndex == '1')
        {
          if(tpForm.prevTxtBox.value == '')
          {
            submit = 0;
            errMessage = errMessage 
                + alertNoPrevValues[tpForm.prevChoice.selectedIndex] 
                + ';';
            tpForm.prevTxtBox.focus();
            winHeight = 560;
          }
          else if(isNaN(tpForm.prevTxtBox.value) ||  
                  tpForm.prevTxtBox.value <= 0 ||
				  (parseInt(tpForm.prevTxtBox.value) != 
				   (tpForm.prevTxtBox.value - 0)))
          {
            submit = 0;
            errMessage = errMessage 
                + alertInvalidPrevValues[tpForm.prevChoice.selectedIndex] 
                + ';';
            tpForm.prevTxtBox.focus();
            winHeight = 560;
          }
		  else 
		  {
			errMessage = chkPrev(tpForm.prevTxtBox.value,
			tpForm.prevChoice.options[tpForm.prevChoice.selectedIndex].value);
			if(errMessage != '')
			{
			  tpForm.prevTxtBox.focus();
              winHeight = 560;
			  submit = 0;
			}
		  }

		  if(submit == 1)
		  {
			prevTxt = tpForm.prevTxtBox.value;
			if(prevTxt.indexOf('.') > -1)
			{
			  prevTxt = prevTxt.substring(0,prevTxt.indexOf('.'));
			}
            timeRange = selectedIndex + ':' + prevTxt + ':' + tpForm.prevChoice.options[tpForm.prevChoice.selectedIndex].value;
          }
        }

        if(selectedIndex == '2')
        {
          timeRange = selectedIndex + ':' 
          + tpForm.toDateChoice.options[tpForm.toDateChoice.selectedIndex].value;
        }

        if(selectedIndex == '3')
        {
		  tpForm.event.value = 'validate';
		  submit = 0;
        }

        if(submit == 1)
        {
		  if(eval(tpFlag)){	
			  selTimeZoneID=tpForm.cmbTimeZone.options[
			  tpForm.cmbTimeZone.selectedIndex].value;
		  }
          closeWindow(timeRange,selTimeZoneID);
        }
        else
        {
          ////window.resizeTo(825,winHeight);//Tmk
          tpForm.selIndex.value = selectedIndex;
          tpForm.errorMsg.value = errMessage;
		  if(eval(tpForm.tpFlag.value)){
			tpForm.selTimeZone.value=
				tpForm.cmbTimeZone.options[tpForm.cmbTimeZone.selectedIndex].value;
		  }
          tpForm.submit();
        }
        return false;
      }

	  function chkPrev(prevValue, periodValue)
      {
        var retMessage = '';
		var maxTimeRange = tpForm.MAX_PRE_NO_YEARS.value;

        if(periodValue == '0' && 
		  (prevValue > maxTimeRange*365.25 || prevValue<=0))
        {
          retMessage = tpForm.ALERT_PREV_DAYS_RANGE.value;
        }

        if(periodValue == '1' && 
		  (prevValue > 52*maxTimeRange || prevValue <=0))
        {
          retMessage = tpForm.ALERT_PREV_WEEKS_RANGE.value;
        }

        if(periodValue == '2' && 
		  (prevValue > 12*maxTimeRange || prevValue <=0))
        {
          retMessage = tpForm.ALERT_PREV_MONTHS_RANGE.value;
        }

        if(periodValue == '3' && 
		  (prevValue > 1*maxTimeRange || prevValue <=0))
        {
          retMessage = tpForm.ALERT_PREV_YEARS_RANGE.value;
        }

		return retMessage;
      }

	  //stopping to open a window by cntrl+N keys
	  document.onkeydown = 
		  function ()
		  {
			if ((78 == event.keyCode) && (event.ctrlKey))
			{
			  event.keyCode = 0;
			  event.returnValue = false;
			}
		  }

  //to check the ratio button when the time period already selected
  function preSelectTime(){
	var selTime = tpForm.selTimePeriod.value;
	if(selTime.indexOf(':')<0) return;
	var startSelTime = selTime.substring(0,selTime.indexOf(':'));

	tpForm.date_radio_button[startSelTime].checked = true;

	var midSelTime = '';
	var endSelTime = '';
	
	if(startSelTime == '0'){
		midSelTime = selTime.substring(selTime.lastIndexOf(':') + 1, selTime.length);
		tpForm.lastChoice.options[midSelTime].selected = true;
	}

	if(startSelTime == '1'){
		midSelTime = selTime.substring(selTime.indexOf(':') + 1, selTime.lastIndexOf(':'));
		endSelTime = selTime.substring(selTime.lastIndexOf(':') + 1, selTime.length);
		tpForm.prevTxtBox.value = midSelTime;
		tpForm.prevChoice.options[endSelTime].selected = true;
	}

	if(startSelTime == '2'){
		midSelTime = selTime.substring(selTime.lastIndexOf(':') + 1, selTime.length);
		tpForm.toDateChoice.options[midSelTime].selected = true;
	}

	//if(startSelTime == '3'){
		//midSelTime = selTime.substring(selTime.indexOf(':') + 1, selTime.lastIndexOf(':'));
		//endSelTime = selTime.substring(selTime.lastIndexOf(':') + 1, selTime.length);
		//tpForm.date1.value = midSelTime;
		//tpForm.date2.value = endSelTime;
	//}
   }


    if(eval(tpForm.tpFlag.value)){ 
		preSelectTime();
	}

    " />
    </uix:contents>
  </uix:document>
</uix:renderingContext>
