<%--
  -- Page:        sampleMultiplyParam.jsp
  -- Controller:  eml/ip/render/element/SampleMultiplyParamController.java
  -- Bean:        eml/ip/render/element/SampleMultiplyParamBean.java
  --
  -- Description: Set parameters for the multiply element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.bean.SLTableBean' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsgID' %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsg' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.constants.ServiceConstants' %>
<%@ page import='java.util.ResourceBundle' %>
<%@ page import='oracle.sysman.emSDK.util.jdk.NLSUtil' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
  <uix:dataScope> 
    <uix:bundle name="servicesBundle"
                class="oracle.sysman.resources.eml.ip.emr.services.ServicesMsg"/>
  <%
    PageSegmentContext psc = 
        (PageSegmentContext)request.getAttribute("pageSegmentContext");
    SLTableBean srvLevelBean = (SLTableBean)psc.getPageSegmentBean();
    ResourceBundle scRB= null;
    scRB = NLSUtil.getBundle(ServicesMsg.class.getName(),request);
  %>
	<uix:spacer height="20"/>
    <%-- error to be reported to end user if applicable --%>
	<uix:stackLayout rendered="false" 
					 renderedBinding="isError@servletRequest">
	  <uix:contents>
		<uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
						messageTypeBinding="messageType@pageSegmentBean@"
						textBinding="errorMessageTitle@pageSegmentBean@"/>
	  </uix:contents>
	</uix:stackLayout>

	<%-- element content --%>
	<uix:stackLayout renderedBinding="isServiceLevelSelected@pageSegmentBean@" >
	  <uix:contents>
	  <%-- For Partial rendering of table --%>
		<uix:header textBinding="TIME_RANGE_SELECTION@servicesBundle">
		  <uix:tableLayout borderWidth="0" cellSpacing="1" 
						   cellPadding="3" width="100%">
			<uix:rowLayout hAlign="left">
			  <uix:cellFormat>
				<uix:styledText textBinding="INLINE_TIMERANGE_SEL_TXT@servicesBundle" 
								styleClass="OraInstructionText" />
			  </uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout hAlign="left">
			  <uix:cellFormat>
				<uix:stackLayout rendered="false" 
								 renderedBinding="showMsg@servletRequest">
				  <uix:contents>
					<uix:messageBox 
					  messageBinding="REP_LEVEL_TIME_SEL_MSG@servicesBundle"
					  messageType="information" />
				  </uix:contents>
				</uix:stackLayout>
			  </uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout>
			  <uix:cellFormat hAlign="left">
				
				<%--
				  - This table uses partial renderring mode. So id attribute is must. 
				  - Also partial renderring requires "/enablePPR.jspf" to be included
				--%>
				<uix:table 
				  name="timeRangeTable" 
				  id="timeRangeTableID"
				  width="40%" 
				  tableDataBinding="tableData@pageSegmentBean@"
				  alternateTextBinding="NO_TIME_RANGE_SELECTED@servicesBundle" 
				  proxied="true"
				  partialRenderMode="self"
				  summary="<%=scRB.getString(ServicesMsgID.TIME_RANGE)%>"
				>
				  <uix:tableFormat tableBanding="rowBanding" />
				  <uix:tableSelection>
					<uix:singleSelection 
						 selectedIndexBinding="selRowIndex@servletRequest"
						 shortDescBinding="TIME_RANGE_ALT_TXT@servicesBundle" >
					  <uix:submitButton
						name="event"
						value="delete"
						formNameBinding="formName@servletRequest"
						textBinding="DELETE@servicesBundle"/>
					  <uix:spacer width="2"/>
					  <uix:submitButton
						name="event"
						value="up"
						formNameBinding="formName@servletRequest"
						textBinding="SET_LAYOUT_MOVE_UP@servicesBundle"/>
					  <uix:spacer width="2"/>
					  <uix:submitButton
						name="event"
						value="down"
						formNameBinding="formName@servletRequest"
						textBinding="SET_LAYOUT_MOVE_DOWN@servicesBundle"/>
					  <uix:spacer width="2"/>
					</uix:singleSelection>
				  </uix:tableSelection>
				  
				  <uix:tableActions>
					<uix:spacer width="2"/>
					<uix:button name="btnAdd" textBinding="ADD@servicesBundle" 
								destination="javascript:openChild(\"add\")">
					</uix:button>
				  </uix:tableActions>

				  <uix:column>
					<uix:columnHeader>
					  <uix:styledText textBinding="TIME_RANGE@servicesBundle" />
					</uix:columnHeader>
					<uix:contents>
					<%
					  String col = null;
					  String timeRow = null;
					  for(int row=0; 
						  row < srvLevelBean.getArrlNumSLTimeRanges().size(); 
						  row++)
					  {
						col = "col" + row;
						timeRow = ServiceConstants.TIMEPERIOD + row;
					%> 
						<uix:styledText textBinding="<%=col%>" />
						<uix:formValue name = "<%=timeRow%>" 
						  value = 
						  "<%=(String)srvLevelBean.getArrlNumSLTimeRanges(row)%>" />
					<%
					  }
					%>
					</uix:contents>
				  </uix:column>
				</uix:table>
				<uix:link name="tableAnchor" />
			  </uix:cellFormat>
			</uix:rowLayout>
		  </uix:tableLayout>
		</uix:header>
		   
	    <uix:spacer width="20"/>
	  </uix:contents>
    </uix:stackLayout>
 <uix:formValue name="selRowIndex" 
                                           valueBinding="selRowIndex@servletRequest" />
                <uix:formValue name="selTimeRange" value=""/>
                <uix:formValue name="tblAnchor" valueBinding="tableAnchor@servletRequest"/>
                <uix:formValue name="cmbTimeZoneSelected" 
                                           value="<%=ServiceConstants.SELECTED_TIMEZONE %>"/>
                <uix:formValue name="anchor" value=""/>
                <uix:formValue name="anchorFromRequest" valueBinding="anchor@servletRequest"/>
		<uix:script text="
			function openChild(tableOp)
			{
			 // var url = '/em/ip/render/elem/emr/services/param/slTimeRangePopup.jsp';
			 var url = '/em/ip/render/elem/emr/TPSelector/tpTimeRangePopup.jsp';
			  url=url+'?'+document.setParametersForm.cmbTimeZoneSelected.value+'=';
			  url=url+document.setParametersForm.cmbTimeZone.options[
				  document.setParametersForm.cmbTimeZone.selectedIndex].value;
			  openWindow(window, url, 'showTimeRange', 
						 {width:825,height:470,
						 scrollbars:true,resizable:false, location:false,
						 status:false,top:150,left:80},true,'dialog',myCallBack);   
			}
			
			function myCallBack()
			{
			} 
			
			function generateStrTimeRange(selTime)
			{
			  document.setParametersForm.selTimeRange.value = selTime;
			  document.setParametersForm.tblAnchor.value = 'tableAnchor';
			  document.setParametersForm.anchor.value = 'tableAnchor';
			  submitForm('setParametersForm',1,{'event':'add'});
			  return false;
			}

                       //adding code for setting anchor in <head> section of the html page
                       //doing the page load, to fix page hanging in safari browser(bug 4625133).
                       function loadContent(){
                           var head = document.getElementsByTagName('head').item(0);
                           var scriptTag = document.getElementById('loadScript');
                           if(scriptTag) head.removeChild(scriptTag);
                           script = document.createElement('script');
                           //script.src = file;
                           script.type = 'text/javascript';
                           script.id = 'loadScript';
                           //script.text='document.location.hash=\"tableAnchor\"';
			   script.text='document.location.hash=document.forms[0].anchorFromRequest.value';
                           head.appendChild(script);
                      }

//                      if(document.setParametersForm.tblAnchor.value != '')
  //                    {
                        //document.location.hash = document.setParametersForm.tblAnchor.value;
                        //set anchor only when the time range is added thru the popup
                        var urlStr = document.location.href;
                        if(urlStr.indexOf('event=doLoad')<0){
                           loadContent();
						   if(document.location.href.indexOf('#')<0){
						   //if the anchor has not been set in any case, then do it thru
						   //window onload event,which sets the anchor (this is particularly
						   //for the anchor to work in safari)
						    window.onload = setAnchorByEvent;
						   }
                        }
    //                  }
					  function setAnchorByEvent(){
					     _checkLoad(event);
					   //  document.location.hash = 'tableAnchor';
					document.location.hash=document.forms[0].anchorFromRequest.value;
					  }
		" />
  </uix:dataScope> 
</oem:pageSegment>
