<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsgID'%>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsg' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>

<oem:pageSegment>
  <uix:dataScope> 
    <uix:bundle name="servicesBundle"
               class="oracle.sysman.resources.eml.ip.emr.services.ServicesMsg"/>
    <uix:stackLayout>
      <uix:contents>

        <%-- error to be reported to end user if applicable --%>
        <uix:stackLayout rendered="false" 
                         renderedBinding="showError@pageSegmentBean@">
          <uix:contents>
            <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                            messageTypeBinding="messageType@pageSegmentBean@"
                            textBinding="errorMessageTitle@pageSegmentBean@"/>
          </uix:contents>
        </uix:stackLayout>

        <%-- element content --%>
        <uix:stackLayout rendered="true" 
                         renderedBinding="showContent@pageSegmentBean@">
          <uix:contents>  
            <uix:spacer height="10"/>
            <uix:header textBinding="SERVICE_SELECTION@servicesBundle">
              <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat>
                    <uix:styledText 
                      textBinding="INLINE_SVC_SEL_TXT@servicesBundle" 
                      styleClass="OraInstructionText" />
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat>
                    <uix:stackLayout rendered="false" 
                              renderedBinding="showLateMsg@servletRequest">
                      <uix:contents>
                        <uix:messageBox 
                          messageBinding="LATE_BOUND_MSG@servicesBundle"
                          messageType="information" />
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat>
                    <uix:spacer width="5" />
                    <uix:shuttle name="serviceCombo" styleClass="OraHeaderSubSub" 
                         leadingHeaderBinding="AVAILABLE_SERVICES@servicesBundle" 
                         trailingHeaderBinding="SELECTED_SERVICES@servicesBundle">
                      <uix:leading>
                        <uix:list
                          multiple="true"
                          shortDescBinding="AVAILABLE_SERVICES@servicesBundle">
                          <uix:contents 
                               childDataBinding="leadingList@pageSegmentBean@">
                            <uix:option textBinding="svcName" 
                                        valueBinding="combo"/>
                          </uix:contents>
                        </uix:list>
                      </uix:leading>
                      <uix:trailing>
                        <uix:list
                          multiple="true"
                          shortDescBinding="SELECTED_SERVICES@servicesBundle">
                          <uix:contents 
                               childDataBinding="trailingList@pageSegmentBean@">
                            <uix:option textBinding="svcName" 
                                        valueBinding="combo"/>
                          </uix:contents>
                        </uix:list>
                      </uix:trailing>
                    </uix:shuttle>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>

      </uix:contents>
    </uix:stackLayout>
</uix:dataScope> 
</oem:pageSegment>