<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.bean.ServiceDetailsBean' %>
<%@ page import='java.util.ArrayList' %>
<%@ page import='java.util.Date' %>
<%@ page import='java.text.SimpleDateFormat' %>
<%@ page import='java.util.ResourceBundle' %>
<%@ page import='oracle.sysman.emSDK.util.jdk.NLSUtil' %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsgID' %>
<%@ page import='oracle.sysman.resources.eml.ip.emr.services.ServicesMsg' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.emr.services.constants.ServiceConstants'%>

<%@ page import='oracle.sysman.emSDK.chart.SimpleChartDataSource'%>

<oem:pageSegment>
  <uix:dataScope> 
<uix:script source="/em/jsLibs/ReportElemJScript.js"/>
    <uix:bundle name="servicesBundle"
    class="oracle.sysman.resources.eml.ip.emr.services.ServicesMsg"/>
    <uix:stackLayout>
      <uix:contents>

        <%-- error to be reported to end user if applicable --%>
        <uix:stackLayout rendered="false" 
                         renderedBinding="showError@pageSegmentBean@">
          <uix:contents>
            <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                            messageTypeBinding="messageType@pageSegmentBean@"
                            textBinding="errorMessageTitle@pageSegmentBean@"/>
          </uix:contents>
        </uix:stackLayout>

        <%-- element content --%>
        <uix:stackLayout rendered="true" 
                         renderedBinding="showContent@pageSegmentBean@">
          <uix:contents>
            <%
              PageSegmentContext psContext = 
                 (PageSegmentContext)request.getAttribute("pageSegmentContext");
              ServiceDetailsBean bean = 
                (ServiceDetailsBean)psContext.getPageSegmentBean();
              ResourceBundle rb = null;
              rb = NLSUtil.getBundle(ServicesMsg.class.getName(),request);
            %>

            <uix:tableLayout borderWidth="0">
              <uix:rowLayout width="100%" >
                <uix:cellFormat columnSpan="9">
                  <uix:spacer height="3"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout width="100%" >
                <uix:cellFormat columnSpan="9">
                  <uix:spacer width="10"/>
                  <uix:breadCrumbs > 
                    <uix:contents>
                      <uix:link textBinding="dashboard@pageSegmentBean@" 
                                destinationBinding="dashpath@pageSegmentBean@"/>
                      <uix:link textBinding="serviceStatusStr@pageSegmentBean@" />
                    </uix:contents>
                  </uix:breadCrumbs>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat columnSpan="9">
                  <uix:spacer height="3"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout width="100%" >
                <uix:cellFormat styleClass="OraNonCompactTableColumnMainHeader" 
                                columnSpan="9">
                  <uix:spacer width="12"/>
                  <uix:styledText 
                    textBinding="serviceStatusStr@pageSegmentBean@" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout styleClass="OraNonCompactTableColumnHeaderThin" 
                           vAlign="center" width="100%" >  

                <uix:cellFormat width="1%" hAlign="left" vAlign="center" 
                        styleClass="OraNonCompactTableColumnHeaderThin">
                  <uix:spacer width="11"/>
                </uix:cellFormat>
                <uix:cellFormat styleClass="OraNonCompactTableColumnHeaderThin" 
                              hAlign="left" 
                              vAlign="center" 
                              width="2%">    
                  <uix:styledText textBinding="SC_VIEW@servicesBundle" 
                                  styleClass="OraFilterText"/>
                  <uix:spacer width="4" />
                </uix:cellFormat>

                <uix:cellFormat width="10%" height="25" hAlign="left"  vAlign="center" 
                            styleClass="OraNonCompactTableColumnHeaderThin" >
                 
                <uix:formValue  name="resetList0" value="" />

                  <uix:messageChoice 
                    styleClass="OraFilterText" 
                    name="durationIndex" 
                    selectedValueBinding="duration@pageSegmentBean@" 
					shortDescBinding="SC_VIEW@servicesBundle"
                    onChange="onChangeView()"> 
                    <uix:option textBinding="LAST_24_HOURS@servicesBundle" 
                                value="1" />
                    <uix:option textBinding="LAST_7_DAYS@servicesBundle" 
                                value="7" />
                    <uix:option textBinding="LAST_31_DAYS@servicesBundle" 
                                value="31" />
                    <uix:spacer width="10" />
                  </uix:messageChoice>
                  
                </uix:cellFormat >

                <uix:cellFormat  wrappingDisabled="true" 
                                 styleClass="OraNonCompactTableColumnHeaderThin" 
                                 hAlign="left" vAlign="center" width="6%">
                  <uix:spacer width="10" />
                  <uix:styledText textBinding="TIMEZONE@servicesBundle"
                                  renderedBinding="flagToRenderTZ@pageSegmentBean@" 
                                  styleClass="OraFilterText"/>
                </uix:cellFormat>

                <uix:cellFormat  width="8%" hAlign="left" vAlign="center"
                         height="25" styleClass="OraNonCompactTableColumnHeaderThin">
                  <uix:choice 
                    name="<%=ServiceConstants.DISPLAY_TIMEZONE%>"
                    styleClass="OraFilterText" 
                    selectedValueBinding="dispTimeZoneID@pageSegmentBean@" 
		    shortDescBinding="TIMEZONE@servicesBundle"
		    renderedBinding="flagToRenderTZ@pageSegmentBean@"
                    onChange="onChangeView()"> 
                    <uix:option 
                        textBinding="dashname@pageSegmentBean@" 
                        valueBinding="repTimeZoneID@pageSegmentBean@" />
                    <uix:option 
                        textBinding="sername@pageSegmentBean@" 
                        valueBinding="tgtTimeZoneID@pageSegmentBean@"  />
                  </uix:choice>
	          <uix:spacer width="1" />
                </uix:cellFormat>
                
                <uix:cellFormat  vAlign="center" hAlign="left" 
                  styleClass="OraNonCompactTableColumnHeaderThin" width="20%" >
                  <uix:spacer width="11"/>
                </uix:cellFormat>
                
                <uix:cellFormat 
                    width="29%" vAlign="center"  height="25" 
                    styleClass="OraNonCompactTableColumnHeaderThin" 
                    hAlign="right">  
                  <uix:styledText 
                      styleClass="OraPageRefreshText" 
                      textBinding="REFRESH_STRING@servicesBundle"/>
                    <uix:spacer width ="3"/>
                    <uix:styledText 
                        styleClass="OraPageRefresh" 
                        textBinding="pageRefresh@pageSegmentBean@"/>
                  <uix:spacer width="10"/>
                </uix:cellFormat>    
                
                <uix:cellFormat hAlign="left" vAlign="center" width="5%" 
                                height="25" 
                                styleClass="OraNonCompactTableColumnHeaderThin">
                  <uix:tableLayout  borderWidth="0">
                    <uix:rowLayout >
                      <uix:cellFormat>
                        <uix:spacer width="3"/>
                      </uix:cellFormat> 
                    </uix:rowLayout>

                    <uix:rowLayout >
                      <uix:cellFormat hAlign="left" vAlign="center" height="17" 
                                      width="2%"  styleClass="OraBackground">
                        <uix:link  textBinding="REFRESH@servicesBundle" 
                                   styleClass="OraBackgroundText"  
                                   destinationBinding="refreshURL@pageSegmentBean@" /> 
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout >
                      <uix:cellFormat>
                        <uix:spacer width="3"/>
                      </uix:cellFormat> 
                    </uix:rowLayout>
                  </uix:tableLayout>
                 </uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="center" width="1%" 
                    height="25" styleClass="OraNonCompactTableColumnHeaderThin"> 
                  <uix:spacer width="3" />
                </uix:cellFormat>  
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat columnSpan="7">
                  <uix:spacer height="5"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout borderWidth="0" width="100%">
              <uix:rowLayout>
                <uix:cellFormat width="1%" rowSpan="6">
                  <uix:spacer width="1"/>
                </uix:cellFormat>
                <uix:cellFormat 
                     styleClass="OraNonCompactTableColumnHeader" 
                     wrappingDisabled="true" vAlign="top" hAlign="left" 
                     columnSpan="2">
                  <uix:spacer width="5" />
                  <uix:styledText textBinding = "GENERAL@servicesBundle" />
                </uix:cellFormat>

                  <%
                    if(bean.getSysName() != null)
                    {
                  %>
                      <uix:cellFormat width="1%" rowSpan="3">
                      <uix:spacer width="1"/>
                      </uix:cellFormat>

                      <uix:cellFormat vAlign="top" width="18%" 
                                      hAlign="left" rowSpan="3">

                        <uix:tableLayout width="100%" borderWidth="0">
                          <uix:rowLayout >
                            <uix:cellFormat 
                                width="100%" 
                                styleClass="OraNonCompactTableColumnHeader" 
                                columnSpan="5" wrappingDisabled="true">
                              <uix:spacer width="5" />
                              <uix:styledText 
                                  textBinding="SYSTEM_STATUS@servicesBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:cellFormat columnSpan="5">
                            <uix:spacer height="5"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:cellFormat wrappingDisabled="true" 
                                          hAlign="right" vAlign="center">
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="SYSTEM@servicesBundle"/>
                          </uix:cellFormat>
                          <uix:cellFormat wrappingDisabled="true">
                            <uix:spacer width="8"/>
                          </uix:cellFormat>
                          <uix:cellFormat columnSpan="3"  wrappingDisabled="true" 
                                          vAlign="center">
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="sysName@pageSegmentBean@" 
                                destinationBinding="sysURL@pageSegmentBean@"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:cellFormat wrappingDisabled="true" rowSpan="5" 
                                          hAlign="right" vAlign="top">
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="COMPONENTS@servicesBundle"/>
                          </uix:cellFormat>
                          <uix:cellFormat wrappingDisabled="true" rowSpan="5">
                            <uix:spacer width="8"/>
                          </uix:cellFormat>
                          <uix:cellFormat width="8%" wrappingDisabled="true" 
                                          vAlign="center" hAlign="center">
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="compDownCount@pageSegmentBean@" 
                                destinationBinding="sysURL@pageSegmentBean@"/>
                          </uix:cellFormat>
                          <uix:cellFormat width="18%" wrappingDisabled="true" 
                                          vAlign="center" hAlign="center">
                            <uix:image  source='<%=request.getContextPath()+"/images/down13.gif"%>'/>
                          </uix:cellFormat>
                          <uix:cellFormat wrappingDisabled="true" 
                                          vAlign="center" >
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="DOWN@servicesBundle" />
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:cellFormat wrappingDisabled="true" 
                                          vAlign="center" hAlign="center">
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="compUpCount@pageSegmentBean@" 
                                destinationBinding="sysURL@pageSegmentBean@"/>
                          </uix:cellFormat>
                          <uix:cellFormat wrappingDisabled="true" 
                                          vAlign="center" hAlign="center">
                            <uix:image  source='<%=request.getContextPath()+"/images/up13.gif"%>'/>
                          </uix:cellFormat>
                          <uix:cellFormat wrappingDisabled="true" vAlign="center">
                            <uix:styledText 
                                styleClass="OraNonCompactTableTextStyle"  
                                textBinding="UP@servicesBundle" />
                          </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat wrappingDisabled="true" 
                                            vAlign="center" hAlign="center">
                              <uix:styledText 
                                  styleClass="OraNonCompactTableTextStyle"  
                                  textBinding="compUnknownCount@pageSegmentBean@" 
                                  destinationBinding="sysURL@pageSegmentBean@"/>
                            </uix:cellFormat>
                            <uix:cellFormat wrappingDisabled="true" 
                                            vAlign="center" hAlign="center">
                              <uix:image  source='<%=request.getContextPath()+"/images/unknown13.gif"%>'/>
                            </uix:cellFormat>
                            <uix:cellFormat wrappingDisabled="false" vAlign="center" >
                              <uix:styledText 
                                  styleClass="OraNonCompactTableTextStyle"  
                                  textBinding="UNKNOWN_M@servicesBundle" />
                            </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>

                    </uix:cellFormat>
                  <%
                    }
                  %>
              </uix:rowLayout>

              <uix:rowLayout>

                <uix:cellFormat wrappingDisabled="true" 
                                vAlign="top" hAlign="left">
                  <uix:tableLayout borderWidth="0" 
                                   cellPadding ="0" cellSpacing="1">
                    <uix:rowLayout vAlign="center">
                      <uix:cellFormat vAlign="center" 
                                      hAlign="right" rowSpan="3">
                        <uix:image 
                            sourceBinding ="currentStatusImage@pageSegmentBean@" 
                            shortDescBinding="currentStatusDesc@pageSegmentBean@"/>
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="center" hAlign="right">
                        <uix:styledText 
                            styleClass="OraSLDetails" 
                            textBinding="CURRENT_STATUS@servicesBundle" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="7" />
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="center" hAlign="left">
                        <uix:styledText 
                            styleClass="OraSLDetailsBold" 
                            textBinding ="currentStatus@pageSegmentBean@" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout vAlign="center">
                      <uix:cellFormat vAlign="center" hAlign="right">
                        <uix:styledText 
                            styleClass="OraSLDetails" 
                            textBinding="SINCE@servicesBundle" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="7" />
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="center" hAlign="left">
                        <uix:styledText 
                            styleClass="OraSLDetailsBold" 
                            textBinding ="statusSince@pageSegmentBean@" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout vAlign="center">
                      <uix:cellFormat vAlign="center" hAlign="right">
                        <uix:styledText 
                            styleClass="OraSLDetails" 
                            textBinding="AVAIL_PCT@servicesBundle" />>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="7" />
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="center" hAlign="left">
                        <uix:styledText 
                            styleClass="OraSLDetailsBold" 
                            textBinding ="availPcnt@pageSegmentBean@" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout vAlign="center">
                      <uix:cellFormat vAlign="center" 
                                      hAlign="right" columnSpan="2">
                        <uix:styledText 
                            styleClass="OraSLDetails" 
                            textBinding="DOWN_TIME_MINS@servicesBundle" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="7" />
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="center" hAlign="left">
                        <uix:styledText 
                              styleClass="OraSLDetailsBold" 
                              textBinding ="downTimeMins@pageSegmentBean@" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout vAlign="center">
                      <uix:cellFormat vAlign="center" hAlign="right" columnSpan="2">
                        <uix:styledText 
                           styleClass="OraSLDetails" 
                           textBinding="UNMONITORED_TIME_MINS@servicesBundle" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="7" />
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="center" hAlign="left">
                        <uix:styledText styleClass="OraSLDetailsBold" 
                               textBinding ="unmonTimeMins@pageSegmentBean@" />
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>

                <uix:cellFormat wrappingDisabled="true" vAlign="center" 
                                hAlign="center" width="40%">
                  <%
                    if(bean.getPieData() != null) 
                    {
                    %>
                      <oem:chart  chartType="pieChart"  
                                  shadowEffect="3d" 
                                  pieSlicesFromColumn="true" 
                                  pieValuesInLegend ="percent" 
                                  legendVisible="true" 
                                  backgroundColor ="#FFFFFE" 
                                  showSlicePercentLabels="false"  
                                  width="380"
                                  height="140"
                                  hideZeroSlices="false" 
                                  legendWidthFraction ="1.0">
                        <oem:boundChartDataSource 
                             chartDataSourceBinding="pieData@pageSegmentBean@"/>
                        <%-- set label and color for pie slices--%>
                        <oem:chartColumn  
                          displayLabel="<%=rb.getString(ServicesMsgID.UP_TIME)%>"
                          sourceIndex="0" 
                          itemColor="#CCFFCC" /> <%-- green --%>                  
                        <oem:chartColumn  
                          displayLabel="<%=rb.getString(ServicesMsgID.DOWN_TIME)%>"
                          sourceIndex="1" 
                          itemColor="#FC6666" />   <%-- red --%>
                        <oem:chartColumn  
                          displayLabel="<%=rb.getString(ServicesMsgID.UNKNOWN_M)%>"
                          sourceIndex="2" 
                          itemColor="#FFFFFF" /> <%-- White --%>
                      </oem:chart>
                  <%
                    }
                    else
                    {
                  %>
                      <uix:styledText 
                                textBinding="NO_DATA@servicesBundle" 
                                styleClass="OraNonCompactTableTextStyle" />
                  <%
                    }
                  %>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout >
                <uix:cellFormat columnSpan="2">
                  <uix:spacer width="10" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat wrappingDisabled="true" vAlign="top" 
                                hAlign="left" columnSpan="4">
                  <uix:link name="availability" />
				  <uix:include 
                        nodeBinding="serviceDetailsTable@pageSegmentBean@" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout >
                <uix:cellFormat columnSpan="4">
                  <uix:spacer width="10" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat columnSpan="5">
                  <uix:link name="alerts"/>
                  <uix:include nodeBinding="alertsTableLayoutBean@pageSegmentBean@" />  
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>
            <uix:formValue  name="rootList" 
                            value="<%=bean.getStrRootList()%>" />
            <uix:formValue  name="expandList" 
                            value="<%=bean.getStrNodeExpandList()%>" />
            <uix:formValue  name="dashRep" 
                            value="<%=bean.getDashRep()%>" />
            <uix:formValue  name="dashRepId" 
                            value="<%=bean.getDashRepID()%>" />
            <uix:formValue  name="<%=ServiceConstants.SELECTED_TIMEZONE%>" 
                            value="<%=bean.getRepTimeZoneID()%>" />

          </uix:contents>
        </uix:stackLayout>

      </uix:contents>
    </uix:stackLayout>
  </uix:dataScope> 
  <uix:script text='
    function onChangeView()
    {
      if(document.forms[0].resetList0)
        document.forms[0].resetList0.value="true";
      document.forms[0].submit();
     }
    setAnchorInPage("");

	'/> 
</oem:pageSegment>
