<%-- 

/* $Header: imageParam.jsp 17-jun-2005.09:57:07 lgloyd Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Image parameters
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      lgloyd    06/17/05 - reorder params 
      lgloyd    06/09/05 - strings to resource file 
 */

/**
 *  @version $Header: imageParam.jsp 17-jun-2005.09:57:07 lgloyd Exp $
 *  @author  jabramso
 *  @since   10.2.0.0
 */

--%>
<%--
  -- Page:        imageParam.jsp
  -- Controller:  eml/ip/render/element/ImageParamController.java
  -- Bean:        eml/ip/render/element/ImageParamBean.java
  --
  -- Description: Set parameters for the image element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
<uix:dataScope>

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>

  <uix:tableLayout>

    <uix:rowLayout>      
      <uix:cellFormat
          hAlign="right"
          vAlign="top">    
        <uix:styledText textBinding="IMAGE_FILE_PROMPT@ipBundle"
                        styleClass="OraPromptText"/>
        <uix:spacer width="5"/>
      </uix:cellFormat>
      <uix:fileUpload
         name="oracle"
         columns="80"
         shortDescBinding="IMAGE_FILE_PROMPT@ipBundle"/>
    </uix:rowLayout>                   

    <uix:rowLayout>      
      <uix:spacer width="5"/>
      <uix:styledText textBinding="IMAGE_FILE_TIP@ipBundle" styleClass="OraTipText"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:cellFormat
          hAlign="right"
          vAlign="top">    
        <uix:styledText textBinding="IMAGE_LINK_PROMPT@ipBundle"
                        styleClass="OraPromptText"/>
        <uix:spacer width="5"/>
      </uix:cellFormat>
       <uix:textInput name="href"
                  shortDescBinding="IMAGE_LINK_PROMPT@ipBundle"
                  columns="60"
                  rows="1"
                  required="no"
                  textBinding="href@pageSegmentBean@"/>
      </uix:rowLayout>                   

    <uix:rowLayout>      
      <uix:spacer width="5"/>
      <uix:styledText textBinding="IMAGE_LINK_TIP@ipBundle" styleClass="OraTipText"/>
    </uix:rowLayout>      

  </uix:tableLayout>
</uix:dataScope>
</oem:pageSegment>

      
