<%--

/* $Header: licensingParam.jsp 25-apr-2005.05:53:48 vkgarg Exp $ */

/* Copyright (c) 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    vkgarg      04/25/05 - place radio buttons correctly 
    vkgarg      03/17/05 - vkgarg_bug-3996615
    vkgarg      03/15/05 - check for int in row nums
    vkgarg      03/15/05 - remove 2 all reports
    vkgarg      03/10/05 - Creation
*/

/**
 *  @version $Header: licensingParam.jsp 25-apr-2005.05:53:48 vkgarg Exp $
 *  @author  vkgarg
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        licensingParam.jsp
  -- Controller:  eml/ip/render/element/licensing/LicensingParamController.java
  -- Bean:        eml/ip/render/element/licensing/LicensingParamBean.java
  --
  -- Description: Set parameters for the licensing element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>

    <uix:dataScope>
    <uix:bundle name="licBundle"
          class="oracle.sysman.eml.license.LicenseMsg"/>
    <uix:bundle name="ipBundle"
          class="oracle.sysman.resources.eml.ip.IPMsg"/>
        <uix:contents>
              <uix:spacer height="12"/>
              <uix:rowLayout>
                  <uix:messageTextInput name="numRows"
                                        promptBinding="NUM_ROWS_TO_SHOW@ipBundle"
                                        columns="3"
                                        textBinding="noOfRows@licensingParamBean@">
                                <uix:onSubmitValidater>
                                    <uix:decimal/>
                                </uix:onSubmitValidater>
                  </uix:messageTextInput>
              </uix:rowLayout>
              <uix:spacer height="12"/>
               <uix:tableLayout width="50%">
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="LICENSING_RPT_TYPE@licBundle"/>                                                 
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:radioButton name="reportType"
                                         textBinding="LICENSABLE_TARGETS_PACK_ACCESS_AGREED@licBundle"
                                         shortDescBinding="LICENSABLE_TARGETS_PACK_ACCESS_AGREED@licBundle"
                                         selectedValueBinding = "reportType@licensingParamBean@"
                                         value="1">
                        </uix:radioButton>
                      </uix:cellFormat>
                    </uix:rowLayout>
                      <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraPromptText"
                                        text=""/>                                                 
                      </uix:cellFormat>                                              
                        <uix:cellFormat>
                        <uix:radioButton name="reportType"
                                         textBinding="LICENSABLE_TARGETS_PACK_ACCESS_NOT_AGREED@licBundle"
                                         shortDescBinding="LICENSABLE_TARGETS_PACK_ACCESS_NOT_AGREED@licBundle"
                                         selectedValueBinding = "reportType@licensingParamBean@"
                                         value="2" >
                        </uix:radioButton>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraPromptText"
                                        text=""/>                                                 
                      </uix:cellFormat>                                               
                      <uix:cellFormat>
                        <uix:radioButton name="reportType"
                                         textBinding="ALL_TARGETS_PACK_ACCESS_AGREED@licBundle"
                                         shortDescBinding="ALL_TARGETS_PACK_ACCESS_AGREED@licBundle"
                                         selectedValueBinding = "reportType@licensingParamBean@"
                                         value="4">
                        </uix:radioButton>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraPromptText"
                                        text=""/>                                                 
                      </uix:cellFormat>                                               
                      <uix:cellFormat>
                        <uix:radioButton name="reportType"
                                         textBinding="ALL_TARGETS_PACK_ACCESS_NOT_AGREED@licBundle"
                                         shortDescBinding="ALL_TARGETS_PACK_ACCESS_NOT_AGREED@licBundle"
                                         selectedValueBinding = "reportType@licensingParamBean@"
                                         value="5" >
                        </uix:radioButton>
                        </uix:cellFormat>
                      </uix:rowLayout>                                            
                 </uix:tableLayout>           
        </uix:contents>
    </uix:dataScope>

</oem:pageSegment>
