<%--

/* $Header: licensingRender.jsp 27-feb-2006.15:50:26 hmodawel Exp $ */

/* Copyright (c) 2005, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    hmodawel    02/27/06 - fix ojsp 1013 compilation errors 
    vmotamar    03/29/05 - Bug No 4259536 
    vkgarg      03/17/05 - vkgarg_bug-3996615
    vkgarg      03/15/05 - add legend
    vkgarg      03/11/05 - Creation
*/

/**
 *  @version $Header: licensingRender.jsp 27-feb-2006.15:50:26 hmodawel Exp $
 *  @author  vkgarg
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        licensingRender.jsp
  -- Controller:  eml/ip/render/element/licensing/LicensingRenderController.java
  -- Bean:        eml/ip/render/element/licensing/LicensingRenderBean.java
  --
  -- Description: Render the licensing Report based on Licensing element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.page.seg.PageSegmentContext"%>
<%@ page import="oracle.sysman.eml.ip.render.elem.licensing.LicensingRenderBean"%>
<%@ page import="oracle.sysman.eml.ImageNames"%>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="licBundle"
          class="oracle.sysman.eml.license.LicenseMsg"/>
    <uix:bundle name="ipBundle"
          class="oracle.sysman.resources.eml.ip.IPMsg"/>
    <uix:bundle name="mntrResourceBundle"
          class="oracle.sysman.resources.MntrResourceBundle"/>

<%
    PageSegmentContext psc =
        (PageSegmentContext)request.getAttribute("pageSegmentContext");
    LicensingRenderBean licensingRenderBean = (LicensingRenderBean)psc.getPageSegmentBean();
%>

      <uix:stackLayout rendered="false"
                        renderedBinding="showError@pageSegmentBean@">
         <uix:contents>
           <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                           messageTypeBinding="messageType@pageSegmentBean@"
                           textBinding="errorMessageTitle@pageSegmentBean@"/>
         </uix:contents>
      </uix:stackLayout>

    <uix:stackLayout>
      <uix:contents>
            <uix:table nameBinding="name@pageSegmentBean@"
                    partialRenderMode="self"
                    alternateTextBinding="NO_TARGETS_FOUND@mntrResourceBundle"
                    width="90%" blockSizeBinding="blockSize@pageSegmentBean@"
                    valueBinding="value@pageSegmentBean@"
                    minValueBinding="minValue@pageSegmentBean@"
                    maxValueBinding="maxValue@pageSegmentBean@"
                    formSubmitted="true"
                    tableDataBinding="tableDataKey@tableData@pageSegmentBean@"
                    columnFormatsBinding="columnFormats@pageSegmentBean@"
                    columnHeaderDataBinding="columnHeaderData@pageSegmentBean@"
                    showAll="yes">
              <uix:tableFormat tableBanding="rowBanding"/>

            <%
              if (licensingRenderBean.isPrintablePage())
              { // table should not be sortable
            %>
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" />
                  </uix:columnHeaderStamp>
            <%
              }
              else
              {
            %>
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                  </uix:columnHeaderStamp>
            <%
              }
            %>

              <uix:contents>
                 <uix:styledText textBinding="targetName@"/>
                 <uix:styledText textBinding="targetType@"/>
                 <uix:styledText textBinding="hostName@"/>


                <%
                  if (licensingRenderBean.getPackArray() !=null)
                  {
                      String [] packs = licensingRenderBean.getPackArray();
                      for(int i=0; i < packs.length; i++)
                      {
                        String shortDescr = packs[i] + " shortDesc";
                %>
                        <uix:image sourceBinding="<%=packs[i]%>"
                            shortDescBinding="<%=shortDescr%>" hAlign="center"/>
                <%
                      }
                  }
                %>
                <%
                  if (licensingRenderBean.getShowAgreeAccess().booleanValue())
                  {
                %>
                    <uix:image sourceBinding="agreeAccess@"
                               shortDescBinding="agreeAccessShortDesc@" hAlign="center" />

                <%
                  }
                %>

                </uix:contents>
            </uix:table>
      </uix:contents>
    </uix:stackLayout>
    <uix:spacer height ="20"/>
    <uix:stackLayout>
         <uix:contents>
            <uix:rowLayout>
                <uix:image source ="/em/images/ApplicableAndLicensed.gif"
                           shortDescBinding="APPLICABLE_AND_LICENSED@licBundle" hAlign="center" />
                <uix:spacer width ="6"/>
                <uix:styledText textBinding="APPLICABLE_AND_LICENSED@licBundle"
                                styleClass = "OraPromptText" />
                <uix:spacer width ="20"/>
                <uix:image source ="/em/images/ApplicableAndNotLicensed.gif"
                           shortDescBinding="APPLICABLE_AND_NOT_LICENSED@licBundle" hAlign="center" />
                <uix:spacer width ="6"/>
                <uix:styledText textBinding="APPLICABLE_AND_NOT_LICENSED@licBundle"
                                styleClass = "OraPromptText" />
                <uix:spacer width ="20"/>
                <uix:image source ="/em/images/sysdash_notappl.gif"
                           shortDescBinding="NOT_APPLICABLE@licBundle" hAlign="center" />
                <uix:spacer width ="6"/>
                <uix:styledText textBinding="NOT_APPLICABLE@licBundle"
                                styleClass = "OraPromptText" />

            </uix:rowLayout>
         </uix:contents>
    </uix:stackLayout>

  </uix:dataScope>
</oem:pageSegment>
