<%-- 

/* $Header: metdetParam.jsp 30-jun-2005.15:28:46 jabramso Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Metric details element
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      jabramso  06/30/05 - 
      jabramso  06/22/05 - "add tip text below list of metrics " 
      jabramso  06/22/05 - 
      lgloyd    02/18/05 - inheritance
      lgloyd    01/27/05 - time period work 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    10/18/04 - jit types 
      lgloyd    08/23/04 - 
      lgloyd    06/14/04 - 
 */

/**
 *  @version $Header: metdetParam.jsp 30-jun-2005.15:28:46 jabramso Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        metdetParam.jsp
  -- Controller:  eml/ip/render/element/MetDetParamController.java
  -- Bean:        eml/ip/render/element/MetDetParamBean.java
  --
  -- Description: Set parameters for the metric details element
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>
<uix:bundle name="commonBundle"
            class="oracle.sysman.resources.eml.CommonResourceBundle"/>

<uix:contents>

  <uix:stackLayout>

    <%-- uix:rowLayout>
        <uix:contents>
           <uix:messageChoice 
                nameBinding="ctlTimeFrameChoice@pageSegmentBean@"
                promptBinding="SELECT_TIMEFRAME_COLON@ipBundle"
                selectedValueBinding="selectedTimeframePageType@pageSegmentBean@">
                   <uix:contents childDataBinding="selectedTimeframeChoiceList@pageSegmentBean@">
                      <uix:option textBinding="text"
                                  valueBinding="val"/>
                   </uix:contents>
           </uix:messageChoice>    
        </uix:contents>
    </uix:rowLayout --%>
 
    <uix:spacer height="5"/>

    <uix:switcher childNameBinding="showTxns@pageSegmentBean@pageSegmentContext@servletRequest">
      
      <uix:case name="false">
         <uix:stackLayout>
         </uix:stackLayout>
      </uix:case>

      <uix:case name="true">

         <uix:stackLayout>
           <uix:contents>
              <uix:header
                      textBinding="AVAILABLE_TRANSACTIONS@ipBundle">
                <uix:spacer height="5"/>
                <uix:stackLayout>
                  <uix:styledText
                        styleClass="OraInstructionText"
                        textBinding="transactionsLateBinding@pageSegmentBean@"/>
                 <uix:spacer height="5"/>
                  <uix:messageList sizeBinding="txnListSize@pageSegmentBean@" 
                    nameBinding="ctlTxnChoice@pageSegmentBean@" 
                    promptBinding="METDET_SELECT_TRANSACTION@ipBundle"
                    multiple="false"
                    selectedValueBinding="selectedTransactionValue@pageSegmentBean@">
                      <uix:contents childDataBinding="transactionValues@pageSegmentBean@">
                        <uix:option textBinding="text" valueBinding="text" />
                      </uix:contents>
                  </uix:messageList>
                </uix:stackLayout>
               </uix:header>

           </uix:contents>
         </uix:stackLayout>    

      </uix:case>

  </uix:switcher>

    <uix:spacer height="10"/>

    <uix:contents>
      <uix:header textBinding="METRIC@ipBundle">


        <uix:rowLayout>

            <uix:messageList 
              nameBinding="ctlMetricChoice@pageSegmentBean@" 
              promptBinding="SELECT_METRIC_COLON@ipBundle"
              multiple="false"
              tipBinding="METDET_POPULATE_METRIC_LIST_HINT@ipBundle"
              selectedValueBinding="selectedMetricValue@pageSegmentBean@">
                  <uix:contents 
                    childDataBinding="availMetrics@pageSegmentBean@" >
                    <uix:option textBinding="text" valueBinding="val"/>
                  </uix:contents>
            </uix:messageList>
        </uix:rowLayout>
      </uix:header>
    </uix:contents>

    <uix:spacer height="5"/>
  </uix:stackLayout>
</uix:contents>
</uix:dataScope> 

</oem:pageSegment>

