<%-- 

/* $Header: metdetRender.jsp5871 15-aug-2005.15:30:52 jabramso Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render a the metric details element
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      jabramso  08/15/05 - "support y axis 1-100% labelling " 
      jabramso  08/15/05 - 
      jabramso  05/03/05 - make chart title unique 
      jabramso  02/23/05 - remove Avg from label 
      lgloyd    01/27/05 - 
      jabramso  01/11/05 - min-max-avg line 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    11/04/04 - cosmetics
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    05/13/04 - 
 */

/**
 *  @version $Header: metdetRender.jsp5871 15-aug-2005.15:30:52 jabramso Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%--
  -- Page:        metdetRender.jsp
  -- Controller:  eml/ip/render/element/MetDetRenderController.java
  -- Bean:        eml/ip/render/element/MetDetRenderBean.java
  --
  -- Description: Render the metric details element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<oem:pageSegment>

<uix:dataScope>

<uix:bundle name="mntrBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>

<uix:stackLayout>
  <uix:contents>

    <%-- error to be reported to end user if applicable --%>
    <uix:stackLayout rendered="false"
                      renderedBinding="showError@pageSegmentBean@">
       <uix:contents>
         <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                         messageTypeBinding="messageType@pageSegmentBean@"
                         textBinding="errorMessageTitle@pageSegmentBean@"/>
       </uix:contents>
    </uix:stackLayout>

    <%-- element content --%>
    <uix:stackLayout rendered="true"
                      renderedBinding="showContent@pageSegmentBean@">
      <uix:contents>

        <uix:styledText textBinding="title@pageSegmentBean@" 
                        styleClass="OraPromptText"/>
        
        <oem:chart 
               titleBinding="chartTitle@pageSegmentBean@"
               titleVisible="false"
               chartTypeBinding="chartType@pageSegmentBean@"
               widthBinding="width@pageSegmentBean@"
               heightBinding="height@pageSegmentBean@" 
               legendPositionBinding="legendPosition@pageSegmentBean@"
               legendVisible="external"
               axisMinBinding="axisMin@pageSegmentBean@"
               axisMaxBinding="axisMax@pageSegmentBean@"
               yAxisSuffixBinding="axisSuffix@pageSegmentBean@"
               >
            <uix:contents>
              <oem:boundChartDataSource 
                    chartDataSourceBinding="chartDataSource@pageSegmentBean@" />
              <oem:chartColumn isKey="true"
                                 displayLabel=""
                                 sourceIndex="0"/>
              <oem:chartColumn isTimeColumn="true"
                                 displayLabel=""
                                 sourceIndex="1"/>
              <oem:chartColumn displayLabel=""
                                 sourceIndex="2"
                                 renderedBinding="showJustValue@pageSegmentBean@"/>
              <oem:chartColumn displayLabelBinding="MIN_MAX_AVG_LINE@mntrBundle"
                                 sourceIndex="2"
                                 minColumnIndex="3"
                                 maxColumnIndex="4"
                                 renderedBinding="showMinMaxAvg@pageSegmentBean@"/>
            </uix:contents>
        </oem:chart>
  
      </uix:contents>
    </uix:stackLayout>
  
  </uix:contents>
</uix:stackLayout>

</uix:dataScope> 
</oem:pageSegment>
