<%-- 

/* $Header: sqlStatementParam.jsp 23-jun-2005.12:53:42 lgloyd Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Set sql select statement for use in rendering an element
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      lgloyd    06/23/05 - size sql window 
      lgloyd    06/16/05 - make sql box larger 
      lgloyd    03/04/05 - named sql, is pl/sql 
      lgloyd    02/18/05 - ui work 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    08/03/04 - num rows 
      lgloyd    07/14/04 - 
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    05/04/04 - 
      lgloyd    04/15/04 - 
 */

/**
 *  @version $Header: sqlStatementParam.jsp 23-jun-2005.12:53:42 lgloyd Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        sqlStatementParam.jsp
  -- Controller:  eml/ip/render/element/SQLStatementParamController.java
  -- Bean:        eml/ip/render/element/SQLStatementParamBean.java
  --
  -- Description: Set parameters for the chart element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.eml.ip.IPConstants'%>
<%@ page import='oracle.sysman.eml.ip.render.elem.SQLStatementParamController'%>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>
<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>

<uix:header textBinding="OPTIONS@ipBundle">

  <uix:spacer height="5"/>
  <uix:rowLayout>      
   <uix:styledText textBinding="TABLE_INSTRUCTIONS@ipBundle" />
  </uix:rowLayout>                   
  <uix:spacer height="5"/>

  <uix:tableLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
          <uix:styledText textBinding="SQL_STATEMENT_PARAM_PROMPT@ipBundle"
                      styleClass="OraPromptText"/>
                      
          <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:textInput name="<%=IPConstants.SQL_STATEMENT_PARAM %>"
                shortDescBinding="SQL_STATEMENT_PARAM_PROMPT@ipBundle"
                columns="120"
                rowsBinding="numEditRows@pageSegmentBean@"
                textBinding="resolvedSqlStatement@pageSegmentBean@"/>
      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
          <uix:styledText textBinding="SQL_STATEMENT_TYPE_PROMPT@ipBundle"
                      styleClass="OraPromptText"/>                      
          <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:radioSet
          shortDescBinding="SQL_STATEMENT_TYPE_PROMPT@ipBundle"
          selectedValueBinding="sqlStatementType@pageSegmentBean@"
          name="<%= SQLStatementParamController.SQL_STATEMENT_TYPE_CTL%>"
        >
          <uix:contents>
            <uix:option 
              value="<%=SQLStatementParamController.SQL_STATEMENT_TYPE_SQL%>"
              textBinding="SQL_STATEMENT_IS_SQL@ipBundle"/>
            <uix:option 
              value="<%=SQLStatementParamController.SQL_STATEMENT_TYPE_PLSQL%>"
              textBinding="SQL_STATEMENT_IS_PLSQL@ipBundle" />
          </uix:contents>
        </uix:radioSet>
      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:spacer height="5"/>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:cellFormat
          hAlign="right"
          vAlign="top">    
          <uix:styledText textBinding="NUM_ROWS_TO_SHOW@ipBundle"
                      styleClass="OraPromptText"/>
                      
          <uix:spacer width="5"/>
        </uix:cellFormat>
        <uix:textInput 
                name="oracle.sysman.eml.ip.render.elem.TableRender.numRowsToShow"
                shortDescBinding="NUM_ROWS_TO_SHOW@ipBundle"
                columns="3" 
                maximumLength="3" 
                textBinding="numRowsToShow@pageSegmentBean@"
                rendered="false"
                renderedBinding="showNumRowsOption@pageSegmentBean@"/> 

      </uix:contents>
    </uix:rowLayout>      

    <uix:rowLayout>      
      <uix:contents>
        <uix:spacer width="5"/>
        <uix:styledText textBinding="NUM_ROWS_TO_SHOW_HINT@ipBundle" styleClass="OraTipText"/>
      </uix:contents>
    </uix:rowLayout>      


  </uix:tableLayout>      
</uix:header>
</uix:dataScope>
      

</oem:pageSegment>
