<%-- 

/* $Header: sysdashRender.jsp 27-jul-2007.03:51:33 vmotamar Exp $ */
/* $Header: sysdashRender.jsp 27-jul-2007.03:51:33 vmotamar Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render the availability timeline element
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      vmotamar  07/25/07 - Bug No 6268769
      vmotamar  07/10/06 - Backport vmotamar_bug-5046489 from main 
      kannatar  05/10/07 - Security Bug 6026617
      vmotamar  02/22/06 - Fixing sorting issue in Reports (Alerts table)
      pratagar  09/04/05 - Bug 4584055 
      vmotamar  09/05/05 - Modify branding
      vmotamar  08/29/05 - Bug No 4581366 
      paachary  07/21/05 - Render the Alerts Table based on Show Alert Details checkbox in dashboard page segment.
      vmotamar  07/24/05 - Bug No : 4504106
      vmotamar  07/14/05 - Dashboard feedback
      vmotamar  06/22/05 - Modifications for Help Link
      vmotamar  05/24/05 - Ada, error message display
      vmotamar  04/19/05 - Bug No 4309057
      vmotamar  02/02/05 - Bug No 4071350 
      vmotamar  01/21/05 - 
      vmotamar  12/17/04 - vmotamar_fix_testsuite
      vmotamar  12/08/04 - 
      vmotamar  12/02/04 - Changes to customizations
      vmotamar  11/30/04 - vmotamar_serv_frmwrk
      vmotamar  11/25/04 - 
      
 */

/**
 *  @version $Header: sysdashRender.jsp 27-jul-2007.03:51:33 vmotamar Exp $
 *  @author  vmotamar
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%--
  -- Page:        sysdashRender.jsp
  -- Controller:  eml/ip/render/element/system/SysDashRenderController.java
  -- Bean:        eml/ip/render/element/system/SysDashRenderBean.java
  --
  -- Description: Render the dashboard element
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<%@ page import='oracle.sysman.eml.ip.render.elem.system.SysDashRenderBean'%>
<%@ page import='java.lang.Integer'%>
<%@ page import='java.lang.NumberFormatException'%>

<%      
  oracle.sysman.eml.ip.render.elem.system.SysDashRenderBean sdb1 = 
    ((oracle.sysman.eml.ip.render.elem.system.SysDashRenderBean)
  request.getAttribute("systemdashboardbean"));
  String areffreq = sdb1.getrefFreq();
  try
  {
    int freqency = Integer.parseInt(areffreq);
  }
  catch(NumberFormatException nfe)
  {
      areffreq = "60";
  }
%>

<oem:pageSegment>

  <uix:rawText>
    <meta http-equiv="Refresh" content="<%=areffreq%>"/>   
  </uix:rawText>

  <uix:dataScope>

    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="systemdashboardrb" class="oracle.sysman.eml.rsc.target.sys.SystemDashboardMsg"/>

    <uix:formValue name="sDashTargetTypes" valueBinding="dashTargetTypes@pageSegmentBean@"/>

      <%-- error to be reported to end user if applicable --%>
      <uix:stackLayout rendered="false"
                       renderedBinding="showError@pageSegmentBean@">
        <uix:contents>
          <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                          messageTypeBinding="messageType@pageSegmentBean@"
                          textBinding="errorMessageTitle@pageSegmentBean@"/>
        </uix:contents>
      </uix:stackLayout>

      <%-- No error to be reported to end user --%>
      <uix:stackLayout rendered="true" renderedBinding="showContent@pageSegmentBean@">
        <uix:contents>
          
          <%-- This rowLayout contains the Oracle branding, Help link etc --%>
          <uix:rowLayout  width="100%" >
            <uix:cellFormat hAlign="left" vAlign="bottom">
              <%--<uix:image source="/em/images/sysdash_Oracle.gif"/>
              <uix:spacer width="1"/>
              <uix:styledText textBinding="SYSTEM_DASHBOARD@systemdashboardrb" 
                              styleClass="OraEmDashboardPageHeader"/>--%>
              <uix:image source="/em/images/bannerOemLight.gif"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="HELP@commonResourceBundle" 
                              shortDescBinding="HELP@commonResourceBundle"
                              styleClass="OraGlobalLinks"
                              destinationBinding="helpLink@pageSegmentBean@"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- This tableLayout contains the GroupName, page refresh info etc --%>
          <uix:tableLayout width="100%" >
            
            <uix:rowLayout styleClass="OraEmDashboardGroupHeaderLine">
              <uix:cellFormat height="2">
                <uix:styledText text=" " />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout styleClassBinding="targetHeaderBackground@pageSegmentBean@">
              <uix:rowLayout width="100%">

                <uix:cellFormat width="50%" height="22" vAlign="middle" hAlign="left">
                  <uix:spacer width="10"/> 
                  <uix:styledText styleClassBinding="targetHeaderBackground@pageSegmentBean@" 
                                  textBinding="targetHeader@pageSegmentBean@" 
                                  destinationBinding="targetHomePage@pageSegmentBean@"/>
                  <uix:styledText styleClassBinding="targetHeaderBackground@pageSegmentBean@"
                                  textBinding="targetHeaderAddition@pageSegmentBean@"/>
                </uix:cellFormat>

                <uix:cellFormat hAlign="right"  width="50%" height="22" vAlign="middle">
                  <uix:styledText styleClass="OraEmDashboardPageRefresh"     
                                  textBinding="PAGE_REFRESHED_TIME@sdkUIBundle"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraEmDashboardTimeDate" 
                                  textBinding="timestamp@pageSegmentBean@"/>
                  <uix:spacer width="5"/>  
                  <uix:submitButton styleClass="OraInstructionText" 
                                    textBinding="REFRESH_BUTTON@mntrResourceBundle" 
                                    shortDescBinding="REFRESH_BUTTON@mntrResourceBundle"
                                    name="event" value="Refresh"/>  
                </uix:cellFormat>

              </uix:rowLayout>
            </uix:rowLayout>

            <uix:rowLayout styleClass="OraEmDashboardGroupHeaderNormalLine">
              <uix:cellFormat height="1">
                <uix:styledText text=" " />
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>
          </uix:tableLayout>

          <%-- element content --%>
          <uix:stackLayout rendered="true"
                           renderedBinding="showContent@pageSegmentBean@">
            <uix:contents>
              <uix:switcher childNameBinding="selectedView@pageSegmentBean@">
                <uix:case name="Rollup">  
                  <uix:stackLayout >
                    <uix:contents >
                      <uix:rowLayout width="100%">
                        <uix:include nodeBinding="rollupTable@pageSegmentBean@" />
                      </uix:rowLayout>   
                    </uix:contents>
                  </uix:stackLayout>
                </uix:case>

                <uix:case name="Full">  
                  <uix:stackLayout >
                    <uix:contents>
                      <uix:rowLayout width="100%">
                        <uix:include nodeBinding="targetTable@pageSegmentBean@" />
                      </uix:rowLayout> 
                    </uix:contents>
                  </uix:stackLayout>
                </uix:case> 

              </uix:switcher> 

              <uix:tableLayout width="100%" >
                <uix:rowLayout>
                  <uix:spacer height="6"/>
                </uix:rowLayout>
  
                <uix:rowLayout styleClass="OraEmDashboardGroupHeaderLine">
                  <uix:cellFormat height="2">
                    <uix:styledText text=" " />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout styleClass="OraEmDashboardAlertHeader" width="100%"
                               renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" height="22">
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraEmDashboardAlertHeader" 
                                      textBinding="ALERTS@sdkUIBundle"/>
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:image source="/em/images/sysdash_down.gif" 
                               shortDescBinding="DOWN@sdkUIBundle" 
                               destinationBinding="downDest@pageSegmentBean@"/>
                    <uix:spacer width="2"/>  
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                      shortDescBinding="DOWN@sdkUIBundle" 
                                      textBinding="down@pageSegmentBean@" 
                                      destinationBinding="downDest@pageSegmentBean@"/>
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:image source="/em/images/sysdash_critical.gif" 
                               shortDescBinding="CRITICAL@sdkUIBundle" 
                               destinationBinding="criticalDest@pageSegmentBean@"/>
                    <uix:spacer width="2"/>  
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                      shortDescBinding="CRITICAL@sdkUIBundle" 
                                      textBinding="critical@pageSegmentBean@" 
                                      destinationBinding="criticalDest@pageSegmentBean@"/>
                    </uix:cellFormat>
                    <uix:spacer width="8"/>
                    <uix:image source="/em/images/sysdash_warning.gif" 
                               shortDescBinding="WARNING@sdkUIBundle" 
                               destinationBinding="warningDest@pageSegmentBean@"/>
                    <uix:spacer width="2"/>  
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                      shortDescBinding="WARNING@sdkUIBundle" 
                                      textBinding="warning@pageSegmentBean@" 
                                      destinationBinding="warningDest@pageSegmentBean@"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:rowLayout>

                <uix:rowLayout renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
                  <uix:spacer height="2"/>
                </uix:rowLayout>

                <uix:rowLayout width="100%" renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
                  <uix:rowLayout hAlign="left">
                    <uix:spacer width="8"/>
                    <uix:image source="/em/cabo/images/info.gif" 
                               renderedBinding="showAlertInfo@systemdashboardbean@servletRequest"
                               shortDescBinding="INFORMATION@sdkUIBundle" />
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                                      renderedBinding="showAlertInfo@systemdashboardbean@servletRequest"
                                      shortDescBinding="rowsExceededMsg@systemdashboardbean@servletRequest" 
                                      textBinding="rowsExceededMsg@systemdashboardbean@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:rowLayout>

              </uix:tableLayout>

              <uix:tableLayout width="100%">
                <uix:rowLayout renderedBinding="showAlertsTable@systemdashboardbean@servletRequest">
                  <uix:table id="AlertTable" nameBinding="alertTableName@pageSegmentBean@"
                             alternateTextBinding="NO_ALERT_FOUND@mntrResourceBundle"
                             summaryBinding="ALERTS_TABLE_DESC@systemdashboardrb"
                             width="100%" blockSize="10" 
                             formSubmitted="true"
                             valueBinding="valueAlert@pageSegmentBean@" 
                             minValueBinding="minValue@pageSegmentBean@" 
                             maxValueBinding="maxAlertValue@pageSegmentBean@" 
                             tableDataBinding="tableDataKey@alertTableData@pageSegmentBean@"
                             columnFormatsBinding="alertColumnFormats@pageSegmentBean@"
                             columnHeaderDataBinding="columnHeaderDataAlert@pageSegmentBean@"
                             showAll="yes">
                    <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader styleClass="OraEmDashboardCompactTableColumnHeadertoo" 
                                          textBinding="text" sortableBinding="sortable" />
                    </uix:columnHeaderStamp>

                    <uix:contents>
                      <uix:image sourceBinding="severity@" 
                                 shortDescBinding="srtDesc@" hAlign="center"/>
                      <uix:link styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                textBinding="targetName@" destinationBinding="targetdestination1@"/>
                      <uix:link styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                                textBinding="date@" destinationBinding="datedestination@"/>
                      <uix:link styleClass="OraEmDashboardNonCompactTableCellStyle" 
                                textBinding="message@" destinationBinding="messagedestination@"/>
                      <uix:formattedText styleClass="OraEmDashboardNonCompactTableSpaceStyle" 
                                   textBinding="comment@"/>
                    </uix:contents>
                  </uix:table> 
                </uix:rowLayout>

                <uix:rowLayout hAlign="right">
                  <uix:link textBinding="LEGEND@sdkUIBundle" 
                            shortDescBinding="LEGEND@sdkUIBundle"
                            styleClass="OraEmDashboardNonCompactTableLink" 
                            onClickBinding="legendLink@pageSegmentBean@"/>
                </uix:rowLayout>

              </uix:tableLayout>

            </uix:contents>
          </uix:stackLayout>

        </uix:contents>

      </uix:stackLayout>
    </uix:dataScope>
</oem:pageSegment>
