<%-- 

/* $Header: tableRender.jsp 13-may-2005.13:29:47 lgloyd Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render a table
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      lgloyd    05/13/05 - disclaimer text 
      lgloyd    05/09/05 - uinode for label value display 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    12/17/04 - handle error cond 
      lgloyd    12/09/04 - fancy settings 
      lgloyd    11/12/04 - severity in nv pair 
      lgloyd    10/28/04 - 
      lgloyd    10/22/04 - severity
      lgloyd    10/20/04 - no data for name value 
      lgloyd    09/24/04 - name value display 
      lgloyd    09/03/04 - sorting
      lgloyd    08/25/04 - 
      lgloyd    07/30/04 - links
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    04/28/04 - 
 */

/**
 *  @version $Header: tableRender.jsp 13-may-2005.13:29:47 lgloyd Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        tableRender.jsp
  -- Controller:  eml/ip/render/element/TableRenderController.java
  -- Bean:        eml/ip/render/element/TableRenderBean.java
  --
  -- Description: Render the table element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.ip.render.elem.TableRenderBean' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>
<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg" />

<uix:stackLayout>
  <uix:contents>

    <%-- error to be reported to end user if applicable --%>
    <uix:stackLayout rendered="false"
                      renderedBinding="showError@pageSegmentBean@">
       <uix:contents>
         <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                         messageTypeBinding="messageType@pageSegmentBean@"
                         textBinding="errorMessageTitle@pageSegmentBean@"/>
       </uix:contents>
    </uix:stackLayout>
  
    <%-- element content --%>
    <uix:stackLayout rendered="true"
                      renderedBinding="showContent@pageSegmentBean@">
      <uix:contents>

        <uix:switcher childNameBinding="displayMode@pageSegmentBean@" defaultCase="<%=TableRenderBean.TABLE_CASE %>">

          <uix:case name="<%= TableRenderBean.TABLE_CASE %>" >
              <%
              PageSegmentContext psc_uinode = (PageSegmentContext)request.getAttribute("pageSegmentContext");
              TableRenderBean tb_uinode = (TableRenderBean)psc_uinode.getPageSegmentBean();
              %>
              <uix:ref refID="<%= tb_uinode.getRefID() %>" />
           </uix:case>

          <uix:case name="<%= TableRenderBean.NAMEVALUE_CASE %>" >
            <uix:rowLayout>
              <%
              PageSegmentContext psc_uinode = (PageSegmentContext)request.getAttribute("pageSegmentContext");
              TableRenderBean tb_uinode = (TableRenderBean)psc_uinode.getPageSegmentBean();
              %>
              <uix:ref refID="<%= tb_uinode.getRefID() %>" />
            </uix:rowLayout>
           </uix:case>

           <uix:case name="<%= TableRenderBean.NAMEVALUE_NODATA_CASE %>" >
            <uix:styledText textBinding="NO_DATA@ipBundle"/>
           </uix:case>

         </uix:switcher>

          <uix:spacer height="5" renderedBinding="renderAnnotation@pageSegmentBean@" />
          <uix:styledText textBinding="annotationMessage@pageSegmentBean@"
            renderedBinding="renderAnnotation@pageSegmentBean@"
            styleClassBinding="annotationStyle@pageSegmentBean@"/>
            
      </uix:contents>

    </uix:stackLayout> 
  </uix:contents>
</uix:stackLayout>

</uix:dataScope>
</oem:pageSegment>
  