<%-- 

/* $Header: targetsParam.jsp 05-jul-2005.10:30:56 tyhorton Exp $ */
/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Set targets for use in rendering an element
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      tyhorton  07/05/05 - report-wide target support 
      lgloyd    06/09/05 - ada
      lgloyd    02/17/05 - targets work 
      lgloyd    01/27/05 - type picker 
      lgloyd    01/21/05 - popup work 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    10/12/04 - 
      lgloyd    10/08/04 - 
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    05/04/04 - lgloyd_ip_040425
      lgloyd    04/15/04 - 
 */

/**
 *  @version $Header: targetsParam.jsp 05-jul-2005.10:30:56 tyhorton Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        targetsParam.jsp
  -- Controller:  eml/ip/render/element/TargetsParamController.java
  -- Bean:        eml/ip/render/element/TargetsParamBean.java
  --
  -- Description: Set parameters for the element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<oem:pageSegment>

<%@ page import='oracle.sysman.eml.ip.IPConstants'%>
<%@ page import='oracle.sysman.eml.ip.render.JITSelectionBean'%>

<uix:dataScope>
  <uix:bundle name="ipBundle"
              class="oracle.sysman.resources.eml.ip.IPMsg" />

  <uix:stackLayout>
      <uix:header textBinding="TARGETS@ipBundle">
        <uix:contents>

              <uix:messageRadioButton 
                selectedValueBinding="targetInheritanceSelection@pageSegmentBean@"
                name="<%=JITSelectionBean.TGTOPT_TARGETS_RADIO_CTL%>"
                value="<%=IPConstants.SET_TARGETS_OPTION_USE_INHERIT%>"
                tipBinding="SET_TARGET_INHERIT_TIP@ipBundle"
                textBinding="SET_TARGET_INHERIT_SELECTED_BY_VIEWER@ipBundle"/>
              <uix:messageRadioButton
                selectedValueBinding="targetInheritanceSelection@pageSegmentBean@"
                name="<%=JITSelectionBean.TGTOPT_TARGETS_RADIO_CTL%>"
                value="<%=IPConstants.SET_TARGETS_OPTION_USE_ALL_TARGETS%>"
                textBinding="SET_TARGET_USE_ALL_TARGETS@ipBundle"
                rendered="false"
                renderedBinding="showAllTargetsOption@pageSegmentBean@" />
              <uix:messageRadioButton
                selectedValueBinding="targetInheritanceSelection@pageSegmentBean@"
                name="<%=JITSelectionBean.TGTOPT_TARGETS_RADIO_CTL%>"
                value="<%=IPConstants.SET_TARGETS_OPTION_USE_ELEMENT_TARGETS%>"
                textBinding="elementSpecificTargetMessage@pageSegmentBean@"/>


        
          <uix:rowLayout width ="70%">
          <uix:contents>
          <uix:spacer width="10"/>
          <%@ include file="/ip/render/selectTargets.jsp" %>
          </uix:contents>
          </uix:rowLayout>
          <uix:spacer height="5" />
        
        </uix:contents>
      </uix:header>
  </uix:stackLayout>

</uix:dataScope>

</oem:pageSegment>
