<%-- 

/* $Header: textParam.jsp 06-jan-2005.07:34:01 lgloyd Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render some styled text
   NOTES
    &amp;amp;lt;other useful comments, qualifications, etc.&amp;amp;gt;

   MODIFIED    (MM/DD/YY)
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      tyhorton  01/03/05 - adding destination link 
      tyhorton  10/19/04 - adding spacer 
      tyhorton  10/14/04 - tyhorton_text_elem
      tyhorton  10/13/04 - adjusting layout 
      tyhorton  10/05/04 - Creation
 */

/**
 *  @version $Header: textParam.jsp 06-jan-2005.07:34:01 lgloyd Exp $
 *  @author  tyhorton
 *  @since   10.2
 */

--%>
<%--
  -- Page:        textParam.jsp
  -- Controller:  eml/ip/render/element/samples/TextParamController.java
  -- Bean:        eml/ip/render/element/samples/TextParamBean.java
  --
  -- Description: Set parameters for the text element
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ page import="oracle.sysman.eml.ip.render.elem.TextParamBean"%>
  <%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="ipBundle" class="oracle.sysman.resources.eml.ip.IPMsg"/>
    <uix:contents>
      <uix:stackLayout>
        <uix:contents>
          <uix:stackLayout 
            rendered="false" 
            renderedBinding="showError@pageSegmentBean@">
            <uix:contents>
              <uix:messageBox 
                messageBinding="errorMessage@pageSegmentBean@" 
                messageTypeBinding="messageType@pageSegmentBean@" 
                textBinding="errorMessageTitle@pageSegmentBean@"/>
            </uix:contents>
          </uix:stackLayout>
          <uix:labeledFieldLayout
            labelWidth="25%"
            fieldWidth="75%"
            width="80%">
            <uix:contents>
              <uix:messageTextInput 
                name="<%=TextParamBean.TEXT_MESSAGE%>" 
                promptBinding="MESSAGE_ENTER_PROMPT@ipBundle" 
                columns="60" 
                rows="1" 
                required="no" 
                textBinding="message@pageSegmentBean@"/>
              <uix:spacer
                height="5"/>
              <uix:messageTextInput 
                name="<%=TextParamBean.TEXT_DESTINATION%>" 
                promptBinding="DESTINATION_ENTER_PROMPT@ipBundle" 
                columns="60" 
                rows="1" 
                required="no" 
                textBinding="destination@pageSegmentBean@"/>
              <uix:spacer
                height="5"/>
              <uix:messageChoice 
                name="<%=TextParamBean.TEXT_STYLE%>" 
                promptBinding="STYLE_SELECT_PROMPT@ipBundle" 
                selectedValueBinding="style@pageSegmentBean@">
                <uix:contents
                  childDataBinding="styleChoices@pageSegmentBean@">
                  <uix:option 
                    textBinding="<%=TextParamBean.CHOICE_TEXT_KEY%>" 
                    valueBinding="<%=TextParamBean.CHOICE_VALUE_KEY%>"/>
                </uix:contents>
              </uix:messageChoice>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:dataScope>
</oem:pageSegment>
