<%-- 

/* $Header: textRender.jsp 03-may-2005.06:59:20 tyhorton Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render some styled text
   NOTES
    &lt;other useful comments, qualifications, etc.&gt;

   MODIFIED    (MM/DD/YY)
      tyhorton  05/03/05 - Updating link when printing 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      tyhorton  01/03/05 - adding destination link 
      tyhorton  10/14/04 - tyhorton_text_elem
      tyhorton  10/05/04 - Creation
 */

/**
 *  @version $Header: textRender.jsp 03-may-2005.06:59:20 tyhorton Exp $
 *  @author  tyhorton
 *  @since   10.2
 */

--%>
<%--
  -- Page:        textRender.jsp
  -- Controller:  eml/ip/render/elem/TextRenderController.java
  -- Bean:        eml/ip/render/elem/TextRenderBean.java
  --
  -- Description: Render the styled text element
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ page import="oracle.sysman.eml.ip.render.elem.TextRenderBean"%>
  <%@ page import="oracle.sysman.emSDK.page.seg.PageSegmentContext"%>
  <%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
  <uix:stackLayout>
    <uix:contents>
      <uix:stackLayout 
        rendered="false" 
        renderedBinding="showError@pageSegmentBean@">
        <uix:contents>
          <uix:messageBox 
            messageBinding="errorMessage@pageSegmentBean@" 
            messageTypeBinding="messageType@pageSegmentBean@" 
            textBinding="errorMessageTitle@pageSegmentBean@"/>
        </uix:contents>
      </uix:stackLayout>
      <uix:flowLayout 
        rendered="true" 
        renderedBinding="showContent@pageSegmentBean@">
        <uix:contents>
          <uix:styledText 
            textBinding="message@pageSegmentBean@"
            destinationBinding="displayDestination@pageSegmentBean@"
            styleClassBinding="style@pageSegmentBean@"/>
        </uix:contents>
      </uix:flowLayout>
    </uix:contents>
  </uix:stackLayout>
</oem:pageSegment>
