<%-- 

/* $Header: timePeriodParam.jsp 22-feb-2005.15:34:21 jabramso Exp $ */

/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Set time period
   NOTES
    &amp;amp;lt;other useful comments, qualifications, etc.&amp;amp;gt;

   MODIFIED    (MM/DD/YY)
      jabramso  02/22/05 - save time info 
      lgloyd    02/17/05 - inherit
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    12/02/04 - 
      lgloyd    11/28/04 - lgloyd_ip_041116
 */

/**
 *  @version $Header: timePeriodParam.jsp 22-feb-2005.15:34:21 jabramso Exp $
 *  @author  tyhorton
 *  @since   10.2
 */

--%>
<%--
  -- Page:        timePeriodParam.jsp
  -- Controller:  eml/ip/render/element/samples/TimePeriodParamController.java
  -- Bean:        eml/ip/render/element/samples/TimePeriodParamBean.java
  --
  -- Description: Set parameters for the text element
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<%@ page import='oracle.sysman.eml.ip.IPConstants'%>
<%@ page import='oracle.sysman.eml.ip.render.elem.TimePeriodParamController'%>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="ipBundle" class="oracle.sysman.resources.eml.ip.IPMsg"/>
    <uix:contents>
      <uix:stackLayout>
        <uix:contents>
          <uix:stackLayout 
            rendered="false" 
            renderedBinding="showError@pageSegmentBean@">
            <uix:contents>
              <uix:messageBox 
                messageBinding="errorMessage@pageSegmentBean@" 
                messageTypeBinding="messageType@pageSegmentBean@" 
                textBinding="errorMessageTitle@pageSegmentBean@"/>
            </uix:contents>
          </uix:stackLayout>

          <uix:header textBinding="TIME_PERIOD_LABEL@ipBundle">
            <uix:contents>
              <uix:radioSet
                selectedValueBinding="timePeriodInheritanceSelection@pageSegmentBean@"
                name="<%=TimePeriodParamController.TIME_PERIOD_INHERIT_RADIO_CTL%>"
                required="yes">
                <uix:contents>
                  <uix:option 
                    value="<%=IPConstants.TIME_PERIOD_OPTION_USE_INHERIT%>"
                    textBinding="REPORT_TIME_PERIOD_INHERIT@ipBundle"/>
                  <uix:option 
                    value="<%=IPConstants.TIME_PERIOD_USE_ELEMENT_SPECIFIC%>"
                    textBinding="REPORT_TIME_PERIOD_ELEMENT_SPECIFIC@ipBundle"/>
                </uix:contents>
              </uix:radioSet>
            <uix:spacer height="5"/>
            <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="20"/>
                <uix:styledText textBinding="TIME_PERIOD_LABEL@ipBundle"
                  styleClass="OraPromptText"/>
                <uix:spacer width="5"/>                
                <uix:styledText textBinding="timePeriodDisplayText@pageSegmentBean@" 
                  styleClass="OraDataText"/>
                <uix:spacer width="5"/>
                <uix:button 
                    name="setTimePeriod"
                    textBinding="SET_TIME_PERIOD@ipBundle" 
                    shortDescBinding="SET_TIME_PERIOD_DESC@ipBundle" 
                    destinationBinding="destinationURL@pageSegmentBean@"/>

"/>
              </uix:contents>
          </uix:rowLayout>
            </uix:contents>
            </uix:header>
          <uix:spacer height="5" />
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
    <uix:formValue name="timePeriod" />
    <uix:formValue name="selTimeZone" />
    <uix:script text="
		/*
		 * Javascript for opening popup page, setting time range
		 */

        function openChild(tableOp, timeText, timezone)
        {
          var srcUrl = '/em/ip/render/elem/emr/TPSelector/tpTimeRangePopup.jsp?selTimeValue=' + timeText + '&selTimeZone=' + timezone;
          
          openWindow(window, srcUrl, 'showTimeRange', {width:700,height:450},true,'dialog',myCallBack);   
        }
        function myCallBack()
        {
        } 

        function generateStrTimeRange(selTime, selTimeZone)
        {
            document.setParametersForm.timePeriod.value = selTime;
            document.setParametersForm.selTimeZone.value = selTimeZone;
            submitForm('setParametersForm',1,{'event':'doneSetTimePeriod'});
            return false;
        }
        
        " />
  </uix:dataScope>
</oem:pageSegment>
