<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <uix:script text="
      /*
       * Validates the user input and generates the number code 
       * for selected time range and submits the parent form
       */
      function submitLov(evt)
      {        
        document.forms[0].elements['event'].value = evt;        
        document.forms[0].submit();
        return true;
      }        

      function cancelLov(evt)
      {
        window.opener.document.forms[0].submit();
        return true;
      }
      
      function submitSelectedLov(evt)
      {        
        document.forms[0].elements['event'].value = evt;
        var radioGroup = document.forms[0].elements['lovEntryTable:selected'];
        var ind = 0;
        for(i=0;i<radioGroup.length;i++)
        {
          if(radioGroup[i].checked)
          {
            ind = i;            
            break;
          }
        }
        var selectValue = document.forms[0].elements['lovEntryTable:entry'+':'+ind].value;
        window.opener.document.forms[0].elements['lovSource'].value = selectValue;
        window.opener.document.forms[0].submit();
      }
    "/>
    <uix:dataScope currentDataBinding="entryData@servletRequest" >
    <uix:bundle name="webappsRB" class="oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource"/>
    <uix:bundle name="mntrRB" class="oracle.sysman.resources.MntrResourceBundle"/>
      <uix:header textBinding="title@">
        <uix:contents>        
          <uix:form name="singleSelectionLovForm" method="POST" destinationBinding="destination@">          
            <uix:stackLayout>
              <uix:contents>                            
                <uix:header text="">                            
                  <uix:contents>
                    <uix:tableLayout hAlign="left">
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:button textBinding="CANCEL@webappsRB" shortDescBinding="CANCEL@webappsRB" onClick="javascript:cancelLov('cancel');javascript:window.close();"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat>
                          <uix:button renderedBinding="textAlteringButtons@" textBinding="tableViewType@" shortDescBinding="tableViewType@" onClickBinding="onClickAction@"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat>
                          <uix:button textBinding="SELECT@webappsRB" shortDescBinding="SELECT@webappsRB" onClick="javascript:submitSelectedLov('lovSelect');javascript:window.close();"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>                                
                  </uix:contents>
                </uix:header>
                <uix:header textBinding="SEARCH@webappsRB">
                  <uix:contents>
                    <uix:tableLayout hAlign="left">
                      <uix:rowLayout hAlign="left">
                        <uix:cellFormat>
                          <uix:styledText textBinding="SEARCH@webappsRB"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat>
                        <%--enterClientAction="javascript:submitLov('lovFilter');" --%>
                          <uix:textInput name="searchText" textBinding="searchText@"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat>
                          <uix:button textBinding="GO_BUTTON@mntrRB" onClick="javascript:submitLov('lovFilter');" shortDescBinding="GO_BUTTON@mntrRB"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>              
                  </uix:contents>
                </uix:header>
                <uix:header textBinding="tableHeader@">
                  <uix:contents>	          
                    <%--<uix:listOfValues searchTextBinding="searchTxt@" title="Url" destinationBinding="destination@">--%>                                
                        <uix:table
                          alternateTextBinding="noDataFoundMsg@"
                          name="lovEntryTable"
                          partialRenderMode="self"
                          tableDataBinding="tableData@"
                          columnFormatsBinding="columnFormats@"
                          columnHeaderDataBinding="headers@"
                          width="100%"
                          blockSize="<%=oracle.sysman.eml.mntr.util.GenDataObjectList.DEFAULT_BLOCK_SIZE%>"
                          valueBinding="currValue@"
                          maxValueBinding="maxValue@"
                          minValueBinding="minvalue@"
                          formSubmitted="true"                  
                          destinationBinding="destination@">
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>
                          <uix:tableSelection>
                            <uix:singleSelection selectedIndex="0"/>
                          </uix:tableSelection>
                          <uix:contents>
                            <uix:styledText textBinding="textKey@"/>                        
                            <uix:formValue name="entry" valueBinding="valueKey@"/>
                          </uix:contents>
                        </uix:table>							                      
        <%--						</uix:listOfValues>--%>
                  </uix:contents>	                
              </uix:header>
              <uix:header text="">
                  <uix:contents>
                    <uix:tableLayout hAlign="left">
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:button textBinding="CANCEL@webappsRB" shortDescBinding="CANCEL@webappsRB" onClick="javascript:cancelLov('cancel');javascript:window.close();"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat>
                          <uix:button renderedBinding="textAlteringButtons@" textBinding="tableViewType@" shortDescBinding="tableViewType@" onClickBinding="onClickAction@"/>
                        </uix:cellFormat>
                        <uix:spacer width="5"/>
                        <uix:cellFormat>
                          <uix:button textBinding="SELECT@webappsRB" shortDescBinding="SELECT@webappsRB" onClick="javascript:submitSelectedLov('lovSelect');javascript:window.close();"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>                                
                  </uix:contents>
                </uix:header>              
              </uix:contents>
          </uix:stackLayout>           
      </uix:form>
    </uix:contents>
  </uix:header>    
  </uix:dataScope> 
  </uix:body>
  </uix:document>
</uix:renderingContext>
