<!-- 

/* $Header: eumRender.jsp 14-jul-2005.03:54:43 pmaddi Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render a table
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      pmaddi    07/14/05 - 
      pmaddi    07/07/05 - 
      pmaddi    07/03/05 - 
      pmaddi    03/22/05 - Removing dash board logo 
      pmaddi    02/28/05 - Adding contants for internationalization. 
      pmaddi    02/22/05 - Adding spacer between graph and table 
      ratadiko  02/04/05 - ratadiko_eum_webapps_reports
      lgloyd    11/12/04 - severity in nv pair 
      lgloyd    10/28/04 - 
      lgloyd    10/22/04 - severity
      lgloyd    10/20/04 - no data for name value 
      lgloyd    09/24/04 - name value display 
      lgloyd    09/03/04 - sorting
      lgloyd    08/25/04 - 
      lgloyd    07/30/04 - links
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    04/28/04 - 
 */

/**
 *  @version $Header: eumRender.jsp 14-jul-2005.03:54:43 pmaddi Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

-->
<%--
  -- Page:        tableRender.jsp
  -- Controller:  eml/ip/render/element/TableRenderController.java
  -- Bean:        eml/ip/render/element/EUMRenderBean.java
  --
  -- Description: Render the table element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.ip.render.elem.webapps.eum.EUMRenderBean' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import ='java.util.Date'%>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
<uix:renderingContext id="renderingContext">
	<oem:setURLEncoder id="renderingContext"/>
<uix:dataScope>
<uix:bundle name="webappsRB" class="oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource"/>
<uix:bundle name="webappsCRB" class="oracle.sysman.eml.webapp.WebappMsg"/>

<uix:stackLayout>
  <uix:contents>

    <%-- error to be reported to end user if applicable --%>
    <uix:stackLayout rendered="false" renderedBinding="showError@pageSegmentBean@">
       <uix:contents>
         <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                         messageTypeBinding="messageType@pageSegmentBean@"
                         textBinding="errorMessageTitle@pageSegmentBean@"/>
       </uix:contents>
    </uix:stackLayout>
  
    <%-- element content --%>
    <%
       PageSegmentContext psContext = (PageSegmentContext)request.getAttribute("pageSegmentContext");
       EUMRenderBean bean = (EUMRenderBean)psContext.getPageSegmentBean();
       if(bean.getShowContent().booleanValue()){
    %>
    <uix:stackLayout renderedBinding="showContent@pageSegmentBean@">
      <uix:contents>
          <%           
              PageSegmentContext psc = (PageSegmentContext)request.getAttribute("pageSegmentContext");
              EUMRenderBean eumBean = (EUMRenderBean) psc.getPageSegmentBean();              
           %>
         <uix:tableLayout  width="100%" hAlign="center">
            <uix:contents>

                <uix:rowLayout width="100%" >  
	   
                   <uix:cellFormat hAlign="center" 
                                   width="29%" 
                                   vAlign="center"  
                                   height="25" 
                                   styleClass="OraNonCompactTableColumnHeaderThin">  
                   </uix:cellFormat>    
	   
                   <uix:cellFormat hAlign="left" 
                                   vAlign="center" 
                                   width="3%" 
                                   height="25" 
                                   styleClass="OraNonCompactTableColumnHeaderThin">
                     <uix:spacer width="10"/>
                   </uix:cellFormat>
               </uix:rowLayout>

               <uix:rowLayout>
                   <uix:cellFormat columnSpan="3">
                      <%                                   
                          request.setAttribute("chartBean",eumBean.getTimeSeriesChartRenderBean());
                       %>
                      <uix:dataScope currentDataBinding="timeSeriesChartRenderBean@pageSegmentBean@">
                           <%-- chart content --%>
                              <%@ include file="../timeseriesChart.jspf" %> 
                      </uix:dataScope>
                   </uix:cellFormat>
               </uix:rowLayout>
               <uix:rowLayout>
                   <uix:cellFormat columnSpan="3">
					<uix:spacer width="5" height="20"/>
				   </uix:cellFormat>
               </uix:rowLayout>
               <uix:rowLayout width="100%" hAlign="left">
                 <uix:cellFormat width="100%" columnSpan="3">
                    <% 
                         request.setAttribute("genericTableFragBean",eumBean.getEUMTablebean());
                    %>
                   <uix:dataScope currentDataBinding="genericTableFragBean@servletRequest"><%--currentDataBinding="eUMTablebean@pageSegmentBean@"--%>
                     <%@ include file="../genericTableFrag.jspf" %>
                 </uix:dataScope>
                </uix:cellFormat>
              </uix:rowLayout>                        
            </uix:contents>
         </uix:tableLayout>
      </uix:contents>
    </uix:stackLayout>
<%}%>  
  </uix:contents>
</uix:stackLayout>

</uix:dataScope>
</uix:renderingContext>
</oem:pageSegment>
  
