<%-- 

/* $Header: genericTableRender.jsp 15-jul-2005.03:10:28 pmaddi Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render a table
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      pmaddi    07/15/05 - 
      lgloyd    01/06/05 - change comment style to fix flushed buffer response 
                           already committed issue 
      lgloyd    12/17/04 - handle error cond 
      lgloyd    12/09/04 - fancy settings 
      lgloyd    11/12/04 - severity in nv pair 
      lgloyd    10/28/04 - 
      lgloyd    10/22/04 - severity
      lgloyd    10/20/04 - no data for name value 
      lgloyd    09/24/04 - name value display 
      lgloyd    09/03/04 - sorting
      lgloyd    08/25/04 - 
      lgloyd    07/30/04 - links
      lgloyd    06/09/04 - pagesegment work 
      lgloyd    04/28/04 - 
 */

/**
 *  @version $Header: genericTableRender.jsp 15-jul-2005.03:10:28 pmaddi Exp $
 *  @author  lgloyd
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%--
  -- Page:        tableRender.jsp
  -- Controller:  eml/ip/render/element/TableRenderController.java
  -- Bean:        eml/ip/render/element/TableRenderBean.java
  --
  -- Description: Render the table element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.ip.render.elem.TableRenderBean' %>
<%@ page import='oracle.sysman.eml.ip.render.elem.webapps.GenericTableRenderBean' %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>
<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg" />

<uix:stackLayout>
  <uix:contents>
    <%-- error to be reported to end user if applicable --%>
    <uix:stackLayout rendered="false" renderedBinding="showError@pageSegmentBean@">
       <uix:contents>
         <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                         messageTypeBinding="messageType@pageSegmentBean@"
                         textBinding="errorMessageTitle@pageSegmentBean@"/>
       </uix:contents>
    </uix:stackLayout>
  <%
            PageSegmentContext psContext = (PageSegmentContext)request.getAttribute("pageSegmentContext");
            GenericTableRenderBean tableRenderBean = (GenericTableRenderBean)psContext.getPageSegmentBean();
            request.setAttribute("genericTableFragBean",tableRenderBean);//this bean will be used by the generic table fragment (genericTableFrag.jspf)
      if(tableRenderBean.getShowContent().booleanValue()){            
    %>
    <uix:dataScope currentDataBinding="pageSegmentBean@">
         <%-- element content --%>
  		 <%@ include file="genericTableFrag.jspf" %> 
    </uix:dataScope>
<%}%>  
  </uix:contents>
</uix:stackLayout>

</uix:dataScope>
</oem:pageSegment>
  
