<!-- 

/* $Header: timeseriesChart.jsp 08-jul-2005.06:31:34 pmaddi Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Render a chart
   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      pmaddi    07/08/05 - 
      pmaddi    01/02/05

 */

/**
 *  @version $Header: timeseriesChart.jsp 08-jul-2005.06:31:34 pmaddi Exp $
 *  @author  pmaddi
 *  @since   10gR2
 */

-->

<%--
  -- Page:        timeserieschart.jsp
  -- Controller:  eml/ip/render/elem/webapps/TimeSeriesChartRenderController.java
  -- Bean:        eml/ip/render/element/webapps/TimeSeriesChartRenderBean.java
  --
  -- Description: Render the chart element
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.sysman.eml.ip.render.elem.webapps.TimeSeriesChartRenderBean'%>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext'%>

 
<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>
 
<uix:stackLayout>
  <uix:contents>
 
      <%-- error to be reported to end user if applicable --%>
      <uix:stackLayout rendered="false"
                        renderedBinding="showError@pageSegmentBean@">
         <uix:contents>
           <uix:messageBox messageBinding="errorMessage@pageSegmentBean@"
                           messageTypeBinding="messageType@pageSegmentBean@"
                           textBinding="errorMessageTitle@pageSegmentBean@"/>
         </uix:contents>
      </uix:stackLayout>
      <%
        PageSegmentContext psContext = 
            (PageSegmentContext)request.getAttribute("pageSegmentContext");
        TimeSeriesChartRenderBean bean = (TimeSeriesChartRenderBean)psContext.getPageSegmentBean();
        request.setAttribute("chartBean",bean);
        if(bean.getShowContent().booleanValue()){            
      %>
    <uix:header renderedBinding ="displayHeader@servletRequest" textBinding="subtitle@pageSegmentBean@">	  
        <uix:dataScope currentDataBinding="pageSegmentBean@">
            <%-- element content --%>
            <%@ include file="timeseriesChart.jspf" %>
        </uix:dataScope>
	</uix:header>
  <%}%>
  </uix:contents>
</uix:stackLayout>
</oem:pageSegment>
