<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        justInTimeSelectTargets.jsp
  -- Controller:  eml/ip/render/IPRenderJITController.java
  --
  -- Description: The Set Targets page for Just In Time target selection
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrResourceBundle" 
            class="oracle.sysman.resources.MntrResourceBundle"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%@ include file="/oemNoscript.jspf" %> 

<%-- Imports --%>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@setTargetsUIBean@servletRequest"/>
</uix:metaContainer>

  <%@ include file="/oemTitle.jspf" %>
  <%@ include file="/enablePPR.jspf"%>

  <uix:body>

    <%-- HTML Form --%>
    <uix:form name="setParametersForm" 
                method="POST">
    <uix:formValue name="reportID" valueBinding="reportID@pageParams@servletRequest"/>     
    <uix:formValue name="actionToDo"  valueBinding="action@pageParams@servletRequest"/>
    <uix:formValue name="reportKEY" valueBinding="reportKEY@pageParams@servletRequest"/>
    <uix:formValue name="title"  valueBinding="title@pageParams@servletRequest"/>
    <uix:formValue name="owner"  valueBinding="owner@pageParams@servletRequest"/>
    <uix:formValue name="printablePage"  valueBinding="printablePage@pageParams@servletRequest"/>
    <uix:formValue name="versionID"  valueBinding="versionID@pageParams@servletRequest"/>
    <uix:formValue name="event" value="showreport"/>

      <uix:pageLayout titleBinding="pageHeader@pageSegmentBean@pageSegmentContext@servletRequest">
      <%@ include file="/oemGlobal.jspf" %>
         
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:rowLayout rendered="true"
                            renderedBinding="showContents@setTargetsCacheLoss@servletRequest">
              <uix:button textBinding="CANCEL@ipBundle" 
                          destinationBinding="cancelDestination@pageSegmentBean@pageSegmentContext@servletRequest"/> 
              <uix:spacer height="3"/>                  
              <uix:submitButton
                 textBinding="CONTINUE@ipBundle"
                 renderedBinding="showContent@pageSegmentBean@pageSegmentContext@servletRequest" 
                 name="event" 
                 value="showreport"/>
            </uix:rowLayout>                 
          </uix:pageButtonBar>
        </uix:pageButtons>
          

        <uix:messages>

          <%-- cache loss --%>
          <uix:stackLayout rendered="false"
                           renderedBinding="showCacheLoss@setTargetsCacheLoss@servletRequest">
             <uix:contents>
               <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrResourceBundle"
                               messageType="error"
                               textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrResourceBundle"/>
               <uix:spacer height="10"/>
               <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrResourceBundle"
                               destinationBinding="restartDest@setTargetsCacheLoss@servletRequest"/>
             </uix:contents>
          </uix:stackLayout>

      <uix:stackLayout rendered="false"
                       renderedBinding="showError@pageSegmentBean@pageSegmentContext@servletRequest">
         <uix:contents>
           <uix:messageBox messageBinding="errorMessage@pageSegmentBean@pageSegmentContext@servletRequest" 
                           messageTypeBinding="messageType@pageSegmentBean@pageSegmentContext@servletRequest" 
                           textBinding="errorMessageTitle@pageSegmentBean@pageSegmentContext@servletRequest"/>
         </uix:contents>
      </uix:stackLayout>


        </uix:messages>

        <uix:contents>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@setTargetsCacheLoss@servletRequest">
           <uix:contents>
           
            <uix:rowLayout renderedBinding="showContent@pageSegmentBean@pageSegmentContext@servletRequest" >
              <uix:contents>


                <uix:styledText textBinding="REPORT@ipBundle"
                   styleClass="OraPromptText" />
                <uix:spacer width="5" />
                <uix:styledText textBinding="reportTitle@pageSegmentBean@pageSegmentContext@servletRequest" 
                   styleClass="OraDataText" />
              </uix:contents>
            </uix:rowLayout>

            <uix:separator renderedBinding="showContent@pageSegmentBean@pageSegmentContext@servletRequest" />
            

            <uix:dataScope currentDataBinding="pageSegmentContext@servletRequest"> 
  
              <uix:rowLayout renderedBinding="showContent@pageSegmentBean@" >
               <uix:styledText styleClass="OraInstructionText"
                               textBinding="instructionText@pageSegmentBean@"/>
              </uix:rowLayout>  

             <uix:rowLayout renderedBinding="showContent@pageSegmentBean@pageSegmentContext@servletRequest" >
               <%@ include file="/ip/render/selectTargets.jsp" %>
             </uix:rowLayout>

            </uix:dataScope> 
              
           </uix:contents>
          </uix:stackLayout>
        </uix:contents>
      </uix:pageLayout>
    </uix:form>
  </uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
