<%@ include file="/sdk/oemTop.jspf"%>

<%--
  -- Page:        previewReport.jsp
  -- Controller:  eml/ip/render/IPRenderController.java
  --
  -- Description: The Preview Report page
  --%>
   
   
  <%-- Tag Libraries --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
   
  <%-- Imports --%>
  <%@ page import='oracle.sysman.eml.ip.render.PreviewRenderBean' %>


  <%
    // Currently, the only reason this is necessary is because the
    // "renderingContext" tag does not provide a configurationBinding
    // short-cut attribute.
    PreviewRenderBean renderBean = (PreviewRenderBean) request.getAttribute(PreviewRenderBean.RENDER_BEAN_NAME);            
  %>
                
  <uix:renderingContext 
    id="renderingContext"
    configuration="<%=renderBean.getRenderConfiguration()%>">

    <uix:bundle name="ipBundle" class="oracle.sysman.resources.eml.ip.IPMsg"/>
    <uix:bundle name="mntrBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>

    <%
         if (renderBean.getIsPrintable() == false)
         {  //  Include this file when not in printable page mode
    %>
          <%@ include file="/oemNoscript.jspf"%>
     <%
         }
     %> 
     
      <%-- HTML Page Title --%>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>

        <uix:switcher childNameBinding="usePageLayout@renderBean@servletRequest">
          <uix:case name="true">
            <%@ include file="/ip/render/reportPageLayout.jspf"%> 
          </uix:case>
          <uix:case name="false">
            <%@ include file="/ip/render/reportNoPageLayout.jspf"%> 
          </uix:case>
        </uix:switcher>

      </uix:body>
    </uix:document>
  </uix:renderingContext>
  <%-- END: Content --%>
