<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%><%--
  -- Page:        selectTargets.jsp
  -- Controller:  eml/ip/render/IPRenderJITController.java
  -- Bean:        emp/ip/render/JITSelectionBean
  --
  -- Description: Select targets portion of page.  This page is to be included
  --              in a page with select targets option.
  --
  --              This page supports single and multiple target selection.
  --%>

<%@ page import='oracle.sysman.eml.ip.render.JITSelectionBean'%>

<uix:switcher
  childNameBinding="targetSelectMode@pageSegmentBean@"
    defaultCase="SINGLE">

  <uix:case name="SINGLE">
    <uix:stackLayout>
     <uix:contents>
      <uix:spacer height="5"/>

      <uix:rowLayout>
        <uix:contents>
         <uix:messageChoice 
            renderedBinding="showTypeChoice@pageSegmentBean@"
            name="<%=JITSelectionBean.TARGET_TYPE_CHOICE_CTL %>"
            promptBinding="REPORTS_FILTER_TARGET_TYPE@ipBundle"
            tipBinding="SET_TARGET_TYPE_HINT@ipBundle"
            selectedValueBinding="selectedTargetType@pageSegmentBean@"
            disabled="false"
            disabledBinding="disabed@pageSegmentBean@">
          <uix:contents
               childDataBinding="selectedTargetTypeChoiceList@pageSegmentBean@">
             <uix:option textBinding="text" valueBinding="val"/>
          </uix:contents>
         </uix:messageChoice>    
         <uix:submitButton 
               renderedBinding="showTypeChoice@pageSegmentBean@"
               textBinding="GO@ipBundle"
               name="event"
               value="doSetTargetType"
               disabled="false"
               disabledBinding="disabled@pageSegmentBean@" />
         </uix:contents>
      </uix:rowLayout>
 
      <uix:messageLovField name="<%=JITSelectionBean.AVAIL_TARGETS_LOV_CTL%>"
                   promptBinding="lovTargetPrompt@pageSegmentBean@"
                   tipBinding="lovTip@pageSegmentBean@"
                   textBinding="selectedTargetName@pageSegmentBean@"
                   columns="40"
                   shortDescBinding="CLICK_TO_SELECT_TARGET@ipBundle" 
                   onClickBinding="onClickAction@pageSegmentBean@"
                   messageTypeBinding="targetMessageType@pageSegmentBean@"
                   messageBinding="targetMessage@pageSegmentBean@"
                   anchor="<%=JITSelectionBean.AVAIL_TARGETS_LOV_CTL%>" 
                   searchDescBinding="CLICK_TO_SELECT_TARGET@ipBundle"
                   disabled="false"
                   disabledBinding="disabled@pageSegmentBean@"/>

     </uix:contents>
    </uix:stackLayout>

  </uix:case>

  <uix:case name="MULTI">

    <uix:stackLayout>
      <uix:contents>

        <uix:spacer renderedBinding="showTypeChoice@pageSegmentBean@"
          height="5"/>
        <uix:rowLayout>
          <uix:contents>
            <uix:messageChoice 
                  renderedBinding="showTypeChoice@pageSegmentBean@"
                  name="<%=JITSelectionBean.TARGET_TYPE_CHOICE_CTL %>"
                  promptBinding="REPORTS_FILTER_TARGET_TYPE@ipBundle"
                  tipBinding="SET_TARGET_TYPE_HINT@ipBundle"
                  selectedValueBinding="selectedTargetType@pageSegmentBean@">
                     <uix:contents childDataBinding="selectedTargetTypeChoiceList@pageSegmentBean@">
                        <uix:option textBinding="text"
                                    valueBinding="val"/>
                     </uix:contents>
            </uix:messageChoice>    
            <uix:spacer width="5"/>
            <uix:submitButton 
                  renderedBinding="showTypeChoice@pageSegmentBean@"
                  textBinding="GO@ipBundle"
                  name="event"
                  value="doSetTargetType"/>
          </uix:contents>
        </uix:rowLayout>
        <uix:spacer renderedBinding="showTypeChoice@pageSegmentBean@"
            height="5"/>
        <uix:table name="<%=JITSelectionBean.AVAILABLE_TARGETS_TABLE_CTL %>" 
                  id="availableTargetsTable3"
                  partialRenderMode="self"
                  alternateTextBinding="NO_TARGETS_SELECTED@ipBundle"
                  width="100%"
                  blockSizeBinding="blockSize@pageSegmentBean@"
                  valueBinding="startValue@pageSegmentBean@"
                  minValueBinding="minValue@pageSegmentBean@"
                  maxValueBinding="maxValue@pageSegmentBean@"
                  formSubmitted="true"
                  tableDataBinding="displayTableData@pageSegmentBean@"
                  columnFormatsBinding="columnFormats@pageSegmentBean@"
                  columnHeaderDataBinding="columnHeaderData@pageSegmentBean@"
                  showAll="yes"
                  summaryBinding="SELECTED_TARGETS@ipBundle">
      
            <uix:tableActions>    
              <uix:button textBinding="ADD@ipBundle"
                          onClickBinding="onClickAction@pageSegmentBean@"/>
            </uix:tableActions>    

            <uix:tableFormat tableBanding="rowBanding"/>
      
            <uix:columnHeaderStamp>
              <uix:sortableHeader textBinding="text"
                                  sortable="false"/>
            </uix:columnHeaderStamp>
            
            <uix:contents>
              <uix:styledText textBinding="targetName"/> 
              <uix:styledText textBinding="displayName"/>
              <uix:styledText textBinding="hostName" 
                              renderedBinding="showHost@columnHeaderByCriteria@pageSegmentBean@"/>
              <uix:styledText textBinding="targetType"
                              renderedBinding="showParentType@columnHeaderByCriteria@pageSegmentBean@"/>
              <uix:styledText textBinding="timeZone"
                              renderedBinding="showTZ@columnHeaderByCriteria@pageSegmentBean@" />
              <uix:image
                sourceBinding="removeSrc"
                destination="#"
                onClickBinding="removeDest"
                width="24"
                height="24"
                renderedBinding="removeSingleSelect@pageSegmentBean@" 
                shortDescBinding="REMOVE@ipBundle"/>
          </uix:contents> 
        </uix:table>
      </uix:contents>
    </uix:stackLayout>
  </uix:case>
</uix:switcher>
