<%@ include file="/sdk/oemTop.jspf" %>
<%-- @ include file="/oemNoscript.jspf"  --%>
<%--
  -- Page:        setTargets.jsp
  -- Controller:  eml/ip/ui/edit/IPSetTargetsController.java
  --
  -- Description: The Set Targets page for Report Definition Edit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">

<uix:bundle name="ipBundle"
            class="oracle.sysman.resources.eml.ip.IPMsg"/>
<uix:bundle name="mntrResourceBundle" 
            class="oracle.sysman.resources.MntrResourceBundle"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>


<%-- Imports --%>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@setTargetsUIBean@servletRequest"/>
</uix:metaContainer>

  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <%-- HTML Form --%>
    <uix:form name="setTargetsForm" 
                method="POST"
                destinationBinding="formDestination@setTargetsUIBean@servletRequest">
      <uix:pageLayout titleBinding="SET_TARGETS@ipBundle">
      <%@ include file="/oemGlobal.jspf" %>
         
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:rowLayout rendered="true"
                            renderedBinding="showContents@setTargetsCacheLoss@servletRequest">
              <uix:submitButton textBinding="CANCEL@ipBundle" 
                                 name="event" 
                                 value="cancel"/>
              <uix:spacer height="3"/>                  
              <uix:submitButton textBinding="CONTINUE@ipBundle" 
                                 name="event" 
                                 value="save"/>
            </uix:rowLayout>                 
          </uix:pageButtonBar>
        </uix:pageButtons>
          
        <uix:contents>
          <%-- cache loss --%>
          <uix:stackLayout rendered="false"
                            renderedBinding="showCacheLoss@setTargetsCacheLoss@servletRequest">
             <uix:contents>
               <uix:messageBox messageBinding="CACHE_LOSS_ERROR_MSG@mntrResourceBundle"
                               messageType="error"
                               textBinding="CACHE_LOSS_ERROR_HEADER_MSG@mntrResourceBundle"/>
               <uix:spacer height="10"/>
               <uix:styledText textBinding="CACHE_LOSS_ERROR_CONTINUE_MSG@mntrResourceBundle"
                               destinationBinding="restartDest@setTargetsCacheLoss@servletRequest"/>
             </uix:contents>
          </uix:stackLayout>
  
          <uix:stackLayout rendered="true"
                            renderedBinding="showContents@setTargetsCacheLoss@servletRequest">
           <uix:contents>
             <uix:rowLayout > 
    
               <uix:styledText textBinding="SELECTED_ELEMENT@ipBundle"/>
               <uix:spacer width="5"/>
               <uix:styledText textBinding="elementName@setTargetsUIBean@servletRequest"/>
    
             </uix:rowLayout>
    
             <uix:separator />
  
             <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText"
                               textBinding="SET_TARGETS_INSTRUCTION@ipBundle"/>
             </uix:rowLayout>  
  
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:submitButton textBinding="ADD@ipBundle"
                                      name="event" value="doAddTargets"
                                      rendered="true"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
  
             <uix:table name="selectedTargetsTable" 
                        id="selectedTargetsTable"
                        partialRenderMode="self"
                        alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrResourceBundle"
                        width="90%"
                        blockSize="10"
                        valueBinding="value@setTargetsUIBean@servletRequest"
                        minValueBinding="minValue@setTargetsUIBean@servletRequest"
                        maxValueBinding="maxValue@setTargetsUIBean@servletRequest"
                        formSubmitted="true"
                        tableDataBinding="tableData@setTargetsUIBean@servletRequest"
                        columnFormatsBinding="columnFormats@setTargetsUIBean@servletRequest"
                        columnHeaderDataBinding="columnHeaderData@setTargetsUIBean@servletRequest">
  
                <%-- uix:tableSelection>
                  <uix:singleSelection text="Select@" 
                         rendered="true"> 
                  <uix:submitButton text="Remove@" 
                    name="event" 
                    value="doRemoveTargets"/> 
                  </uix:singleSelection>
                </uix:tableSelection --%>
                <uix:tableFormat tableBanding="rowBanding"/>
  
                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text"
                                      sortableBinding="sortable"/>
                </uix:columnHeaderStamp>
  
                <%-- uix:tableSelection>
                    <uix:multipleSelection selectionBinding="selection@setTargetsUIBean@servletRequest"
                                           shortDescBinding="TARGET_NAME"
                                           />
                </uix:tableSelection --%>
  
  
              <uix:contents>
                <uix:styledText textBinding="TARGET_NAME"/> 
                <uix:styledText textBinding="TARGET_TYPE"/>
                <uix:image 
                   source="/em/images/deleteicon_enabled.gif"
                   destinationBinding="removeTargetsDest"/>
              </uix:contents> 
            </uix:table>
  
             </uix:contents>
          </uix:stackLayout>
        </uix:contents>
      </uix:pageLayout>
    </uix:form>
  </uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
