<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       jobsTable.jsp
 *
 *      NOTES
 *       The main jobs page
 *
 * MODIFIED
 *    lgloyd     06/01/05 - add noscript 
 *    tyhorton   02/22/05 - proper message box placement 
 *    tyhorton   01/31/05 - refresh icon 
 *    jabramso   01/14/05 - Status report from edit 
 *    tzimmerm   12/09/04 - Add rpt create confirmation 
 *    tzimmerm   09/22/04 - 
 *    jmansur    07/17/04 - 
 *    lgloyd     03/25/04 - 
 *    tzimmerm   03/23/04 - 
 *    tzimmerm   03/01/04 - tzimmerm_report_ui 
 *    tzimmerm   02/26/04 - 
 *    rdabbott   12/17/03 - Fix 3320763: add jobs library related link 
 *    jmcclung   11/07/03 - define CommonResourceBundle used by included files 
 *    rdabbott   10/18/03 - move strings to jobs resource 
 *    jmcclung   10/12/03 - include enablePPR.jspf 
 *    rdabbott   10/10/03 - delete run button 
 *    rdabbott   10/01/03 - use confirmation icon for action messages 
 *    xshen      09/22/03 - include oemTop 
 *    xshen      06/28/03 - fixing show adv search
 *    rdabbott   01/22/03 - rdabbott_jobs_table_jsp
 *    rdabbott   01/14/03 - creation
 *
--%>
 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.eml.ip.IPUtils' %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
            
  <uix:bundle name="ReportsResource"
              class="oracle.sysman.resources.eml.ip.IPMsg"/>              
  <uix:bundle name="CommonResource"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="SDKUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" method="post">

      <uix:pageLayout titleBinding="header@reportDefinitionBean@servletRequest">  
        <%@ include file="/oemGlobal.jspf" %>

      <uix:pageStatus>
        <%@ include file="/ip/render/timestamp.jspf" %> 
      </uix:pageStatus>
        
<%--                                                                                              --%>
<%-- DEBUG: The following line will render debug text showing value of  "error" request attribute --%>
<%--        <uix:styledText text="<%= \"error=\" + request.getAttribute(\"error\") %>"/>          --%>
<%--                                    OR                                                        --%>
<%--        <uix:styledText textBinding="error@servletRequest"/>                                  --%>
<%--  ------------------------------------------------------------------------------------------  --%>

      <uix:messages>
        <uix:stackLayout>

        <%-- Error Display  (singleton message only)                        --%>
        <%-- -------------------------------------------------------------  --%>
        <uix:stackLayout rendered="false"
                         renderedBinding="renderSingletonError@servletRequest">
           <uix:contents>
           <uix:messageBox messageBinding="error@servletRequest"
                           messageType="error">          
           </uix:messageBox>
           </uix:contents>
        </uix:stackLayout>
        
        <%-- Warning Display  (singleton message only)                      --%>
        <%-- -------------------------------------------------------------  --%>
        <uix:stackLayout rendered="false"
                         renderedBinding="renderSingletonWarning@servletRequest">
          <uix:contents>
          <uix:messageBox messageBinding="warning@servletRequest"
                          messageType="warning">          
          </uix:messageBox>  
          </uix:contents>
        </uix:stackLayout>

        <%-- Confirmation Display (report successfully created/edit or
             exception
        --%>
        <%-- -------------------------------------------------------------  --%>
        <uix:stackLayout rendered="false"
                         renderedBinding="renderCreateConfirmation@servletRequest">
          <uix:contents>
          <uix:messageBox messageBinding="confirmation@servletRequest"
                          messageTypeBinding="messageType@servletRequest">
          </uix:messageBox>  
          </uix:contents>
        </uix:stackLayout>

        <%-- Confirmation Display (report successfully created with warnings
        --%>
        <uix:stackLayout rendered="false"
                         renderedBinding="renderWarnings@servletRequest">
          <uix:contents>  
          <uix:messageBox messageType="warning">
            <uix:contents  childDataBinding="warningList@servletRequest">
                <uix:styledText textBinding="message"/>
            </uix:contents>
          </uix:messageBox>
          </uix:contents>
        </uix:stackLayout>
 
        </uix:stackLayout>
      </uix:messages>

        <uix:stackLayout>                                  
           <uix:spacer height="3"/>
           <uix:include node="/ip/reportDefinitionList.jsp"/>          
        </uix:stackLayout>

    
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
