<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       addAccess.jsp
 *
 *      NOTES
 *       add access page
 *
 * MODIFIED
 *    rdabbott   07/09/05  - fix 4100219: no search conducted 
 *    ashugupt   06/10/05  - Fix ada voilations 
 *    pkantawa   11/03/04  - Change Ok button to Select 
 *    pkantawa   06/15/04  - creation
 *
--%>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="CommonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>  
  
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form name="addAccessPage" method="POST">
        <uix:pageLayout titleBinding="ADD_ADMIN_AND_ROLES@JobsResource">
          <%@ include file="/oemGlobal.jspf"%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@CommonResourceBundle" 
                                name="event" 
                                value="cancelAddAccess"/>
              <uix:submitButton textBinding="SELECT@CommonResourceBundle" 
                                name="event" 
                                value="OkAddAccess"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest" 
                          titleTextKey="titleText" 
                          mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest" 
                          titleTextKey="titleText" 
                          mainTextKey="mainText"/>
          <uix:subTabLayout>
            <uix:stackLayout>
              <uix:header textBinding="SEARCH@JobsResource">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="searchNameAddAccessPage" 
                                         promptBinding="NAME@JobsResource"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:textInput name="searchNameAddAccessPage" 
                                     id="searchNameAddAccessPage" 
                                     textBinding="searchName@addAccessTableData@servletRequest" 
                                     columns="25"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="searchTypeAddAccessPage" 
                                         promptBinding="TYPE@JobsResource"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:choice name="searchTypeAddAccessPage" 
                                  id="searchTypeAddAccessPage" 
                                  selectedValueBinding="searchType@addAccessTableData@servletRequest">
                        <uix:contents>
                          <uix:option textBinding="JOBS_ADMINISTRATORS_AND_ROLES@JobsResource" value="0"/>
                          <uix:option textBinding="ADMINISTRATOR@JobsResource" value="1"/>
                          <uix:option textBinding="ROLE@JobsResource" value="2"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt prompt=""/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:submitButton textBinding="JOBS_TABLE_GO_BUTTON@JobsResource" 
                                        name="event" 
                                        value="GoAddAccess"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
                       
              <%-- columns table --%>
              <uix:header textBinding="RESULTS@JobsResource">
                <uix:table name="addAccessTable" 
                           width="50%" 
                           tableDataBinding="row@addAccessTableData@servletRequest" 
                           formSubmitted="true" 
                           blockSizeBinding="blockSize@addAccessTableData@servletRequest"  
                           minValueBinding="minValue@addAccessTableData@servletRequest"
                           maxValueBinding="maxValue@addAccessTableData@servletRequest"
                           valueBinding="value@addAccessTableData@servletRequest"
                           alternateTextBinding="altText@addAccessTableData@servletRequest"
                           summaryBinding="SELECTED_ADMIN_AND_ROLES@JobsResource">
                  <uix:tableSelection>
                    <uix:multipleSelection shortDescBinding="nameColumn" 
                                           selectedBinding="selectedRow@"/>
                  </uix:tableSelection>
                  
                  <%-- Column Table:  Name --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="NAME@JobsResource"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="nameColumn@"/>
                  </uix:column>

                  <%-- Column Table: Type --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="TYPE@JobsResource"/>
                    </uix:columnHeader>
                    <uix:styledText textBinding="typeColumn@"/>
                  </uix:column>
                  
                </uix:table>
              </uix:header>
            </uix:stackLayout>
          </uix:subTabLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
