<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       addCA.jsp
 *
 *      NOTES
 *       Add Corrective Action page (reached from monitoring settings)
 *
 * MODIFIED
 *    jaysmith   07/06/05  - jaysmith_bug-4338588
 *    jaysmith   06/21/05  - creation
 *
--%>

<%--
<%@ include file="/sdk/oemTop.jspf"  %>
<%@ include file="/oemNoscript.jspf" %>
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
     <uix:metaContainer>
      <uix:head titleBinding="header@servletRequest"/>
     </uix:metaContainer> 
    <uix:body>
      <uix:form name="addCA" method="POST">
        <uix:pageLayout titleBinding="header@servletRequest">
          <%@ include file="/oemGlobal.jspf"%>  
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event" 
                                value="cancel"
                                textBinding="CANCEL@sdkUIMsg" />
              <uix:submitButton name="event" 
                                value="Continue"
                                textBinding="CONTINUE@sdkUIMsg" 
                                renderedBinding="notEmpty@tableDataSource@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:pageStatus>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="instructions@servletRequest" />
          </uix:pageStatus>

          <uix:contents>
            <uix:stackLayout>

              <uix:spacer height="25"/>

              <uix:messageChoice name="caChoice"
                                 selectedValueBinding="creatableJobSelected@servletRequest"
                                 shortDescBinding="WARNING@mntrResourceBundle">
                <uix:contents childDataBinding="optionList@servletRequest">
                  <uix:option textBinding="text"
                              valueBinding="value"/>
                </uix:contents>
              </uix:messageChoice>

            </uix:stackLayout>
          </uix:contents>          
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
