<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       agentSideResponseAction.jsp
 *
 *      NOTES
 *      A page to create agent side response action.
 *
 * MODIFIED
 *    ashugupt   06/10/05 - Fix ADA voilations 
 *    jvishen    02/08/05 - fix Partial page rendering 
 *    jaysmith   10/08/04 - fix command 
 *    jvishen    09/14/04 - jvishen_set_creds
 *    jvishen    08/15/04 - 
 *  
 *      jvishen    08/03/04  - creation
 *
--%>
<%@ include file="/sdk/oemTop.jspf"  %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
    <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"  %> 
    <%@ include file="/enablePPR.jspf"%>
     <uix:metaContainer>
      <uix:head titleBinding="header@responseActionBean@servletRequest"/>
     </uix:metaContainer> 
    <uix:body>
    <uix:form name="createResponse" method="POST">
      <uix:pageLayout titleBinding="header@responseActionBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
 
          <%-- Warning/Error display --%>
        <uix:messageBox messageType="error"
                        rendered="false"
                        renderedBinding="errorOccured@errors@servletRequest">
          <uix:contents childDataBinding="errorList@errors@servletRequest">
            <uix:link textBinding="label"
                      longDescBinding="message"
                      destinationBinding="destination" />
          </uix:contents>
        </uix:messageBox>
        <uix:spacer height="5"/>          
        <uix:tip textBinding="RESPONSE_ACTION_TIP@JobsResource"/>
        <uix:spacer height="20"/>

        <uix:labeledFieldLayout >
          <uix:messageTextInput name="command" 
                                columns="120"   
                                tipBinding="COMMAND_TIP@JobsResource"    
                                promptBinding="COMMAND_OR_SCRIPT@JobsResource" 
                                textBinding="command@responseActionBean@servletRequest" />  
        </uix:labeledFieldLayout>  

        <%-- hide show --%> 
        <uix:hideShow id="script"
                      destination="agentSideResponseAction" 
                      disclosedBinding="propListIsDisclosed@responseActionBean@servletRequest" 
                      formName="string" 
                      formSubmitted="false" 
                      partialRenderMode="self" 
                      unvalidated="false"
                      undisclosedTextBinding="SHOW_AVAILABLE_PROPERTIES@JobsResource"
                      disclosedTextBinding="HIDE_AVAILABLE_PROPERTIES@JobsResource">
          <uix:contents>
            <uix:tableLayout>
              <uix:table name="viewTable"
                         id="viewTable"
                         alternateTextBinding="NO_DATA_FOUND@JobsResource"
                         width="60%"
                         formSubmitted="true"
                         tableDataBinding="tableData@responseActionBean@servletRequest" 
                         summaryBinding="TARGET_TYPE_TABLE_HEADER@JobsResource">
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="TARGET_TYPE_TABLE_COLUMN_NAME@JobsResource"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconFormat"
                                    width="50%"
                                    cellNoWrapFormat="true"/>
                  <uix:contents>
                    <uix:styledText textBinding="name"/>
                  </uix:contents>
                </uix:column>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="TARGET_TYPE_TABLE_COLUMN_DESCRIPTION@JobsResource"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconFormat"
                                    width="50%"/>
                  <uix:contents>
                    <uix:styledText textBinding="description"/>
                  </uix:contents>
                </uix:column>
              </uix:table>
            </uix:tableLayout>
          </uix:contents>
        </uix:hideShow> 
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CREATE_JOB_CANCEL_BUTTON@JobsResource"
                              name="event"
                              value="ct_cancel"/>
            <uix:submitButton textBinding="CONTINUE@sdkUIBundle"
                              name="event"
                              value="ct_associate_metric"/>
          </uix:pageButtonBar>
        </uix:pageButtons>
          <uix:formValue  name="msCacheName"  valueBinding="msCacheName@servletRequest"/>  
          <uix:formValue  name="displacedCA"  valueBinding="displacedCA@servletRequest"/>  
      </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
