<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       caCreate.jsp
 *
 *      NOTES
 *       Create/Edit sheet for corrective actions
 *
 * MODIFIED
 *    ashugupt   06/10/05  - fix ada voilations 
 *    jaysmith   04/08/05  - for CA lib, include adminSideNav 
 *    jaysmith   10/22/04  - pageButtonsInclude --> caPageButtonsInclude 
 *    jaysmith   10/15/04  - move page buttons to shared (single-/multitask) 
 *                           file 
 *    jaysmith   09/30/04  - add continue button for Monitoring Settings 
 *    jvishen    09/28/04 - 
 *    jvishen    09/27/04 - 
 *    jvishen    09/24/04  - 
 *    jaysmith   09/22/04  - jaysmith_ca_create_ui_2
 *    jaysmith   09/21/04  - cut over error block 
 *    jaysmith   09/15/04  - CA-specific sheet events 
 *    jaysmith   09/03/04  - more form-name 
 *    jaysmith   09/03/04  - change form name 
 *    jaysmith   08/23/04  - add page buttons 
 *    jaysmith   08/05/04  - creation (adapted from Pranav's Job sheet)
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="createJob" method="POST">
        <uix:pageLayout titleBinding="header@mainJobViewBean@servletRequest">
          <%@ include file="/jobs/main/messagesInclude.jspf" %>
          <%@ include file="/oemGlobal.jspf" %>

          <%-- The CA Library now lives under Setup, not the Jobs tab.
               To get its navigator path right, we need this includes --%>
          <%
          if (request.getParameter("ctxType").equals("userCA"))
          {
          %>
            <%@ include file="/health/header.jsp"%>
          <%
          }
          %>

          <%@ include file="caPageButtonsInclude.jspf" %>
          <uix:spacer height="5"/>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndexBinding="selectedIndex@mainJobViewBean@servletRequest">
                <uix:link textBinding="CREATE_JOB_DEFINITION_LINK@JobsResource"
                          onClick="submitForm('createJob',1,{event:'onGeneralSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_PARAMETERS_LINK@JobsResource"
                          onClick="submitForm('createJob',1,{event:'onParametersSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_CREDENTIALS_LINK@JobsResource"
                          onClick="submitForm('createJob',1,{event:'onCredentialsSubtab'}, false); return false;"/>
              </uix:subTabBar>
            </uix:subTabs>
            <uix:spacer height="20"/>

            <uix:stackLayout>
              <uix:ref refID="INCLUDING_PAGE_NODE" />
            </uix:stackLayout>
     
          </uix:subTabLayout>
  
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
