<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *        selectList.jsp
 *
 *      NOTES
 *        A page to select CAs from the Monitoring Settings edit pages
 *
 * MODIFIED
 *    jvishen     08/08/05  - Add owner/job type column in the table 
 *    ashugupt    06/10/05  - Fix ADA voilations 
 *    jaysmith    04/08/05  - table button to page button 
 *    jaysmith    04/08/05  - fix header, instructions 
 *    jaysmith    10/27/04  - support multi-task in CA From Library select 
 *                            list 
 *    jaysmith    10/14/04  - jaysmith_reuse_lov
 *    jaysmith    10/03/04  - creation
 *
--%>
<%@ include file="/sdk/oemTop.jspf"  %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"  %> 
    <uix:body>
      <uix:form name="selectList" method="POST">
        <uix:pageLayout titleBinding="header@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event" 
                                value="cancel"
                                textBinding="CANCEL@sdkUIBundle" />
              <uix:submitButton name="event" 
                                value="continue"
                                textBinding="CONTINUE@sdkUIBundle" 
                                renderedBinding="notEmpty@tableDataSource@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:pageStatus>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="instructions@servletRequest" />
          </uix:pageStatus>
          <uix:spacer height="25"/>
          <uix:tableLayout>
            <uix:table showAll="yes"
                       id="jobsTable"
                       nameBinding="name@tableDataSource@servletRequest"
                       alternateTextBinding="alternateText@servletRequest"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="tableData@tableDataSource@servletRequest"
                       columnHeaderDataBinding="columnHeaders@servletRequest"
                       minValue="1"
                       valueBinding="value@tableDataSource@servletRequest"
                       maxValueBinding="maxValue@tableDataSource@servletRequest"
                       blockSizeBinding="blockSize@tableDataSource@servletRequest"
                       summaryBinding="CA_TABLE@JobsResource">

              <uix:tableFormat tableBanding="rowBanding"/>

              <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text"
                                    valueBinding="value"
                                    sortableBinding="sort"/>
              </uix:columnHeaderStamp>

              <uix:tableSelection>
                <uix:singleSelection shortDescBinding="SELECT@commonResourceBundle"
                                     selectedIndexBinding = "selectedRow@servletRequest">
                </uix:singleSelection>
              </uix:tableSelection>

              <uix:contents>
                <uix:styledText textBinding="jobName"/>
                <uix:styledText textBinding="jobNLSType"/>
                <uix:styledText textBinding="jobOwner"/>
                <uix:formValue  name="jobId"         valueBinding="jobId"/>
                <uix:formValue  name="jobName"       valueBinding="jobName"/>
                <uix:formValue  name="jobType"       valueBinding="jobType"/>
                <uix:formValue  name="multitask"     valueBinding="multitask"/>
              </uix:contents>
            </uix:table>
          </uix:tableLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
