<%--
 * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       fixCA.jsp
 *
 *      NOTES
 *      This page displayes the broken Corrective actions
 *
 * MODIFIED
 *    hmodawel   02/27/06 - fix ojsp 1013 compilation errors 
 *    jvishen    07/01/05 - change preferred credentials link text 
 *    jvishen    04/22/05 - Add table Navigation and sorting
 *    jvishen    04/12/05 - update for multitask broken CA 
 *    jvishen    03/15/05 - add CA filters 
 *    jvishen    12/25/04 - fix target hidden field 
 *    jaysmith   11/18/04 - reason column 
 *    jvishen    10/29/04 - Fix Broken Credentials Table changed 
 *    jvishen    10/05/04 - jvishen_credentials
 *    jvishen    09/28/04 - 
 *    jvishen    08/15/04 - 
 *    jvishen    08/03/04  - creation
 *
--%>
<%@ include file="/sdk/oemTop.jspf"  %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

  <uix:renderingContext id = "renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
    <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>
    <uix:bundle name="policyBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>    
   <uix:document>
    <%@ include file="/oemTitle.jspf"  %> 
                            
     <uix:metaContainer>
      <uix:head titleBinding="header@fixCAData@servletRequest"/>
     </uix:metaContainer> 
     <uix:body>
      <uix:form name="createResponse" method="POST">
       <uix:pageLayout titleBinding="header@fixCAData@servletRequest">
         <uix:pageStatus>
        <uix:styledText styleClass="OraInstructionText" 
                   textBinding="FIX_CRED_INSTR@JobsResource" />
         </uix:pageStatus>
         <uix:spacer height="10"/>
         <uix:styledText styleClass="OraInstructionText" 
                   textBinding="FIX_CRED_INSTR2@JobsResource" />
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="/enablePPR.jspf"%>
          <%-- Warning/Error display --%>
          <uix:messageBox messageType="confirmation"
                          rendered="false"
                          messageBinding="confirmation@message@servletRequest"
                          renderedBinding="confirmation@message@servletRequest">
<%--           <uix:contents childDataBinding="errorList@errors@servletRequest">
             <uix:link textBinding="label"
                       longDescBinding="message"
                       destinationBinding="destination" />
           </uix:contents>
--%>       
          </uix:messageBox>
          <uix:spacer height="25"/>
        <%--  Target Type  --%>
        <%--  -----------  --%>
        <uix:tableLayout width="100%">
        <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="left" 
                    vAlign="middle"
                    renderedBinding="showDefSearch@servletRequest"
                    wrappingDisabled="true">
          <uix:rowLayout>
            <uix:messageChoice name="filterTgtType"
                    promptBinding="JOBS_TABLE_FILTER_TARGET_TYPE@JobsResource"
                    selectedValueBinding="filterTgtType@servletRequest">
               <uix:contents childDataBinding="targetTypeList@servletRequest">
                   <uix:option textBinding="text" valueBinding="value"/>
               </uix:contents>
            </uix:messageChoice>
            <uix:spacer width="10" />
            <%--  Target Name    --%>
            <uix:messageTextInput name="filterTgtName" 
                              columns="30"
                              promptBinding="JOBS_TABLE_FILTER_TARGET_NAME@JobsResource"
                              textBinding="filterTgtName@servletRequest" />
            <uix:spacer width="10" />
            <%--  applies to  --%>
             <uix:messageChoice name="filterPolicyType"
                                promptBinding="BROKEN_CA_APPLIES_TO@JobsResource"
                                selectedValueBinding="filterPolicyType@servletRequest">
               <uix:contents childDataBinding="policyTypeList@servletRequest">
                 <uix:option textBinding="text"
                           valueBinding="value"/>
               </uix:contents>
              </uix:messageChoice>
              <uix:submitButton name="event" 
                        value="doBrokenCAFilter" 
                        textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"/>
            </uix:rowLayout>
           </uix:cellFormat>
           </uix:rowLayout>
           </uix:tableLayout>
           <uix:spacer height="25"/>
  
          <uix:tableLayout width ="100%"> 
          <uix:rowLayout>
           <uix:table showAll="yes"
                           partialRenderMode="self"
                           nameBinding="name@tableDataSource@servletRequest"
                           id="brokenCATable"
                           alternateTextBinding="NO_DATA_FOUND@JobsResource"
                           formSubmitted="true"
                           width="100%"
                           tableDataBinding="tableData@tableDataSource@servletRequest" 
                           columnHeaderDataBinding="columnHeaders@servletRequest"                           
                           minValue="1"
                           valueBinding="value@tableDataSource@servletRequest"
                           maxValueBinding="maxValue@tableDataSource@servletRequest"
                           blockSizeBinding="blockSize@tableDataSource@servletRequest">
             <uix:tableFormat tableBanding="rowBanding"/>
             <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text"
                                    valueBinding="value"
                                    sortableBinding="sort"/>
             </uix:columnHeaderStamp>
             
             <uix:tableSelection>
                <uix:singleSelection shortDescBinding="SELECT@CommonResource"
                                     selectedIndex = "0">
    
                <uix:submitButton name="event" 
                                  value="edit"
                                  textBinding="EDIT@commonResourceBundle"/>                                     
                </uix:singleSelection>
             </uix:tableSelection>
             <uix:contents>
               <uix:styledText textBinding="ca"  />
               <uix:styledText textBinding="target" />
               <uix:styledText textBinding="displayTargetType"  />
               <uix:styledText textBinding="metricColumnLabel"
                               renderedBinding="showMetricColumnLabel@fixCAData@servletRequest"/>
               <uix:styledText textBinding="policyLabel"
                               renderedBinding="showPolicyLabel@fixCAData@servletRequest"/>             
               <uix:styledText textBinding="severity" />
               <uix:styledText textBinding="currentOwner" />
               <uix:styledText textBinding="keyValue" />
               <uix:styledText textBinding="reason" />
             </uix:contents>
     
             <uix:contents>
               <uix:formValue  name="target"  valueBinding="target"/>
               <uix:formValue  name="type"  valueBinding="type"/>
               <uix:formValue  name="severity"  valueBinding="severity"/>
               <uix:formValue  name="ca"  valueBinding="ca"/>
               <uix:formValue  name="jobType"  valueBinding="jobType"/>
               <uix:formValue  name="currentOwner"  valueBinding="currentOwner"/>
               <uix:formValue  name="jobId"  valueBinding="jobId"/>
               <uix:formValue  name="keyValue"  valueBinding="keyValue"/>
               <uix:formValue  name="reason"  valueBinding="reason"/>
             </uix:contents>
          </uix:table>
          </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer width="20"/>
          <uix:header textBinding="RELATED_LINKS@JobsResource">          
             <uix:rowLayout hAlign="left">
                 <uix:link  textBinding="PREFERRED_CREDENTIALS@JobsResource"
                        destinationBinding="prefCredLink@fixCAData@servletRequest"/>        
             </uix:rowLayout>
          </uix:header>
          <uix:formValue  name="groupName"  valueBinding="groupName@servletRequest"/>
        </uix:pageLayout>
       </uix:form>
      </uix:body>
    </uix:document>
  </uix:renderingContext>
