<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       mtCACreate.jsp
 *
 *      NOTES
 *       Create Multi Task Corrective Action UI Property Sheet
 *
 * MODIFIED
 *    ashugupt   06/10/05 - fix ada voilations 
 *    jaysmith   04/08/05 - for CA lib, include adminSideNav 
 *    jaysmith   10/22/04 - jaysmith_multitask_ca_support
 *    jaysmith   10/22/04 - pageButtonsInclude --> caPageButtonsInclude 
 *    jaysmith   10/13/04 - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
      <uix:form name="mtCreateJob" method="POST">
        <uix:pageLayout titleBinding="header@mainJobViewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>

          <%-- The CA Library now lives under Setup, not the Jobs tab.
               To get its navigator path right, we need this include --%>
          <%
          if (request.getParameter("ctxType").equals("userCA"))
          {
          %>
            <%@ include file="/health/header.jsp"%>
          <%
          }
          %>

          <%@ include file="/jobs/main/messagesInclude.jspf" %>

          <%@ include file="caPageButtonsInclude.jspf" %>

          <uix:spacer height="5"/>
                                  
          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndexBinding="selectedIndex@mainJobViewBean@servletRequest">
                <uix:link textBinding="CREATE_JOB_DEFINITION_LINK@JobsResource"
                          onClick="submitForm('mtCreateJob',1,{event:'onGeneralSubtab'}, false); return false;"/>
                <uix:link textBinding="CREATE_JOB_TASKS_LINK@JobsResource" 
                          onClick="submitForm('mtCreateJob',1,{event:'onTasksSubtab'}, false); return false;"/>
              </uix:subTabBar>
            </uix:subTabs>
            <uix:spacer height="10"/>

            <uix:stackLayout>
              <uix:ref refID="INCLUDING_PAGE_NODE" />
            </uix:stackLayout>
     
          </uix:subTabLayout>
  
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

