<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       confirmationPage.jsp
 *
 *      NOTES
 *       job confirm page 
 *
 * MODIFIED
 *    ashugupt   06/10/05  - Fix ADA voilations 
 *    rdabbott   05/24/05  - fix 4316792: add option heading text 
 *    ashugupt   02/23/05  - default selection for radio buttons 
 *    ashugupt   01/04/05  - ashugupt_conf_pages
 *    ashugupt   11/22/04  - creation
 *
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource" class="oracle.sysman.resources.eml.jobs.JobsResource"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:form name="confirmationPage" method="POST">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>    
          <uix:header messageType="confirmation" textBinding="ALERT_TITLE@confPageData@servletRequest">
            <uix:subTabLayout>
              <uix:stackLayout>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="ALERT_MESSAGE@confPageData@servletRequest" />
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" 
                                      textBinding="ALERT_MESSAGE2@confPageData@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>                  
                </uix:tableLayout>
                
                <uix:tableLayout cellSpacing="5" 
                                 renderedBinding="SHOW_OPTION_AREA@confPageData@servletRequest">
                  <uix:spacer height="5"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" 
                                      textBinding="OPTION_HEADING@confPageData@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:radioButton textBinding="OPTION1_TEXT@confPageData@servletRequest" 
                                       valueBinding="OPTION1_EVENT@confPageData@servletRequest" 
                                       name="optionEvent"
                                       selected="true"/>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:radioButton textBinding="OPTION2_TEXT@confPageData@servletRequest" 
                                       valueBinding="OPTION2_EVENT@confPageData@servletRequest" 
                                       name="optionEvent"/>                      
                    </uix:contents>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:stackLayout>
            </uix:subTabLayout>
          </uix:header>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="ALERT_NO_BUTTON_TEXT@confPageData@servletRequest" 
                                name="event"
                                value="cancel"/>
              <uix:submitButton textBinding="ALERT_YES_BUTTON_TEXT@confPageData@servletRequest" 
                                name="event"
                                value="ok"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
        <uix:formValue name="noDest" 
                       valueBinding="ALERT_NO_BUTTON_DEST@confPageData@servletRequest"/>
        <uix:formValue name="yesDest" 
                       valueBinding="ALERT_YES_BUTTON_DEST@confPageData@servletRequest"/>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
