<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       jobsList.jsp
 *
 *      NOTES
 *       the list of jobs
 *
 * MODIFIED
 *    hmodawel   02/27/06 - fix ojsp 1013 compilation errors 
 *    rdabbott   07/15/05 - fix 3319429: rm SHOW_ONLY_ACCESS_TIP 
 *    rkhazanc   10/22/03 - rdabbott_jobs_table_jsp
 *    rkhazanc   05/20/03 - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<%-- DEBUG: The following line will render debug text showing value of  "showAdvSearch" request attribute --%>
<%--        <uix:styledText text="<%= \"showAdvSearch=\" + request.getAttribute(\"showAdvSearch\") %>"/>   --%>
<%--        <uix:styledText text="<%= \"showDefSearch=\" + request.getAttribute(\"showDefSearch\") %>"/>   --%>         



<%--  Advanced Search Mode:                                                 --%>
<%--  --------------------                                                  --%>
<%--  If rendering in Advanced search mode show the Simple Search button    --%>
<%--  (if showAdvSearch=true)                                               --%>

            
    <%--  Simple Search button   --%>
    <%--  --------------------   --%>    
<%  request.setAttribute("showAdvSearch", Boolean.TRUE); %>
<%  request.setAttribute("showDefSearch", Boolean.FALSE); %>

    <uix:tableLayout width="100%">
      <uix:contents>
        <uix:rowLayout rendered="false">            
            <uix:cellFormat hAlign="right" renderedBinding="showAdvSearch@servletRequest">
            <uix:submitButton name="event" 
                              value="showSimpleSearch" 
                              renderedBinding="showAdvSearch@servletRequest" 
                              textBinding="JOBS_TABLE_SIMPLE_SEARCH_BUTTON@JobsResource"/>
            </uix:cellFormat>           
          </uix:rowLayout>
       </uix:contents>
     </uix:tableLayout>  

    
            
   <%--  If rendering in Advanced search jobs table is under Results header --%>
  <uix:header textBinding="JOBS_ADV_SEARCH_HEADER@JobsResource"
              renderedBinding="showAdvSearch@servletRequest">
            
    <uix:tableLayout width="70%" cellSpacing="2">
     <uix:rowLayout>
     
     <uix:cellFormat width="40%" hAlign="left" vAlign="top">
      <uix:tableLayout>

          <%--  Job Name    --%>
          <%--  ----------  --%>          
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_NAME@JobsResource" styleClass="OraInstructionText"/>
            </uix:cellFormat>
            <uix:spacer width="5"/>
            <uix:cellFormat hAlign="left">
              <uix:textInput name="filterName" 
                             columns="10"
                             textBinding="filterName@servletRequest" />
            </uix:cellFormat>                    
          </uix:rowLayout>

     <%--  Run Status  --%>
     <%--  ----------  --%>
     <%--  Not Shown for Library  --%>
            
     <uix:rowLayout renderedBinding="showStatusFilter@servletRequest">   
       <uix:cellFormat hAlign="right">
         <uix:styledText textBinding="JOBS_TABLE_FILTER_STATUS@JobsResource" styleClass="OraInstructionText"/>                           
       </uix:cellFormat>
       
       <uix:spacer width="5"/>         
       <uix:cellFormat hAlign="left">
        <uix:messageChoice name="filterStatus"
             prompt="" selectedValueBinding="filterStatus@servletRequest">
             <uix:contents childDataBinding="statusList@servletRequest">
             <uix:option textBinding="text"
                            valueBinding="value"/>
        </uix:contents>                               
        </uix:messageChoice>                                
       </uix:cellFormat>                           
     </uix:rowLayout>

<%--  Active During (last 24hrs, last 7 days, last 31 days  --%>
          <%--  and Simple-Search button to the right                 --%>
          <%--  ----------------------------------------------------  --%>
          <%--  Not Shown for Library                                 --%>
          <uix:rowLayout renderedBinding="showTimeFrameFilter@servletRequest"  
                         vAlign="top">   
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_TIMEFRAME@JobsResource"
                              styleClass="OraInstructionText"/>                           
            </uix:cellFormat>
            <uix:spacer width="5"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterTimeframe"
                               prompt=""
                               selectedValueBinding="filterTimeframe@servletRequest"
                               tipBinding="SCHEDULED_START_FILTER_HINT@JobsResource">
              <uix:contents childDataBinding="timeframeList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                                
            </uix:cellFormat> 
          </uix:rowLayout> 



    <%--    Owner     --%>
    <%--  ----------  --%>
    <uix:rowLayout>   
     <uix:cellFormat hAlign="right">
     <uix:styledText textBinding="JOBS_TABLE_FILTER_OWNER@JobsResource" 
                              styleClass="OraInstructionText"/>                           
            </uix:cellFormat>
            <uix:spacer width="5"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterOwner"
                               prompt=""
                               selectedValueBinding="filterOwner@servletRequest">
              <uix:contents childDataBinding="ownerList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                                
            </uix:cellFormat>                           
          </uix:rowLayout>

          <!--  Job Type -->
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText textBinding="JOBS_TABLE_HEADER_JOB_TYPE@JobsResource"
                              styleClass="OraInstructionText"/>
            </uix:cellFormat>
            <uix:spacer width="10"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterType"
                               prompt=""
                               selectedValueBinding="filterType@servletRequest">
              <uix:contents childDataBinding="filterList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                   
             
            </uix:cellFormat>                               
          </uix:rowLayout>




          
          <%--    Owner     --%>
          <%--  ----------  --%>
          <%--
          <uix:rowLayout>   
            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_OWNER@JobsResource"
                              styleClass="OraInstructionText"/>                           
            </uix:cellFormat>
            <uix:spacer width="5"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterOwner"
                               prompt=""
                               selectedValueBinding="filterOwner@servletRequest">
              <uix:contents childDataBinding="ownerList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                                
            </uix:cellFormat>                           
          </uix:rowLayout>
         --%>
   
          <%--  Run Status  --%>
          <%--  ----------  --%>
          <%--  Not Shown for Library  --%>
          <%--   
          <uix:rowLayout renderedBinding="showStatusFilter@servletRequest">   
            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_STATUS@JobsResource"
                              styleClass="OraInstructionText"/>                           
            </uix:cellFormat>
            <uix:spacer width="5"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterStatus"
                               prompt=""
                               selectedValueBinding="filterStatus@servletRequest">
              <uix:contents childDataBinding="statusList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                                
            </uix:cellFormat>                           
          </uix:rowLayout>
          --%>
          <%--  Active During (last 24hrs, last 7 days, last 31 days  --%>
          <%--  and Simple-Search button to the right                 --%>
          <%--  ----------------------------------------------------  --%>
          <%--  Not Shown for Library                                 --%>
          <%--
          <uix:rowLayout renderedBinding="showTimeFrameFilter@servletRequest"  
                         vAlign="top">   
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_TIMEFRAME@JobsResource"
                              styleClass="OraInstructionText"/>                           
            </uix:cellFormat>
            <uix:spacer width="5"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterTimeframe"
                               prompt=""
                               selectedValueBinding="filterTimeframe@servletRequest"
                               tipBinding="SCHEDULED_START_FILTER_HINT@JobsResource">
              <uix:contents childDataBinding="timeframeList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                                
            </uix:cellFormat> 
          </uix:rowLayout> 
          --%>

          <%--  Search button   --%>
          <%--  -------------   --%>                  
          <uix:rowLayout>  
            <uix:cellFormat hAlign="right">
              <uix:styledText text=""/>              
            </uix:cellFormat>   
            <uix:spacer width="5"/>        
            <uix:cellFormat hAlign="left">
              <uix:submitButton name="event" 
                                value="doJobFilter" 
                                textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"/>
            </uix:cellFormat>
          </uix:rowLayout>
        
      </uix:tableLayout>  

     </uix:cellFormat>
     
     
     <uix:cellFormat width="60%" hAlign="left" vAlign="top">
     <%--
      <uix:tableLayout>
        <uix:contents>
          
          <%--   Job Type   --%>
          <%--  ----------  --%>        
          <%--
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText textBinding="JOBS_TABLE_HEADER_JOB_TYPE@JobsResource"
                              styleClass="OraInstructionText"/>
            </uix:cellFormat>
            <uix:spacer width="10"/>         
            <uix:cellFormat hAlign="left">
            <uix:messageChoice name="filterType"
                               prompt=""
                               selectedValueBinding="filterType@servletRequest">
              <uix:contents childDataBinding="filterList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                   
             
            </uix:cellFormat>                               
          </uix:rowLayout>
          --%>
          
          <%--  Target Type  --%>
          <%--  -----------  --%>
          <%--  Not Shown for Library  --%>
          <%--
          <uix:rowLayout renderedBinding="showTargetTypeFilter@servletRequest">   
            <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_TARGET_TYPE@JobsResource"
                              styleClass="OraInstructionText"/>                           
            </uix:cellFormat>
            <uix:spacer width="5"/>         
            <uix:cellFormat hAlign="left">

            <uix:messageChoice name="filterTgtType"
                               prompt=""
                               selectedValueBinding="filterTgtType@servletRequest">
              <uix:contents childDataBinding="targetTypeList@servletRequest">
                <uix:option textBinding="text"
                            valueBinding="value"/>
              </uix:contents>                               
            </uix:messageChoice>                                
            </uix:cellFormat>                           
          </uix:rowLayout>          
          --%>   

          <%--  Target Name    --%>
          <%--  ----------  --%>          
          <%--  Not Shown for Library  --%>
          <%--
          <uix:rowLayout renderedBinding="showTargetNameFilter@servletRequest">
              <uix:styledText textBinding="JOBS_TABLE_FILTER_TARGET_NAME@JobsResource"
                              styleClass="OraInstructionText"/>
            </uix:cellFormat>
            <uix:spacer width="5"/>
            <uix:cellFormat hAlign="left">
              <uix:messageTextInput name="filterTgtName" 
                             columns="30"
                             prompt=""
                             textBinding="filterTgtName@servletRequest" />
            </uix:cellFormat>                    
          </uix:rowLayout>
          --%>

          <%--  Show Only jobs I have explicit access to  --%>
          <%--  ----------------------------------------  --%>          
          <%--          Not Shown for Library             --%>
          <%--
          <uix:rowLayout renderedBinding="showAccessCkbox@servletRequest">
            <uix:cellFormat hAlign="right">
              <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:spacer width="5"/>
            <uix:cellFormat hAlign="left" wrappingDisabled="true">
             <uix:contents>
             <uix:stackLayout>
              <uix:contents>
                <uix:checkBox name="showAllJobs" 
                              textBinding="SHOW_ONLY_ACCESS@JobsResource" 
                              checkedBinding="showAllJobs@servletRequest" />
              </uix:contents>                
             </uix:stackLayout>
             </uix:contents>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:contents>
       </uix:tableLayout>
          --%>         

     </uix:cellFormat>                    
     </uix:rowLayout>

    </uix:tableLayout>            
                             
  </uix:header>
   
  <%--  If rendering in Advanced search jobs table is under Results header --%>
  <%--  ------------------------------------------------------------------ --%>
  <uix:styledText styleClass="OraHeaderSubSub" textBinding="JOBS_ADV_RESULTS_HEADER@JobsResource"/>
  

<%--  Simple Serach Mode:                                                   --%>
<%--  --------------------                                                  --%>
<%--  Show the one line Job Type / Job Name filter if in simple search mode --%>
<%--  (if showDefSearch=true)                                                --%>

 <uix:tableLayout width="100%">
 <uix:rowLayout width="100%">
   <uix:cellFormat>
      <uix:spacer width="15" renderedBinding="showAdvSearch@servletRequest"/>
   </uix:cellFormat>
  <uix:cellFormat>
    
<uix:rowLayout width="100%">  

  <uix:cellFormat hAlign="left" 
                  vAlign="middle"
                  renderedBinding="showDefSearch@servletRequest"
                  wrappingDisabled="true">

    <uix:rowLayout>
      <uix:messageChoice name="filterType"
                         promptBinding="JOBS_TABLE_FILTER@JobsResource"
                         selectedValueBinding="filterType@servletRequest">
        <uix:end>
          <uix:textInput name="filterName" 
                         columns="20"
                         textBinding="filterName@servletRequest" />
        </uix:end>
        <uix:contents childDataBinding="filterList@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
      <uix:spacer width="5"/>
      <uix:submitButton name="event" 
                        value="doJobFilter" 
                        textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"/>
    </uix:rowLayout>

  </uix:cellFormat>

  <%-- -----------------------------------------  --%>
  <%--     Job Create dropdown list               --%>
  <%--     Conditionalized Prompt for Library     --%>
  <%-- -----------------------------------------  --%>

<%--  If in Simple search mode show the Advanced Search button (showDefSearch=true) --%>
  <uix:cellFormat hAlign="right" renderedBinding="showDefSearch@servletRequest">
      <uix:submitButton name="event" 
                        value="showAdvancedSearch"
                        renderedBinding="showDefSearch@servletRequest"
                        textBinding="JOBS_TABLE_ADV_SEARCH_BUTTON@JobsResource"/>
  </uix:cellFormat>

</uix:rowLayout>


  <%-- ---------------------------------------------------  --%>
  <%-- View As (Runs / Executions) & Job Create row layout  --%>
  <%-- ---------------------------------------------------  --%>
  <%-- uix:spacer height= "3"/--%>
  
  <uix:rowLayout width="100%">
  <uix:tip renderedBinding="notAllJobsShown@servletRequest"> 
    <uix:styledText textBinding="maxJobsTip@servletRequest" /> 
  </uix:tip>

  </uix:rowLayout>
  
  <%-- Conditionalize this out for library jobs   --%>
  <%-- -----------------------------------------  --%>
  <%-- View As (Runs / Executions) dropdown list  --%>
  <%-- -----------------------------------------  --%>
  <%--
  <uix:rowLayout width="100%">
  

<% 
if (  Boolean.TRUE.equals ( application.getAttribute("em.jobs.ui.advanced") )
   && Boolean.TRUE.equals ( request.getAttribute("showActiveJobsTable") ) ) 
{
%>

    <uix:cellFormat hAlign="left"
                    renderedBinding="showActiveJobsTable@servletRequest">
      <uix:messageChoice name="runsOrExecutionsChoice"
                         promptBinding="JOBS_TABLE_RUNS_OR_EXEC@JobsResource"
                         selectedValueBinding="runsOrExecutionsChoice@servletRequest"
                       	 onChange="submitForm('Jobs', true, {'event':'doRunsOrExecutions'})">

        <uix:contents childDataBinding="runsOrExecutionsList@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
    </uix:cellFormat>

<% 
} 
%>  

    <uix:cellFormat hAlign="right">
      <uix:messageChoice name="newJobChoice"
                         promptBinding="createJobPrompt@servletRequest"
                         selectedValueBinding="creatableJobSelected@servletRequest">
        <uix:end>
          <uix:submitButton name="event" 
                            value="createNew" 
                            textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"/>
        </uix:end>
        <uix:contents childDataBinding="creatableJobList@servletRequest">
          <uix:option textBinding="text"
                      valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
    </uix:cellFormat>
  </uix:rowLayout>
--%>


    <%-- --------------------------------- --%>
    <%-- Conditinalize Runs vs. Executions --%>
    <%-- Still restric rendered w/ ctxType --%>
    <%-- --------------------------------- --%>

    <%-- viewChoice is set on the request URL --%>
    <%-- change value if changed in Java code --%>

    <%-- <uix:styledText text="<%= \"VIEW - viewChoice=\" + request.getAttribute(\"viewChoice\") %>"/>   --%>

<% 
if ( Boolean.TRUE.equals ( request.getAttribute("showLibraryJobsTable") ) ) 
{
%>
        <%@ include file="../libraryTable.jspf" %>
<%
}
else 
//if ( Boolean.TRUE.equals(request.getAttribute("showActiveJobsTable") ) ) 
{ 
  if ( "run".equals(request.getAttribute("viewChoice")) ) 
  { 
%>
        <%@ include file="../runsTable.jspf" %>
<%
  }
  else 
  //if ( "exec".equals(request.getAttribute("viewChoice")) ) 
  {
%>
        <%@ include file="executionsTable.jspf" %>
<%
  }
%>
        <uix:tip renderedBinding="showDatapumpTip@servletRequest">
          <uix:styledText textBinding="DATAPUMP_JOB_STATUS_TIP@JobsResource"/>
        </uix:tip>
<%
}
%>


  </uix:cellFormat>
 </uix:rowLayout>
 </uix:tableLayout>

