<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
 *
 *      NAME
 *       jobsTable.jsp
 *
 *      NOTES
 *       The main jobs page
 *
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
  <uix:bundle name="sdkBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
 <%@ include file="/em2go/em2goHrGlobal.jspf" %>

 
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="header@servletRequest"/>
    </uix:metaContainer>
    
    <uix:body>
    <uix:contents>

        <uix:form name="Jobs" method="POST">
      <%@ include file="/em2go/em2goBreadCrumbs.jspf" %> 
      <uix:styledText styleClass="OraHeaderSubSub" textBinding="header@servletRequest"/>

       <%--
        <uix:pageStatus>
          <oem:pageRefreshed/>
        </uix:pageStatus>
        --%>
     
          
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"/>
          <uix:styledText styleClass="OraInlineErrorText" textBinding="errors@servletRequest"/>

          <oem:messageBox messageType="warning" errorTableBinding="warnings@servletRequest" />
	      <uix:styledText styleClass="OraInlineInfoText" textBinding="warnings@servletRequest"/>
        
          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" />
          <uix:styledText styleClass="OraInlineInfoText" textBinding="info@servletRequest"/>
        

<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
%>
        <uix:messageBox automatic="false" messageBinding="action@servletRequest" messageType="Information">
        <%-- <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest">  --%>

          <uix:link textBinding="jobName@servletRequest" 
                    destinationBinding="jobDest@servletRequest"/>
        </uix:messageBox>
<%
}
%>

   

           <uix:include node="/jobs/em2go/jobsList.jsp"/>
    </uix:form>
    </uix:contents>
    </uix:body>
  </uix:document>
  <%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

