<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, 2004, Oracle Corporation.  All rights reserved.  
 *
 *      NAME
 *       logsDetails.jsp
 *
 *      NOTES
 *       A form view the list of step logs of a job
 *
 * MODIFIED
 *    rdabbott   01/17/04 - Fix 3308086: fix alt text for logs 
 *    rkhazanc   10/23/03 - making changes in the header.
 *    xshen      09/22/03 - add oemTop 
 *    rkhazanc   04/25/03 - rkhazanc_jobs_em2go
 *    rkhazanc   04/21/03 - 
 *    rdabbott   04/03/03 - make the step name the link to the step logs page
 *    rdabbott   03/30/03 - rdabbott_one_results_pg
 *    rdabbott   03/26/03 - creation
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<uix:styledText styleClass="OraHeaderSubSub" textBinding="SUMMARY_LOGS_LINK@JobsResource"/>

<uix:table alternateTextBinding="altText@jobLogsBean@servletRequest"
           formSubmitted="true"
           width="100%"
           tableDataBinding="rowData@jobLogsBean@servletRequest"
           columnHeaderDataBinding="columnHeaders@jobLogsBean@servletRequest"
           minValue="1"
           valueBinding="showValue@jobLogsBean@servletRequest"
           maxValueBinding="maxValue@jobLogsBean@servletRequest"
           blockSizeBinding="blockSize@jobLogsBean@servletRequest">
      
  <uix:tableFormat tableBanding="rowBanding"/>

<uix:columnHeaderStamp>
     <uix:styledText textBinding="text"
                     styleClass="OraTableColumnHeader"/>
  </uix:columnHeaderStamp>
  

  <%-- *** HERE COMES THE ACTUAL CONTENT OF THE TABLE. *** --%>
  <uix:contents>
    <uix:link       textBinding="stepName"  destinationBinding="stepLogEm2goPage" />
    <uix:styledText textBinding="stepTargets"/>
    <uix:styledText textBinding="jobStatus"/>
    <uix:styledText textBinding="startDate"/>
    <uix:styledText textBinding="endDate"/>
  </uix:contents>

</uix:table>

