<%@ include file="/sdk/oemTop.jspf" %>
<%--
 * Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
 *
 *      NAME
 *       results.jsp
 *
 *      NOTES
 *       A form view the summary info of job
 *
--%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui"      prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="JobsResource"
              class="oracle.sysman.resources.eml.jobs.JobsResource"/>
<%@ include file="/em2go/em2goHrGlobal.jspf" %>
<%@ include file="/em2go/em2goBreadCrumbs.jspf" %> 
  <uix:document>
    <uix:body>
    <uix:contents>
      
      <uix:form name="results" method="POST">
      
      <uix:link text="Jobs" 
                    destination="/console/jobs/em2go/jobsTable"/>
      <uix:rowLayout>              
      <uix:styledText styleClass="OraHeaderSubSub" 
	 		       textBinding="header@servletRequest"/>
      </uix:rowLayout>              

        <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"/>
        <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>
       
        <oem:messageBox messageType="warning" 
                        errorTableBinding="warnings@servletRequest" />
        
        <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@warnings@servletRequest"/>

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"/>
        <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>

<%
Object actionAttr = request.getAttribute("action");
if ( null != actionAttr && !"".equals(actionAttr) )
{
System.out.println("Action ");
%>
        <uix:rowLayout>
        </uix:rowLayout>
        
        <uix:styledText styleClass="OraInlineInfoText" textBinding="action@servletRequest"/>

<%
}
%>

          <uix:rowLayout>
            <uix:cellFormat wrappingDisabled="true">
            <uix:contents>
               <uix:flowLayout>
                 <uix:contents>
                    <uix:choice name="optionChoice" selectedIndex="0">
                      <uix:contents childDataBinding="actionsList@summaryBean@servletRequest">
                        <uix:option textBinding="textKey"
                                  valueBinding="valueKey"/>
                      </uix:contents>
                    </uix:choice>
                    
		    <uix:spacer width="2"/>
                  <uix:submitButton textBinding="JOBS_TABLE_GO_BUTTON@JobsResource" name="event" value="gotoEm2go"/>
                  </uix:contents>
                  </uix:flowLayout>
                </uix:contents>
                </uix:cellFormat>
           </uix:rowLayout>
  
     <%--  Need to put a condition so that either Summary or Log is shown --%>

      <uix:styledText textBinding="SUMMARY_SUMMARY_LINK@JobsResource" styleClass="OraHeaderSubSub"/>

<%
//if ( (request.getAttribute("FLAG_LS")).equals("SUM") )
//{
%>
<%--
      <uix:styledText textBinding="SUMMARY_SUMMARY_LINK@JobsResource" styleClass="OraHeaderSubSub"/>
      <uix:spacer width="4"/>
      <uix:link textBinding="SUMMARY_LOGS_LINK@JobsResource" 
                    destinationBinding="logsPage@servletRequest"/>
 --%>                   
<%
//}
//else {
%>
<%--
     <uix:styledText textBinding="SUMMARY_LOGS_LINK@JobsResource" styleClass="OraHeaderSubSub"/>
     <uix:spacer width="4"/>
     <uix:link textBinding="SUMMARY_SUMMARY_LINK@JobsResource" 
                    destinationBinding="sumPage@servletRequest"/>
--%>
<%
//}
%>
        <uix:formValue  name="jobId"   valueBinding="jobId@servletRequest"/>
         <uix:formValue  name="jobType" valueBinding="jobType@servletRequest"/>
         <uix:formValue  name="jobName" valueBinding="jobName@servletRequest"/>

            <%-- *** SHOW THE INCLUDED INFO --%>

<%
if ( request.getAttribute("ctxSummary") != null )
{
%>
            <uix:include node="/jobs/em2go/summaryDetails.jsp"/>
<%
}
%>

<%
if ( request.getAttribute("ctxLogs") != null )
{
%>
            <uix:include node="/jobs/em2go/logsDetails.jsp"/>
<%
}
%>

<%
if ( request.getAttribute("ctxInclude") != null )
{
%>
            <uix:include node="<%= request.getAttribute(\"ctxInclude\") %>"/>
<%
}
%>
<%--dont need this .uri's include  --%>


  </uix:form>
    </uix:contents>
    </uix:body>
  </uix:document>
<%@ include file="/em2go/em2goThinFooter.jspf" %>
</uix:renderingContext>

