<%--
 * Copyright (c) 2003, 2005, Oracle. All rights reserved.  
 *
 *      NAME
 *       jobActivitySegment.jsp
 *
 *      NOTES
 *       job activity page segment
 *
 * MODIFIED
 *    pratagar   05/30/05  - ADA Voilations 
 *    pkantawa   05/03/05  - Prefix event name with segment type 
 *    pkantawa   11/30/04  - Add Create Job dropdown 
 *    pkantawa   10/06/04  - Add details 
 *    pkantawa   09/19/04  - pkantawa_multitask_general_page_ui
 *    pkantawa   09/17/04  - creation
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<oem:pageSegment>
  <uix:dataScope>
    <uix:bundle name="JobsResourceBundle" 
                class="oracle.sysman.resources.emSDK.job.JobSDKMsg"/>
    <uix:bundle name="JobsResource"
                class="oracle.sysman.resources.eml.jobs.JobsResource"/>
              
    <uix:header textBinding="JOBS_TABLE_HEADER_ALL@JobsResourceBundle">
      <%--Create Job dropdown --%>
      <uix:rowLayout width="100%">
        <uix:switcher childNameBinding="jobTypesAvailable@jobStatusTable@servletRequest">
          <uix:case name="true">
            <uix:cellFormat hAlign="right">
              <uix:messageChoice name="newJobChoice"
                                 promptBinding="JOBS_TABLE_CREATE@JobsResource"
                                 selectedValueBinding="selectedJobType@servletRequest">
                <uix:end>
                  <uix:submitButton name="event" 
                                    value="JOB_ACTIVITY_SEGMENT_createNew" 
                                    textBinding="JOBS_TABLE_GO_BUTTON@JobsResource"/>
                </uix:end>
                <uix:contents childDataBinding="jobTypes@jobStatusTable@servletRequest">
                    <uix:option textBinding="text"
                                valueBinding="value"/>
                </uix:contents>
              </uix:messageChoice>
            </uix:cellFormat>
          </uix:case>
          <uix:case name="false">
            <uix:stackLayout>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="GRP_NO_JOB_TYPES_AVAILABLE_TIP@JobsResource"/>
              <uix:spacer height="5"/>
            </uix:stackLayout>
          </uix:case>
        </uix:switcher>  
      </uix:rowLayout>
      
      <%-- Instruction text --%>
      <uix:rowLayout>
        <uix:styledText styleClass="OraInstructionText" 
                        textBinding="statusInstrString@jobStatusTable@servletRequest"/>
      </uix:rowLayout>
      
      <%-- table --%>
      <uix:tableLayout width="100%" hAlign="left">
        <uix:rowLayout>
          <uix:cellFormat>
            <oem:table name="jobStatusTable" 
                       alternateTextBinding="NO_JOB_ACTIVITY@JobsResourceBundle" 
                       width="100%" 
                       summaryBinding="JOBS_TABLE_HEADER_ALL@JobsResourceBundle"		       
                       partialRenderMode="self" 
                       id="jobStatusTable" 
                       dataSourceKey="jobStatusTable"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
